/*
 * Decompiled with CFR 0.152.
 */
package reactor.extra.processor;

import java.util.function.Supplier;
import reactor.extra.processor.NotFunRingBufferFields;
import reactor.extra.processor.RingBuffer;
import reactor.extra.processor.RingBufferProducer;
import reactor.util.annotation.Nullable;

final class NotFunRingBuffer<E>
extends NotFunRingBufferFields<E> {
    NotFunRingBuffer(Supplier<E> eventFactory, RingBufferProducer sequenceProducer) {
        super(eventFactory, sequenceProducer);
    }

    @Override
    E get(long sequence) {
        return this.elementAt(sequence);
    }

    @Override
    long next() {
        return this.next(1);
    }

    @Override
    long next(int n) {
        return this.sequenceProducer.next(n);
    }

    @Override
    void addGatingSequence(RingBuffer.Sequence gatingSequence) {
        this.sequenceProducer.addGatingSequence(gatingSequence);
    }

    @Override
    long getMinimumGatingSequence() {
        return this.getMinimumGatingSequence(null);
    }

    @Override
    long getMinimumGatingSequence(@Nullable RingBuffer.Sequence sequence) {
        return this.sequenceProducer.getMinimumSequence(sequence);
    }

    @Override
    boolean removeGatingSequence(RingBuffer.Sequence sequence) {
        return this.sequenceProducer.removeGatingSequence(sequence);
    }

    @Override
    RingBuffer.Reader newReader() {
        return this.sequenceProducer.newBarrier();
    }

    @Override
    long getCursor() {
        return this.sequenceProducer.getCursor();
    }

    @Override
    int bufferSize() {
        return this.bufferSize;
    }

    @Override
    void publish(long sequence) {
        this.sequenceProducer.publish(sequence);
    }

    @Override
    int getPending() {
        return (int)this.sequenceProducer.getPending();
    }

    @Override
    RingBufferProducer getSequencer() {
        return this.sequenceProducer;
    }
}

