/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.common.serialize.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.serialize.ContextSerializer;
import org.apache.linkis.cs.common.serialize.helper.SerializationHelper;
import org.apache.linkis.cs.common.utils.CSCommonUtils;

public abstract class AbstractSerializationHelper
implements SerializationHelper {
    protected abstract Map<String, ContextSerializer> getContextSerializerMap();

    @Override
    public boolean accepts(String json) {
        return null != this.getContextSerializer(json);
    }

    @Override
    public boolean accepts(Object obj) {
        return null != this.getContextSerializer(obj);
    }

    @Override
    public String serialize(Object obj) throws CSErrorException {
        ContextSerializer contextSerializer = this.getContextSerializer(obj);
        if (null != contextSerializer) {
            return contextSerializer.serialize(obj);
        }
        if (null != obj) {
            throw new CSErrorException(97001, "Failed to find Serializer of " + obj.getClass().getName());
        }
        throw new CSErrorException(97001, "The obj not null");
    }

    @Override
    public Object deserialize(String json) throws CSErrorException {
        ContextSerializer contextSerializer = this.getContextSerializer(json);
        if (contextSerializer != null) {
            return contextSerializer.deserialize(json);
        }
        if (StringUtils.isNotBlank((CharSequence)json)) {
            throw new CSErrorException(97001, "Failed to find deserialize of " + json);
        }
        throw new CSErrorException(97001, "The json not null");
    }

    @Override
    public <T> T deserialize(String s, Class<T> interfaceClass) throws CSErrorException {
        return null;
    }

    private ContextSerializer getContextSerializer(String json) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Map value = (Map)CSCommonUtils.gson.fromJson(json, new HashMap().getClass());
            String type = (String)value.get("type");
            return this.getContextSerializerMap().get(type);
        }
        return null;
    }

    private ContextSerializer getContextSerializer(Object obj) {
        Optional<ContextSerializer> first;
        Stream<ContextSerializer> contextSerializerStream;
        if (null != obj && null != (contextSerializerStream = this.getContextSerializerMap().values().stream().filter(contextSerializer -> contextSerializer.accepts(obj))) && (first = contextSerializerStream.findFirst()).isPresent()) {
            return first.get();
        }
        return null;
    }
}

