/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.common;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;

public abstract class ClassPresentInClassPathCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return ClassPresentInClassPathCondition.isPresent(this.getClassName(), context.getClassLoader());
    }

    protected abstract String getClassName();

    private static boolean isPresent(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        try {
            ClassUtils.forName((String)className, (ClassLoader)classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

