/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.executor.metrics;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import scala.runtime.BoxesRunTime;

public final class ComputationEngineConnMetrics$ {
    public static ComputationEngineConnMetrics$ MODULE$;
    private long lastUpdateTimeMills;
    private long lastUnlockTimeMills;
    private final AtomicLong totalUnlockTimeDurationMills;
    private final AtomicLong totalIdleTimeDurationMills;
    private final AtomicLong totalBusyTimeDurationMills;
    private final AtomicBoolean isKilled;
    private final AtomicLong unlockToShutdownDurationMills;

    static {
        new ComputationEngineConnMetrics$();
    }

    private long lastUpdateTimeMills() {
        return this.lastUpdateTimeMills;
    }

    private void lastUpdateTimeMills_$eq(long x$1) {
        this.lastUpdateTimeMills = x$1;
    }

    private long lastUnlockTimeMills() {
        return this.lastUnlockTimeMills;
    }

    private void lastUnlockTimeMills_$eq(long x$1) {
        this.lastUnlockTimeMills = x$1;
    }

    private AtomicLong totalUnlockTimeDurationMills() {
        return this.totalUnlockTimeDurationMills;
    }

    private AtomicLong totalIdleTimeDurationMills() {
        return this.totalIdleTimeDurationMills;
    }

    private AtomicLong totalBusyTimeDurationMills() {
        return this.totalBusyTimeDurationMills;
    }

    private AtomicBoolean isKilled() {
        return this.isKilled;
    }

    private AtomicLong unlockToShutdownDurationMills() {
        return this.unlockToShutdownDurationMills;
    }

    public void updateMetrics(NodeStatus oldStatus, NodeStatus newStatus) {
        NodeStatus nodeStatus = oldStatus;
        NodeStatus nodeStatus2 = newStatus;
        if (nodeStatus == null ? nodeStatus2 != null : !nodeStatus.equals(nodeStatus2)) {
            long oldUpdateTimeMills = this.lastUpdateTimeMills();
            this.lastUpdateTimeMills_$eq(System.currentTimeMillis());
            long durationMills = this.lastUpdateTimeMills() - oldUpdateTimeMills;
            NodeStatus nodeStatus3 = oldStatus;
            if (NodeStatus.Unlock.equals(nodeStatus3)) {
                BoxesRunTime.boxToLong((long)this.totalUnlockTimeDurationMills().addAndGet(durationMills));
            } else if (NodeStatus.Idle.equals(nodeStatus3)) {
                BoxesRunTime.boxToLong((long)this.totalIdleTimeDurationMills().addAndGet(durationMills));
            } else if (NodeStatus.Busy.equals(nodeStatus3)) {
                BoxesRunTime.boxToLong((long)this.totalBusyTimeDurationMills().addAndGet(durationMills));
            }
            if (NodeStatus.Unlock.equals(newStatus)) {
                this.lastUnlockTimeMills_$eq(System.currentTimeMillis());
            }
            if (NodeStatus.ShuttingDown.equals(newStatus) && NodeStatus.Unlock.equals(oldStatus)) {
                this.unlockToShutdownDurationMills().set(System.currentTimeMillis() - this.lastUnlockTimeMills());
                return;
            }
            return;
        }
    }

    public long getTotalUnLockTimeMills(NodeStatus nodeStatus) {
        NodeStatus nodeStatus2 = nodeStatus;
        if (NodeStatus.Unlock.equals(nodeStatus2)) {
            return this.totalUnlockTimeDurationMills().get() + System.currentTimeMillis() - this.lastUpdateTimeMills();
        }
        return this.totalUnlockTimeDurationMills().get();
    }

    public long getTotalIdleTimeMills(NodeStatus nodeStatus) {
        NodeStatus nodeStatus2 = nodeStatus;
        if (NodeStatus.Idle.equals(nodeStatus2)) {
            return this.totalIdleTimeDurationMills().get() + System.currentTimeMillis() - this.lastUpdateTimeMills();
        }
        return this.totalIdleTimeDurationMills().get();
    }

    public long getTotalBusyTimeMills(NodeStatus nodeStatus) {
        NodeStatus nodeStatus2 = nodeStatus;
        if (NodeStatus.Busy.equals(nodeStatus2)) {
            return this.totalBusyTimeDurationMills().get() + System.currentTimeMillis() - this.lastUpdateTimeMills();
        }
        return this.totalBusyTimeDurationMills().get();
    }

    public long getTotalLockTimeMills(NodeStatus nodeStatus) {
        return this.getTotalBusyTimeMills(nodeStatus) + this.getTotalIdleTimeMills(nodeStatus);
    }

    public long getUnlockToShutdownDurationMills() {
        return this.unlockToShutdownDurationMills().get();
    }

    public long getLastUnlockTimestamp(NodeStatus nodeStatus) {
        NodeStatus nodeStatus2 = nodeStatus;
        if (NodeStatus.Unlock.equals(nodeStatus2)) {
            return this.lastUnlockTimeMills();
        }
        return 0L;
    }

    private ComputationEngineConnMetrics$() {
        MODULE$ = this;
        this.lastUpdateTimeMills = System.currentTimeMillis();
        this.lastUnlockTimeMills = System.currentTimeMillis();
        this.totalUnlockTimeDurationMills = new AtomicLong();
        this.totalIdleTimeDurationMills = new AtomicLong();
        this.totalBusyTimeDurationMills = new AtomicLong();
        this.isKilled = new AtomicBoolean(false);
        this.unlockToShutdownDurationMills = new AtomicLong();
    }
}

