/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.fs;

import java.io.File;
import java.io.IOException;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.storage.domain.FsPathListWithError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileSystem
implements Fs {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystem.class);
    protected String user;
    private String defaultFilePerm = "rwxr-----";
    private String defaultFolderPerm = "rwxr-x---";

    public String getDefaultFilePerm() {
        return this.defaultFilePerm;
    }

    public String getDefaultFolderPerm() {
        return this.defaultFolderPerm;
    }

    public abstract String listRoot() throws IOException;

    public abstract long getTotalSpace(FsPath var1) throws IOException;

    public abstract long getFreeSpace(FsPath var1) throws IOException;

    public abstract long getUsableSpace(FsPath var1) throws IOException;

    public abstract long getLength(FsPath var1) throws IOException;

    public abstract String checkSum(FsPath var1) throws IOException;

    public abstract boolean canExecute(FsPath var1) throws IOException;

    public abstract boolean setOwner(FsPath var1, String var2, String var3) throws IOException;

    public abstract boolean setOwner(FsPath var1, String var2) throws IOException;

    public abstract boolean setGroup(FsPath var1, String var2) throws IOException;

    public abstract boolean copy(String var1, String var2) throws IOException;

    public FsPathListWithError listPathWithError(FsPath path) throws IOException {
        return null;
    }

    public boolean createNewFile(FsPath dest) throws IOException {
        return this.create(dest.getPath());
    }

    public boolean copyFile(FsPath origin, FsPath dest) throws IOException {
        return this.copy(origin.getPath(), dest.getPath());
    }

    public abstract boolean setPermission(FsPath var1, String var2) throws IOException;

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    protected FsPath getParentPath(String path) {
        String parentPath = "";
        parentPath = File.separatorChar == '/' ? new File(path).getParent() : path.substring(0, path.lastIndexOf("/"));
        LOG.info("Get parent path:" + parentPath);
        return new FsPath(parentPath);
    }

    public boolean isOwner(String dest) throws IOException {
        FsPath fsPath = this.get(dest);
        return this.user.equals(fsPath.getOwner()) || this.user.equals(this.rootUserName());
    }
}

