/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.di;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.di.impl.ReflectionUtils;
import org.apache.maven.di.impl.Types;

public abstract class Key<T> {
    private final Type type;
    @Nullable
    private final Object qualifier;
    private int hash;

    protected Key() {
        this(null);
    }

    protected Key(@Nullable Object qualifier) {
        this.type = Types.simplifyType(this.getTypeParameter());
        this.qualifier = qualifier;
    }

    protected Key(Type type, @Nullable Object qualifier) {
        this.type = Types.simplifyType(type);
        this.qualifier = qualifier;
    }

    public static <T> Key<T> of(Class<T> type) {
        return new KeyImpl(type, null);
    }

    public static <T> Key<T> of(Class<T> type, @Nullable Object qualifier) {
        return new KeyImpl(type, qualifier);
    }

    public static <T> Key<T> ofType(Type type) {
        return new KeyImpl(type, null);
    }

    public static <T> Key<T> ofType(Type type, @Nullable Object qualifier) {
        return new KeyImpl(type, qualifier);
    }

    private Type getTypeParameter() {
        Type typeArgument = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Object outerInstance = ReflectionUtils.getOuterClassInstance(this);
        return outerInstance != null ? Types.bind(typeArgument, Types.getAllTypeBindings(outerInstance.getClass())) : typeArgument;
    }

    public Type getType() {
        return this.type;
    }

    public Class<T> getRawType() {
        return Types.getRawType(this.type);
    }

    public <U> Key<U> getTypeParameter(int index) {
        Type type = this.type;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new KeyImpl(parameterizedType.getActualTypeArguments()[index], null);
        }
        throw new IllegalStateException("Expected type from key " + this.getDisplayString() + " to be parameterized");
    }

    @Nullable
    public Object getQualifier() {
        return this.qualifier;
    }

    public String getDisplayString() {
        StringBuilder result = new StringBuilder();
        Object object = this.qualifier;
        if (object instanceof String) {
            String s = (String)object;
            if (s.isEmpty()) {
                result.append("@Named ");
            } else {
                result.append("@Named(\"").append(s).append("\") ");
            }
        } else if (this.qualifier != null) {
            ReflectionUtils.getDisplayString(result, this.qualifier);
            result.append(" ");
        }
        result.append(ReflectionUtils.getDisplayName(this.type));
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Key) {
            Key that = (Key)o;
            return this.type.equals(that.type) && Objects.equals(this.qualifier, that.qualifier);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.hash;
        if (hashCode == 0) {
            this.hash = 31 * this.type.hashCode() + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        }
        return this.hash;
    }

    public String toString() {
        return this.getDisplayString();
    }

    static final class KeyImpl<T>
    extends Key<T> {
        KeyImpl(Type type, Object qualifier) {
            super(type, qualifier);
        }
    }
}

