/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.offline;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.internal.impl.offline.OfflineRepositoryConnector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.PipelineRepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.RepositoryConnector;

@Singleton
@Named(value="offline")
public final class OfflinePipelineRepositoryConnectorFactory
implements PipelineRepositoryConnectorFactory {
    public static final String NAME = "offline";
    private final OfflineController offlineController;
    private float priority = 0.0f;

    @Inject
    public OfflinePipelineRepositoryConnectorFactory(OfflineController offlineController) {
        this.offlineController = Objects.requireNonNull(offlineController);
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository, RepositoryConnector delegate) {
        return new OfflineRepositoryConnector(session, repository, this.offlineController, delegate);
    }

    public float getPriority() {
        return this.priority;
    }

    public OfflinePipelineRepositoryConnectorFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

