/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa.generic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPrivateKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.generic.EdDSAUtils;

public class OpenSSHEd25519PrivateKeyEntryDecoder
extends AbstractPrivateKeyEntryDecoder {
    public static final OpenSSHEd25519PrivateKeyEntryDecoder INSTANCE = new OpenSSHEd25519PrivateKeyEntryDecoder();
    private static final int PK_SIZE = 32;
    private static final int SK_SIZE = 32;
    private static final int KEYPAIR_SIZE = 64;

    public OpenSSHEd25519PrivateKeyEntryDecoder() {
        super(Collections.singletonList("ssh-ed25519"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrivateKey decodePrivateKey(SessionContext session, String keyType, FilePasswordProvider passwordProvider, InputStream keyData) throws IOException, GeneralSecurityException {
        if (!"ssh-ed25519".equals(keyType)) {
            throw new InvalidKeyException("Unsupported key type: " + keyType);
        }
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        byte[] pk = GenericUtils.EMPTY_BYTE_ARRAY;
        byte[] keypair = GenericUtils.EMPTY_BYTE_ARRAY;
        try {
            pk = KeyEntryResolver.readRLEBytes(keyData, 64);
            keypair = KeyEntryResolver.readRLEBytes(keyData, 128);
            if (pk.length != 32) {
                throw new InvalidKeyException(String.format(Locale.ENGLISH, "Unexpected pk size: %s (expected %s)", pk.length, 32));
            }
            if (keypair.length != 64) {
                throw new InvalidKeyException(String.format(Locale.ENGLISH, "Unexpected keypair size: %s (expected %s)", keypair.length, 64));
            }
            if (!Arrays.equals(pk, Arrays.copyOfRange(keypair, 32, 64))) {
                throw new InvalidKeyException("Keypair did not contain the public key.");
            }
            byte[] sk = Arrays.copyOf(keypair, 32);
            PrivateKey privateKey = EdDSAUtils.getPrivateKey(sk);
            PublicKey recoveredPk = this.recoverPublicKey(privateKey);
            if (recoveredPk != null && !Arrays.equals(EdDSAUtils.getBytes(recoveredPk), pk)) {
                throw new InvalidKeyException("The provided pk does NOT match the computed pk for the given sk.");
            }
            PrivateKey privateKey2 = privateKey;
            return privateKey2;
        }
        finally {
            Arrays.fill(pk, (byte)0);
            Arrays.fill(keypair, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encodePrivateKey(SecureByteArrayOutputStream s, PrivateKey key, PublicKey pubKey) throws IOException {
        Objects.requireNonNull(key, "No private key provided");
        byte[] sk = null;
        try {
            byte[] pk = EdDSAUtils.getBytes(pubKey);
            sk = EdDSAUtils.getBytes(key);
            Objects.requireNonNull(sk, "No seed");
            byte[] keypair = new byte[64];
            System.arraycopy(sk, 0, keypair, 0, 32);
            System.arraycopy(pk, 0, keypair, 32, 32);
            KeyEntryResolver.writeRLEBytes((OutputStream)s, pk);
            KeyEntryResolver.writeRLEBytes((OutputStream)s, keypair);
        }
        finally {
            if (sk != null) {
                Arrays.fill(sk, (byte)0);
            }
        }
        return "ssh-ed25519";
    }

    @Override
    public boolean isPublicKeyRecoverySupported() {
        return true;
    }

    @Override
    public PublicKey recoverPublicKey(PrivateKey prvKey) throws GeneralSecurityException {
        return SecurityUtils.recoverEDDSAPublicKey(prvKey);
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("Ed25519");
    }

    @Override
    public KeyPair generateKeyPair(int keySize) throws GeneralSecurityException {
        return this.getKeyPairGenerator().generateKeyPair();
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("Ed25519");
    }
}

