/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractStreamingClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.JdkClientHttpResponse;
import org.springframework.http.client.OutputStreamPublisher;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

class JdkClientHttpRequest
extends AbstractStreamingClientHttpRequest {
    private static final OutputStreamPublisher.ByteMapper<ByteBuffer> BYTE_MAPPER = new ByteBufferMapper();
    private static final Set<String> DISALLOWED_HEADERS = JdkClientHttpRequest.disallowedHeaders();
    private final HttpClient httpClient;
    private final HttpMethod method;
    private final URI uri;
    private final Executor executor;
    @Nullable
    private final Duration timeout;

    public JdkClientHttpRequest(HttpClient httpClient, URI uri, HttpMethod method, Executor executor, @Nullable Duration readTimeout) {
        this.httpClient = httpClient;
        this.uri = uri;
        this.method = method;
        this.executor = executor;
        this.timeout = readTimeout;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body2) throws IOException {
        try {
            HttpRequest request = this.buildRequest(headers, body2);
            HttpResponse<InputStream> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            return new JdkClientHttpResponse(response);
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException("Could not send request: " + ex.getMessage(), ex);
        }
    }

    private HttpRequest buildRequest(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body2) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(this.uri);
        if (this.timeout != null) {
            builder.timeout(this.timeout);
        }
        headers.forEach((headerName, headerValues) -> {
            if (!DISALLOWED_HEADERS.contains(headerName.toLowerCase())) {
                for (String headerValue : headerValues) {
                    builder.header((String)headerName, headerValue);
                }
            }
        });
        builder.method(this.method.name(), this.bodyPublisher(headers, body2));
        return builder.build();
    }

    private HttpRequest.BodyPublisher bodyPublisher(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body2) {
        if (body2 != null) {
            Flow.Publisher<ByteBuffer> outputStreamPublisher = OutputStreamPublisher.create(outputStream -> body2.writeTo(StreamUtils.nonClosing((OutputStream)outputStream)), BYTE_MAPPER, this.executor);
            long contentLength = headers.getContentLength();
            if (contentLength > 0L) {
                return HttpRequest.BodyPublishers.fromPublisher(outputStreamPublisher, contentLength);
            }
            if (contentLength == 0L) {
                return HttpRequest.BodyPublishers.noBody();
            }
            return HttpRequest.BodyPublishers.fromPublisher(outputStreamPublisher);
        }
        return HttpRequest.BodyPublishers.noBody();
    }

    private static Set<String> disallowedHeaders() {
        TreeSet<String> headers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        headers.addAll(Set.of("connection", "content-length", "expect", "host", "upgrade"));
        String headersToAllow = System.getProperty("jdk.httpclient.allowRestrictedHeaders");
        if (headersToAllow != null) {
            Set toAllow = StringUtils.commaDelimitedListToSet((String)headersToAllow);
            headers.removeAll(toAllow);
        }
        return Collections.unmodifiableSet(headers);
    }

    private static final class ByteBufferMapper
    implements OutputStreamPublisher.ByteMapper<ByteBuffer> {
        private ByteBufferMapper() {
        }

        @Override
        public ByteBuffer map(int b) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(1);
            byteBuffer.put((byte)b);
            byteBuffer.flip();
            return byteBuffer;
        }

        @Override
        public ByteBuffer map(byte[] b, int off, int len) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(len);
            byteBuffer.put(b, off, len);
            byteBuffer.flip();
            return byteBuffer;
        }
    }
}

