/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public class DateLabel
extends Label {
    private static final long serialVersionUID = 1L;
    private FastDateFormat fmt;

    public DateLabel(String id) {
        super(id);
        this.initFmt();
    }

    public DateLabel(String id, IModel<?> model) {
        super(id, model);
        this.initFmt();
    }

    private void initFmt() {
        this.fmt = FastDateFormat.getDateTimeInstance((int)2, (int)2, (Locale)this.getLocale());
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        Object o = this.getDefaultModelObject();
        String s = this.getDefaultModelObjectAsString();
        if (o != null) {
            if (o instanceof Date || o.getClass().isAssignableFrom(Date.class)) {
                s = this.fmt.format((Date)o);
            } else if (o instanceof Calendar || o.getClass().isAssignableFrom(Calendar.class)) {
                s = this.fmt.format((Calendar)o);
            }
        }
        this.replaceComponentTagBody(markupStream, openTag, s);
    }
}

