/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.upsertcompaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.restlet.resources.ValidDocIdsMetadataInfo;
import org.apache.pinot.common.restlet.resources.ValidDocIdsType;
import org.apache.pinot.common.utils.ServiceStatus;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.helix.core.minion.generator.BaseTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.TaskGeneratorUtils;
import org.apache.pinot.controller.util.ServerSegmentMetadataReader;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.spi.annotations.minion.TaskGenerator;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.Enablement;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TaskGenerator
public class UpsertCompactionTaskGenerator
extends BaseTaskGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpsertCompactionTaskGenerator.class);
    private static final String DEFAULT_BUFFER_PERIOD = "7d";
    private static final double DEFAULT_INVALID_RECORDS_THRESHOLD_PERCENT = 0.0;
    private static final long DEFAULT_INVALID_RECORDS_THRESHOLD_COUNT = 1L;
    private static final int DEFAULT_NUM_SEGMENTS_BATCH_PER_SERVER_REQUEST = 500;

    public String getTaskType() {
        return "UpsertCompactionTask";
    }

    public List<PinotTaskConfig> generateTasks(List<TableConfig> tableConfigs) {
        String taskType = "UpsertCompactionTask";
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        for (TableConfig tableConfig : tableConfigs) {
            BiMap serverToEndpoints;
            List allSegments;
            String tableNameWithType = tableConfig.getTableName();
            LOGGER.info("Start generating task configs for table: {}", (Object)tableNameWithType);
            if (tableConfig.getTaskConfig() == null) {
                LOGGER.warn("Task config is null for table: {}", (Object)tableNameWithType);
                continue;
            }
            Map taskConfigs = tableConfig.getTaskConfig().getConfigsForTaskType(taskType);
            List<SegmentZKMetadata> completedSegments = UpsertCompactionTaskGenerator.getCompletedSegments(taskConfigs, allSegments = this._clusterInfoAccessor.getSegmentsZKMetadata(tableNameWithType), System.currentTimeMillis());
            if (completedSegments.isEmpty()) {
                LOGGER.info("No completed segments were eligible for compaction for table: {}", (Object)tableNameWithType);
                continue;
            }
            Map incompleteTasks = TaskGeneratorUtils.getIncompleteTasks((String)taskType, (String)tableNameWithType, (ClusterInfoAccessor)this._clusterInfoAccessor);
            if (!incompleteTasks.isEmpty()) {
                LOGGER.warn("Found incomplete tasks: {} for same table: {} and task type: {}. Skipping task generation.", new Object[]{incompleteTasks.keySet(), tableNameWithType, taskType});
                continue;
            }
            PinotHelixResourceManager pinotHelixResourceManager = this._clusterInfoAccessor.getPinotHelixResourceManager();
            Map serverToSegments = pinotHelixResourceManager.getServerToOnlineSegmentsMapFromEV(tableNameWithType, true);
            try {
                serverToEndpoints = pinotHelixResourceManager.getDataInstanceAdminEndpoints(serverToSegments.keySet());
            }
            catch (InvalidConfigException e) {
                throw new RuntimeException(e);
            }
            ServerSegmentMetadataReader serverSegmentMetadataReader = new ServerSegmentMetadataReader(this._clusterInfoAccessor.getExecutor(), (HttpClientConnectionManager)this._clusterInfoAccessor.getConnectionManager());
            String validDocIdsTypeStr = taskConfigs.getOrDefault("validDocIdsType", ValidDocIdsType.SNAPSHOT.toString());
            ValidDocIdsType validDocIdsType = ValidDocIdsType.valueOf((String)validDocIdsTypeStr.toUpperCase());
            int numSegmentsBatchPerServerRequest = Integer.parseInt(taskConfigs.getOrDefault("numSegmentsBatchPerServerRequest", String.valueOf(500)));
            Map validDocIdsMetadataList = serverSegmentMetadataReader.getSegmentToValidDocIdsMetadataFromServer(tableNameWithType, serverToSegments, serverToEndpoints, null, 60000, validDocIdsType.toString(), numSegmentsBatchPerServerRequest);
            Map<String, SegmentZKMetadata> completedSegmentsMap = completedSegments.stream().collect(Collectors.toMap(SegmentZKMetadata::getSegmentName, Function.identity()));
            SegmentSelectionResult segmentSelectionResult = UpsertCompactionTaskGenerator.processValidDocIdsMetadata(taskConfigs, completedSegmentsMap, validDocIdsMetadataList);
            int skippedSegmentsCount = validDocIdsMetadataList.size() - segmentSelectionResult.getSegmentsForCompaction().size() - segmentSelectionResult.getSegmentsForDeletion().size();
            LOGGER.info("Selected {} segments for compaction, {} segments for deletion and skipped {} segments for table: {}", new Object[]{segmentSelectionResult.getSegmentsForCompaction().size(), segmentSelectionResult.getSegmentsForDeletion().size(), skippedSegmentsCount, tableNameWithType});
            if (!segmentSelectionResult.getSegmentsForDeletion().isEmpty()) {
                pinotHelixResourceManager.deleteSegments(tableNameWithType, segmentSelectionResult.getSegmentsForDeletion(), "0d");
                LOGGER.info("Deleted segments containing only invalid records for table: {}, number of segments to be deleted: {}", (Object)tableNameWithType, segmentSelectionResult.getSegmentsForDeletion());
            }
            int numTasks = 0;
            int maxTasks = UpsertCompactionTaskGenerator.getMaxTasks(taskType, tableNameWithType, taskConfigs);
            for (SegmentZKMetadata segment : segmentSelectionResult.getSegmentsForCompaction()) {
                if (numTasks == maxTasks) break;
                if (StringUtils.isBlank((CharSequence)segment.getDownloadUrl())) {
                    LOGGER.warn("Skipping segment {} for task {} as download url is empty", (Object)segment.getSegmentName(), (Object)taskType);
                    continue;
                }
                HashMap<String, Object> configs = new HashMap<String, Object>(this.getBaseTaskConfigs(tableConfig, List.of(segment.getSegmentName())));
                configs.put("downloadURL", segment.getDownloadUrl());
                configs.put("uploadURL", this._clusterInfoAccessor.getVipUrl() + "/segments");
                configs.put("crc", String.valueOf(segment.getCrc()));
                configs.put("validDocIdsType", validDocIdsType.toString());
                configs.put("ignoreCrcMismatch", taskConfigs.getOrDefault("ignoreCrcMismatch", String.valueOf(false)));
                pinotTaskConfigs.add(new PinotTaskConfig("UpsertCompactionTask", configs));
                ++numTasks;
            }
            LOGGER.info("Finished generating {} tasks configs for table: {}", (Object)numTasks, (Object)tableNameWithType);
        }
        return pinotTaskConfigs;
    }

    @VisibleForTesting
    public static SegmentSelectionResult processValidDocIdsMetadata(Map<String, String> taskConfigs, Map<String, SegmentZKMetadata> completedSegmentsMap, Map<String, List<ValidDocIdsMetadataInfo>> validDocIdsMetadataInfoMap) {
        double invalidRecordsThresholdPercent = Double.parseDouble(taskConfigs.getOrDefault("invalidRecordsThresholdPercent", String.valueOf(0.0)));
        long invalidRecordsThresholdCount = Long.parseLong(taskConfigs.getOrDefault("invalidRecordsThresholdCount", String.valueOf(1L)));
        ArrayList<Pair> segmentsForCompaction = new ArrayList<Pair>();
        ArrayList<String> segmentsForDeletion = new ArrayList<String>();
        block0: for (String segmentName : validDocIdsMetadataInfoMap.keySet()) {
            if (!completedSegmentsMap.containsKey(segmentName)) {
                LOGGER.warn("Segment {} is not found in the completed segments list, skipping it for compaction", (Object)segmentName);
                continue;
            }
            SegmentZKMetadata segment = completedSegmentsMap.get(segmentName);
            for (ValidDocIdsMetadataInfo validDocIdsMetadata : validDocIdsMetadataInfoMap.get(segmentName)) {
                long totalInvalidDocs = validDocIdsMetadata.getTotalInvalidDocs();
                if (segment.getCrc() != Long.parseLong(validDocIdsMetadata.getSegmentCrc())) {
                    LOGGER.warn("CRC mismatch for segment: {}, (segmentZKMetadata={}, validDocIdsMetadata={})", new Object[]{segmentName, segment.getCrc(), validDocIdsMetadata.getSegmentCrc()});
                    continue;
                }
                if (validDocIdsMetadata.getServerStatus() != null && !validDocIdsMetadata.getServerStatus().equals((Object)ServiceStatus.Status.GOOD)) {
                    LOGGER.warn("Server {} is in {} state, skipping {} generation for segment: {}", new Object[]{validDocIdsMetadata.getInstanceId(), validDocIdsMetadata.getServerStatus(), "UpsertCompactionTask", segmentName});
                    continue;
                }
                long totalDocs = validDocIdsMetadata.getTotalDocs();
                double invalidRecordPercent = (double)totalInvalidDocs / (double)totalDocs * 100.0;
                if (totalInvalidDocs == totalDocs) {
                    LOGGER.debug("Segment {} contains only invalid records, adding it to the deletion list", (Object)segmentName);
                    segmentsForDeletion.add(segment.getSegmentName());
                    continue block0;
                }
                if (invalidRecordPercent >= invalidRecordsThresholdPercent && totalInvalidDocs >= invalidRecordsThresholdCount) {
                    LOGGER.debug("Segment {} contains {} invalid records out of {} total records (count threshold: {}, percent threshold: {}), adding it to the compaction list", new Object[]{segmentName, totalInvalidDocs, totalDocs, invalidRecordsThresholdCount, invalidRecordsThresholdPercent});
                    segmentsForCompaction.add(Pair.of((Object)segment, (Object)totalInvalidDocs));
                    continue block0;
                }
                LOGGER.debug("Segment {} contains {} invalid records out of {} total records (count threshold: {}, percent threshold: {}), skipping it for compaction", new Object[]{segmentName, totalInvalidDocs, totalDocs, invalidRecordsThresholdCount, invalidRecordsThresholdPercent});
                continue block0;
            }
        }
        segmentsForCompaction.sort((o1, o2) -> {
            if ((Long)o1.getValue() > (Long)o2.getValue()) {
                return -1;
            }
            if (((Long)o1.getValue()).equals(o2.getValue())) {
                return 0;
            }
            return 1;
        });
        return new SegmentSelectionResult(segmentsForCompaction.stream().map(Map.Entry::getKey).collect(Collectors.toList()), segmentsForDeletion);
    }

    @VisibleForTesting
    public static List<SegmentZKMetadata> getCompletedSegments(Map<String, String> taskConfigs, List<SegmentZKMetadata> allSegments, long currentTimeInMillis) {
        ArrayList<SegmentZKMetadata> completedSegments = new ArrayList<SegmentZKMetadata>();
        String bufferPeriod = taskConfigs.getOrDefault("bufferTimePeriod", DEFAULT_BUFFER_PERIOD);
        long bufferMs = TimeUtils.convertPeriodToMillis((String)bufferPeriod);
        for (SegmentZKMetadata segment : allSegments) {
            CommonConstants.Segment.Realtime.Status status = segment.getStatus();
            if (!status.isCompleted() || segment.getEndTimeMs() > currentTimeInMillis - bufferMs) continue;
            completedSegments.add(segment);
        }
        return completedSegments;
    }

    @VisibleForTesting
    public static int getMaxTasks(String taskType, String tableNameWithType, Map<String, String> taskConfigs) {
        int maxTasks = Integer.MAX_VALUE;
        String tableMaxNumTasksConfig = taskConfigs.get("tableMaxNumTasks");
        if (tableMaxNumTasksConfig != null) {
            try {
                maxTasks = Integer.parseInt(tableMaxNumTasksConfig);
            }
            catch (Exception e) {
                LOGGER.warn("MaxNumTasks have been wrongly set for table : {}, and task {}", (Object)tableNameWithType, (Object)taskType);
            }
        }
        return maxTasks;
    }

    public void validateTaskConfigs(TableConfig tableConfig, Schema schema, Map<String, String> taskConfigs) {
        Preconditions.checkState((tableConfig.getTableType() == TableType.REALTIME ? 1 : 0) != 0, (Object)"UpsertCompactionTask only supports realtime tables!");
        Preconditions.checkState((boolean)tableConfig.isUpsertEnabled(), (Object)"Upsert must be enabled for UpsertCompactionTask");
        if (taskConfigs.containsKey("bufferTimePeriod")) {
            TimeUtils.convertPeriodToMillis((String)taskConfigs.get("bufferTimePeriod"));
        }
        if (taskConfigs.containsKey("invalidRecordsThresholdPercent")) {
            Preconditions.checkState((Double.parseDouble(taskConfigs.get("invalidRecordsThresholdPercent")) >= 0.0 && Double.parseDouble(taskConfigs.get("invalidRecordsThresholdPercent")) <= 100.0 ? 1 : 0) != 0, (Object)"invalidRecordsThresholdPercent must be >= 0 and <= 100");
        }
        if (taskConfigs.containsKey("invalidRecordsThresholdCount")) {
            Preconditions.checkState((Long.parseLong(taskConfigs.get("invalidRecordsThresholdCount")) >= 1L ? 1 : 0) != 0, (Object)"invalidRecordsThresholdCount must be >= 1");
        }
        Preconditions.checkState((taskConfigs.containsKey("invalidRecordsThresholdPercent") || taskConfigs.containsKey("invalidRecordsThresholdCount") ? 1 : 0) != 0, (Object)"invalidRecordsThresholdPercent or invalidRecordsThresholdCount or both must be provided");
        String validDocIdsType = taskConfigs.getOrDefault("validDocIdsType", "snapshot");
        if (validDocIdsType.equals(ValidDocIdsType.SNAPSHOT.toString())) {
            UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
            assert (upsertConfig != null);
            Preconditions.checkState((upsertConfig.getSnapshot() != Enablement.DISABLE ? 1 : 0) != 0, (String)"'snapshot' from UpsertConfig must not be 'DISABLE' for UpsertCompactionTask with validDocIdsType = %s", (Object)validDocIdsType);
        } else if (validDocIdsType.equals(ValidDocIdsType.IN_MEMORY_WITH_DELETE.toString())) {
            UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
            assert (upsertConfig != null);
            Preconditions.checkNotNull((Object)upsertConfig.getDeleteRecordColumn(), (Object)String.format("deleteRecordColumn must be provided for UpsertCompactionTask with validDocIdsType = %s", validDocIdsType));
        }
    }

    public static class SegmentSelectionResult {
        private final List<SegmentZKMetadata> _segmentsForCompaction;
        private final List<String> _segmentsForDeletion;

        SegmentSelectionResult(List<SegmentZKMetadata> segmentsForCompaction, List<String> segmentsForDeletion) {
            this._segmentsForCompaction = segmentsForCompaction;
            this._segmentsForDeletion = segmentsForDeletion;
        }

        public List<SegmentZKMetadata> getSegmentsForCompaction() {
            return this._segmentsForCompaction;
        }

        public List<String> getSegmentsForDeletion() {
            return this._segmentsForDeletion;
        }
    }
}

