/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.clplog;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLPLogRecordExtractorConfig
implements RecordExtractorConfig {
    public static final String FIELDS_FOR_CLP_ENCODING_CONFIG_KEY = "fieldsForClpEncoding";
    public static final String FIELDS_FOR_CLP_ENCODING_SEPARATOR = ",";
    public static final String REMOVE_PROCESSED_FIELDS_CONFIG_KEY = "removeProcessedFields";
    public static final String UNENCODABLE_FIELD_SUFFIX_CONFIG_KEY = "unencodableFieldSuffix";
    public static final String UNENCODABLE_FIELD_ERROR_CONFIG_KEY = "unencodableFieldError";
    public static final String TOPIC_NAME_DESTINATION_COLUMN_CONFIG_KEY = "topicNameDestinationColumn";
    private static final Logger LOGGER = LoggerFactory.getLogger(CLPLogRecordExtractorConfig.class);
    private final Set<String> _fieldsForClpEncoding = new HashSet<String>();
    private String _unencodableFieldSuffix = null;
    private String _unencodableFieldError = null;
    private boolean _removeProcessedFields = false;
    private String _topicNameDestinationColumn = null;

    public void init(Map<String, String> props) {
        String unencodableFieldError;
        String[] fieldNames;
        String concatenatedFieldNames;
        super.init(props);
        if (null == props) {
            return;
        }
        String topicNameDestinationColumn = props.get(TOPIC_NAME_DESTINATION_COLUMN_CONFIG_KEY);
        if (null != topicNameDestinationColumn) {
            if (topicNameDestinationColumn.length() == 0) {
                LOGGER.warn("Ignoring empty value for {}", (Object)TOPIC_NAME_DESTINATION_COLUMN_CONFIG_KEY);
            } else {
                this._topicNameDestinationColumn = topicNameDestinationColumn;
            }
        }
        if (null == (concatenatedFieldNames = props.get(FIELDS_FOR_CLP_ENCODING_CONFIG_KEY))) {
            return;
        }
        for (String fieldName : fieldNames = concatenatedFieldNames.split(FIELDS_FOR_CLP_ENCODING_SEPARATOR)) {
            if (fieldName.isEmpty()) {
                LOGGER.warn("Ignoring empty field name in {}", (Object)FIELDS_FOR_CLP_ENCODING_CONFIG_KEY);
                continue;
            }
            this._fieldsForClpEncoding.add(fieldName);
        }
        this._removeProcessedFields = Boolean.parseBoolean(props.get(REMOVE_PROCESSED_FIELDS_CONFIG_KEY));
        String unencodableFieldSuffix = props.get(UNENCODABLE_FIELD_SUFFIX_CONFIG_KEY);
        if (null != unencodableFieldSuffix) {
            if (unencodableFieldSuffix.length() == 0) {
                LOGGER.warn("Ignoring empty value for {}", (Object)UNENCODABLE_FIELD_SUFFIX_CONFIG_KEY);
            } else {
                this._unencodableFieldSuffix = unencodableFieldSuffix;
            }
        }
        if (null != (unencodableFieldError = props.get(UNENCODABLE_FIELD_ERROR_CONFIG_KEY))) {
            if (unencodableFieldError.length() == 0) {
                LOGGER.warn("Ignoring empty value for {}", (Object)UNENCODABLE_FIELD_ERROR_CONFIG_KEY);
            } else {
                this._unencodableFieldError = unencodableFieldError;
            }
        }
    }

    public Set<String> getFieldsForClpEncoding() {
        return this._fieldsForClpEncoding;
    }

    public boolean getRemoveProcessedFields() {
        return this._removeProcessedFields;
    }

    public String getUnencodableFieldSuffix() {
        return this._unencodableFieldSuffix;
    }

    public String getUnencodableFieldError() {
        return this._unencodableFieldError;
    }

    public String getTopicNameDestinationColumn() {
        return this._topicNameDestinationColumn;
    }
}

