/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import kafka.common.InconsistentBrokerMetadataException;
import kafka.common.KafkaException;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.RawMetaProperties;
import kafka.server.RawMetaProperties$;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BrokerMetadataCheckpoint$
implements Logging {
    public static BrokerMetadataCheckpoint$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new BrokerMetadataCheckpoint$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Tuple2<RawMetaProperties, Seq<String>> getBrokerMetadataAndOfflineDirs(Seq<String> logDirs, boolean ignoreMissing) {
        Predef$.MODULE$.require(logDirs.nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Must have at least one log dir to read meta.properties");
        HashMap brokerMetadataMap = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
        ArrayBuffer offlineDirs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        logDirs.foreach((Function1<String, Object> & Serializable & scala.Serializable)logDir -> {
            File brokerCheckpointFile = new File((String)logDir, "meta.properties");
            try {
                Object object;
                Option<Properties> option = new BrokerMetadataCheckpoint(brokerCheckpointFile).read();
                if (option instanceof Some) {
                    Properties properties = (Properties)((Some)option).value();
                    object = brokerMetadataMap.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(logDir), properties));
                } else if (None$.MODULE$.equals(option)) {
                    if (!ignoreMissing) {
                        throw new KafkaException(new StringBuilder(89).append("No `meta.properties` found in ").append((String)logDir).append(" ").append("(have you run `kafka-storage.sh` to format the directory?)").toString());
                    }
                    object = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(option);
                }
                return object;
            }
            catch (IOException e) {
                offlineDirs.$plus$eq(logDir);
                BrokerMetadataCheckpoint$ brokerMetadataCheckpoint$ = MODULE$;
                if (brokerMetadataCheckpoint$ == null) {
                    throw null;
                }
                BrokerMetadataCheckpoint$ error_this = brokerMetadataCheckpoint$;
                if (error_this.logger().underlying().isErrorEnabled()) {
                    error_this.logger().underlying().error(error_this.msgWithLogIdent(BrokerMetadataCheckpoint$.$anonfun$getBrokerMetadataAndOfflineDirs$3(brokerCheckpointFile)), e);
                }
                return BoxedUnit.UNIT;
            }
        });
        if (brokerMetadataMap.isEmpty()) {
            return new Tuple2<RawMetaProperties, Seq<String>>(new RawMetaProperties(RawMetaProperties$.MODULE$.$lessinit$greater$default$1()), offlineDirs);
        }
        if (brokerMetadataMap.values().toSet().size() > 1) {
            scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder();
            brokerMetadataMap.withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(bl = check$ifrefutable$1 != null)).foreach((Function1<Tuple2, scala.collection.mutable.StringBuilder> & Serializable & scala.Serializable)x$1 -> {
                if (x$1 == null) {
                    throw new MatchError((Object)null);
                }
                String logDir = (String)x$1._1();
                Properties brokerMetadata = (Properties)x$1._2();
                scala.collection.mutable.StringBuilder stringBuilder = builder.$plus$plus$eq(new StringBuilder(7).append("- ").append(logDir).append(" -> ").append(brokerMetadata).append("\n").toString());
                return stringBuilder;
            });
            throw new InconsistentBrokerMetadataException(new StringBuilder(186).append("BrokerMetadata is not consistent across log.dirs. This could happen if multiple brokers shared a log directory (log.dirs) ").append("or partial data was manually copied from another broker. Found:\n").append(builder.toString()).toString());
        }
        RawMetaProperties rawProps = new RawMetaProperties((Properties)((Tuple2)brokerMetadataMap.head())._2());
        return new Tuple2<RawMetaProperties, Seq<String>>(rawProps, offlineDirs);
    }

    public static final /* synthetic */ String $anonfun$getBrokerMetadataAndOfflineDirs$3(File brokerCheckpointFile$1) {
        return new StringBuilder(15).append("Failed to read ").append(brokerCheckpointFile$1).toString();
    }

    private BrokerMetadataCheckpoint$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

