/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.log.LogOffsetSnapshot;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.FetchTxnCommitted$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;

@ScalaSignature(bytes="\u0006\u0001\r4Aa\u0003\u0007\u0001#!Ia\u0003\u0001B\u0001B\u0003%q#\b\u0005\t=\u0001\u0011\t\u0011)A\u0005?!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011!Q\u0003A!A!\u0002\u0013Y\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u000bI\u0003A\u0011A*\t\u000bm\u0003A\u0011\t/\t\u000b\u0001\u0004A\u0011I1\t\u000b\t\u0004A\u0011I1\u0003\u0019\u0011+G.Y=fI\u001a+Go\u00195\u000b\u00055q\u0011AB:feZ,'OC\u0001\u0010\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0007\n\u0005Ua!\u0001\u0005#fY\u0006LX\rZ(qKJ\fG/[8o\u0003\u001d!W\r\\1z\u001bN\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011A\u0001T8oO&\u0011a\u0003F\u0001\u000eM\u0016$8\r['fi\u0006$\u0017\r^1\u0011\u0005M\u0001\u0013BA\u0011\r\u000551U\r^2i\u001b\u0016$\u0018\rZ1uC\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA\n%\u0013\t)CB\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0005MA\u0013BA\u0015\r\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u00039\u0019G.[3oi6+G/\u00193bi\u0006\u00042\u0001\u0007\u0017/\u0013\ti\u0013D\u0001\u0004PaRLwN\u001c\t\u0003_ej\u0011\u0001\r\u0006\u0003cI\nqA]3qY&\u001c\u0017M\u0003\u00024i\u000511m\\7n_:T!aD\u001b\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0005\u0003uA\u0012ab\u00117jK:$X*\u001a;bI\u0006$\u0018-\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB!\u0001$P P\u0013\tq\u0014DA\u0005Gk:\u001cG/[8ocA\u0019\u0001iQ#\u000e\u0003\u0005S!AQ\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002E\u0003\n\u00191+Z9\u0011\ta1\u0005\nT\u0005\u0003\u000ff\u0011a\u0001V;qY\u0016\u0014\u0004CA%K\u001b\u0005\u0011\u0014BA&3\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"aE'\n\u00059c!A\u0005$fi\u000eD\u0007+\u0019:uSRLwN\u001c#bi\u0006\u0004\"\u0001\u0007)\n\u0005EK\"\u0001B+oSR\fa\u0001P5oSRtDc\u0002+V-^C\u0016L\u0017\t\u0003'\u0001AQAF\u0004A\u0002]AQAH\u0004A\u0002}AQAI\u0004A\u0002\rBQAJ\u0004A\u0002\u001dBQAK\u0004A\u0002-BQaO\u0004A\u0002q\n1\u0002\u001e:z\u0007>l\u0007\u000f\\3uKR\tQ\f\u0005\u0002\u0019=&\u0011q,\u0007\u0002\b\u0005>|G.Z1o\u00031yg.\u0012=qSJ\fG/[8o)\u0005y\u0015AC8o\u0007>l\u0007\u000f\\3uK\u0002")
public class DelayedFetch
extends DelayedOperation {
    private final FetchMetadata fetchMetadata;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Option<ClientMetadata> clientMetadata;
    private final Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            IntRef accumulatedSize = IntRef.create(0);
            this.fetchMetadata.fetchPartitionStatus().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
                DelayedFetch.$anonfun$tryComplete$1(this, object, accumulatedSize, x0$1);
                return BoxedUnit.UNIT;
            });
            if (accumulatedSize.elem < this.fetchMetadata.fetchMinBytes()) {
                return false;
            }
            bl = this.forceComplete();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        if (this.fetchMetadata.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
            return;
        }
        DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
    }

    @Override
    public void onComplete() {
        int x$1 = this.fetchMetadata.replicaId();
        boolean x$2 = this.fetchMetadata.fetchOnlyLeader();
        FetchIsolation x$3 = this.fetchMetadata.fetchIsolation();
        int x$4 = this.fetchMetadata.fetchMaxBytes();
        boolean x$5 = this.fetchMetadata.hardMaxBytesLimit();
        Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> x$6 = this.fetchMetadata.fetchPartitionStatus().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            FetchPartitionStatus status = (FetchPartitionStatus)x0$1._2();
            Tuple2<TopicPartition, FetchRequest.PartitionData> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), status.fetchInfo());
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        Option<ClientMetadata> x$7 = this.clientMetadata;
        ReplicaQuota x$8 = this.quota;
        Seq fetchPartitionData = this.replicaManager.readFromLocalLog(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            LogReadResult result2 = (LogReadResult)x0$2._2();
            boolean isReassignmentFetch = $this.fetchMetadata.isFromFollower() && $this.replicaManager.isAddingReplica(tp, $this.fetchMetadata.replicaId());
            Tuple2<TopicPartition, FetchPartitionData> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), result2.toFetchPartitionData(isReassignmentFetch));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        this.responseCallback.apply(fetchPartitionData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$tryComplete$1(DelayedFetch $this, Object nonLocalReturnKey1$1, IntRef accumulatedSize$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError((Object)null);
        TopicPartition topicPartition = (TopicPartition)x0$1._1();
        FetchPartitionStatus fetchStatus = (FetchPartitionStatus)x0$1._2();
        LogOffsetMetadata fetchOffset = fetchStatus.startOffsetMetadata();
        Optional<Integer> fetchLeaderEpoch = fetchStatus.fetchInfo().currentLeaderEpoch;
        try {
            LogOffsetMetadata logOffsetMetadata;
            LogOffsetMetadata logOffsetMetadata2 = fetchOffset;
            LogOffsetMetadata logOffsetMetadata3 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
            if (!(logOffsetMetadata2 == null ? logOffsetMetadata3 != null : !((Object)logOffsetMetadata2).equals(logOffsetMetadata3))) return;
            Partition partition = $this.replicaManager.getPartitionOrException(topicPartition);
            LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(fetchLeaderEpoch, $this.fetchMetadata.fetchOnlyLeader());
            FetchIsolation fetchIsolation = $this.fetchMetadata.fetchIsolation();
            if (FetchLogEnd$.MODULE$.equals(fetchIsolation)) {
                logOffsetMetadata = offsetSnapshot.logEndOffset();
            } else if (FetchHighWatermark$.MODULE$.equals(fetchIsolation)) {
                logOffsetMetadata = offsetSnapshot.highWatermark();
            } else {
                if (!FetchTxnCommitted$.MODULE$.equals(fetchIsolation)) throw new MatchError(fetchIsolation);
                logOffsetMetadata = offsetSnapshot.lastStableOffset();
            }
            if (logOffsetMetadata.messageOffset() != fetchOffset.messageOffset()) {
                if (logOffsetMetadata.onOlderSegment(fetchOffset)) {
                    $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Satisfying fetch ").append($this.fetchMetadata).append(" since it is fetching later segments of partition ").append(topicPartition).append(".").toString());
                    throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, $this.forceComplete());
                }
                if (fetchOffset.onOlderSegment(logOffsetMetadata)) {
                    $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Satisfying fetch ").append($this.fetchMetadata).append(" immediately since it is fetching older segments.").toString());
                    if (!$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.fetchMetadata.replicaId())) {
                        throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, $this.forceComplete());
                    }
                } else if (fetchOffset.messageOffset() < logOffsetMetadata.messageOffset()) {
                    int bytesAvailable = package$.MODULE$.min(logOffsetMetadata.positionDiff(fetchOffset), fetchStatus.fetchInfo().maxBytes);
                    if (!$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.fetchMetadata.replicaId())) {
                        accumulatedSize$1.elem += bytesAvailable;
                    }
                }
            }
            fetchStatus.fetchInfo().lastFetchedEpoch.ifPresent(fetchEpoch -> {
                OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(fetchLeaderEpoch, Predef$.MODULE$.Integer2int((Integer)fetchEpoch), false);
                if (epochEndOffset.errorCode() != Errors.NONE.code() || epochEndOffset.endOffset() == -1L || epochEndOffset.leaderEpoch() == -1) {
                    $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Could not obtain last offset for leader epoch for partition ").append(topicPartition).append(", epochEndOffset=").append(epochEndOffset).append(".").toString());
                    throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, $this.forceComplete());
                }
                if (epochEndOffset.leaderEpoch() < Predef$.MODULE$.Integer2int((Integer)fetchEpoch) || epochEndOffset.endOffset() < fetchStatus$1.fetchInfo().fetchOffset) {
                    $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Satisfying fetch ").append($this.fetchMetadata).append(" since it has diverging epoch requiring truncation for partition ").append(topicPartition).append(" epochEndOffset=").append(epochEndOffset).append(" fetchEpoch=").append(fetchEpoch).append(" fetchOffset=").append(fetchStatus$1.fetchInfo().fetchOffset).append(".").toString());
                    throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, $this.forceComplete());
                }
            });
            return;
        }
        catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
            $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Broker is no longer the leader or follower of ").append(topicPartition).append(", satisfy ").append($this.fetchMetadata).append(" immediately").toString());
            throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Broker no longer knows of partition ").append(topicPartition).append(", satisfy ").append($this.fetchMetadata).append(" immediately").toString());
            throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
        catch (KafkaStorageException kafkaStorageException) {
            $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Partition ").append(topicPartition).append(" is in an offline log directory, satisfy ").append($this.fetchMetadata).append(" immediately").toString());
            throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
        catch (FencedLeaderEpochException fencedLeaderEpochException) {
            $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(119).append("Broker is the leader of partition ").append(topicPartition).append(", but the requested epoch ").append(fetchLeaderEpoch).append(" is fenced by the latest leader epoch, satisfy ").append($this.fetchMetadata).append(" immediately").toString());
            throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
    }

    public DelayedFetch(long delayMs, FetchMetadata fetchMetadata, ReplicaManager replicaManager, ReplicaQuota quota, Option<ClientMetadata> clientMetadata, Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.fetchMetadata = fetchMetadata;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.clientMetadata = clientMetadata;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

