/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaFetcherManager$;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\b\u0011\u0001UA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tC\u0001\u0011)\u0019!C\tE!Aa\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0011!!\u0004A!A!\u0002\u0013)\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u00115\u0003!\u0011!Q\u0001\n9CQ!\u0015\u0001\u0005\u0002ICQA\u0017\u0001\u0005BmCQ!\u001b\u0001\u0005\u0002)<qA\u001c\t\u0002\u0002#\u0005qNB\u0004\u0010!\u0005\u0005\t\u0012\u00019\t\u000bEcA\u0011\u0001;\t\u000fUd\u0011\u0013!C\u0001m\n)\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014(BA\t\u0013\u0003\u0019\u0019XM\u001d<fe*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0002cA\f\u001955\t\u0001#\u0003\u0002\u001a!\t1\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'\u000f\u0005\u0002\u00187%\u0011A\u0004\u0005\u0002\u0015%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0005]y\u0012B\u0001\u0011\u0011\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\t1\u0005\u0005\u0002\u0018I%\u0011Q\u0005\u0005\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013aB7fiJL7m\u001d\t\u0003SIj\u0011A\u000b\u0006\u0003O-R!\u0001L\u0017\u0002\r\r|W.\\8o\u0015\t\u0019bF\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<\u0017BA\u001a+\u0005\u001diU\r\u001e:jGN\fA\u0001^5nKB\u0011a'O\u0007\u0002o)\u0011\u0001hK\u0001\u0006kRLGn]\u0005\u0003u]\u0012A\u0001V5nK\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0004{\u0001\u0013U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\r=\u0003H/[8o!\t\u0019%J\u0004\u0002E\u0011B\u0011QIP\u0007\u0002\r*\u0011q\tF\u0001\u0007yI|w\u000e\u001e \n\u0005%s\u0014A\u0002)sK\u0012,g-\u0003\u0002L\u0019\n11\u000b\u001e:j]\u001eT!!\u0013 \u0002\u0019E,x\u000e^1NC:\fw-\u001a:\u0011\u0005]y\u0015B\u0001)\u0011\u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\b'R+fk\u0016-Z!\t9\u0002\u0001C\u0003\u001e\u0011\u0001\u0007a\u0004C\u0003\"\u0011\u0001\u00071\u0005C\u0003(\u0011\u0001\u0007\u0001\u0006C\u00035\u0011\u0001\u0007Q\u0007C\u0004<\u0011A\u0005\t\u0019\u0001\u001f\t\u000b5C\u0001\u0019\u0001(\u0002'\r\u0014X-\u0019;f\r\u0016$8\r[3s)\"\u0014X-\u00193\u0015\u0007ia\u0016\rC\u0003^\u0013\u0001\u0007a,A\u0005gKR\u001c\u0007.\u001a:JIB\u0011QhX\u0005\u0003Az\u00121!\u00138u\u0011\u0015\u0011\u0017\u00021\u0001d\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\t!w-D\u0001f\u0015\t1'#A\u0004dYV\u001cH/\u001a:\n\u0005!,'A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\tg\",H\u000fZ8x]R\t1\u000e\u0005\u0002>Y&\u0011QN\u0010\u0002\u0005+:LG/A\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0011\u0005]a1C\u0001\u0007r!\ti$/\u0003\u0002t}\t1\u0011I\\=SK\u001a$\u0012a\\\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0003]T#\u0001\u0010=,\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u0013Ut7\r[3dW\u0016$'B\u0001@?\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0003Y(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ReplicaFetcherManager
extends AbstractFetcherManager<ReplicaFetcherThread> {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final Metrics metrics;
    private final Time time;
    private final Option<String> threadNamePrefix;
    private final ReplicationQuotaManager quotaManager;

    public static Option<String> $lessinit$greater$default$5() {
        return ReplicaFetcherManager$.MODULE$.$lessinit$greater$default$5();
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
        String prefix = (String)this.threadNamePrefix.map((Function1<String, String> & java.io.Serializable & Serializable)tp -> new StringBuilder(1).append((String)tp).append(":").toString()).getOrElse((Function0<String> & java.io.Serializable & Serializable)() -> "");
        String threadName = new StringBuilder(22).append(prefix).append("ReplicaFetcherThread-").append(fetcherId).append("-").append(sourceBroker.id()).toString();
        return new ReplicaFetcherThread(threadName, fetcherId, sourceBroker, this.brokerConfig, this.failedPartitions(), this.replicaManager(), this.metrics, this.time, this.quotaManager, ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10());
    }

    public void shutdown() {
        this.info((Function0<String> & java.io.Serializable & Serializable)() -> "shutting down");
        this.closeAllFetchers();
        this.info((Function0<String> & java.io.Serializable & Serializable)() -> "shutdown completed");
    }

    public ReplicaFetcherManager(KafkaConfig brokerConfig, ReplicaManager replicaManager, Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager) {
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaManager = quotaManager;
        super(new StringBuilder(32).append("ReplicaFetcherManager on broker ").append(brokerConfig.brokerId()).toString(), "Replica", Predef$.MODULE$.Integer2int(brokerConfig.numReplicaFetchers()));
    }
}

