/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.stream.StreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfigBackwardCompatibleUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaConfigBackwardCompatibleUtils.class);
    public static final String KAFKA_COMMON_PACKAGE_PREFIX = "org.apache.kafka.common";
    public static final String PINOT_SHADED_PACKAGE_PREFIX = "org.apache.pinot.shaded.";
    public static final String AWS_PROPS_PREFIX = "software.amazon";
    public static final String SASL_JAAS_CONFIG = "sasl.jaas.config";

    private KafkaConfigBackwardCompatibleUtils() {
    }

    public static void handleStreamConfig(StreamConfig streamConfig) {
        Map streamConfigMap = streamConfig.getStreamConfigsMap();
        String prefixToReplace = KAFKA_COMMON_PACKAGE_PREFIX.replace(PINOT_SHADED_PACKAGE_PREFIX, "");
        for (Map.Entry entry : streamConfigMap.entrySet()) {
            CharSequence[] valueParts = StringUtils.split((String)((String)entry.getValue()), (char)' ');
            boolean updated = false;
            for (int i = 0; i < valueParts.length; ++i) {
                if (valueParts[i].startsWith(prefixToReplace)) {
                    try {
                        Class.forName(valueParts[i]);
                    }
                    catch (ClassNotFoundException e1) {
                        try {
                            String shadedClassName = PINOT_SHADED_PACKAGE_PREFIX + (String)valueParts[i];
                            Class.forName(shadedClassName);
                            valueParts[i] = shadedClassName;
                            updated = true;
                        }
                        catch (ClassNotFoundException shadedClassName) {}
                    }
                    continue;
                }
                if (!valueParts[i].startsWith("org.apache.pinot.shaded.software.amazon")) continue;
                try {
                    Class.forName((String)valueParts[i]);
                    continue;
                }
                catch (ClassNotFoundException e1) {
                    try {
                        String unShadedClassName = ((String)valueParts[i]).replace(PINOT_SHADED_PACKAGE_PREFIX, "");
                        Class.forName(unShadedClassName);
                        valueParts[i] = unShadedClassName;
                        updated = true;
                        continue;
                    }
                    catch (ClassNotFoundException unShadedClassName) {
                        // empty catch block
                    }
                }
            }
            if (!updated) continue;
            String originalValue = (String)entry.getValue();
            entry.setValue(String.join((CharSequence)" ", valueParts));
            LOGGER.info("Updated stream config key: {} fromValue: {} toValue: {}", entry.getKey(), originalValue, entry.getValue());
        }
        String loginConfigFile = System.getProperty("java.security.auth.login.config");
        StringBuilder stringBuilder = new StringBuilder();
        if (loginConfigFile != null) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(loginConfigFile)));){
                String line;
                while ((line = br.readLine()) != null) {
                    stringBuilder.append(line).append("\n");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read JAAS config file: " + loginConfigFile, e);
            }
        }
        if (stringBuilder.length() > 0) {
            String jaasContent = stringBuilder.toString();
            boolean updated = false;
            CharSequence[] lines = jaasContent.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String className;
                if (!lines[i].contains(prefixToReplace) || !(className = ((String)lines[i]).trim().split(" ")[0]).startsWith(prefixToReplace)) continue;
                try {
                    Class.forName(className);
                    continue;
                }
                catch (ClassNotFoundException e1) {
                    try {
                        String shadedClassName = PINOT_SHADED_PACKAGE_PREFIX + className.substring(prefixToReplace.length());
                        Class.forName(shadedClassName);
                        lines[i] = ((String)lines[i]).replace(className, shadedClassName);
                        updated = true;
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (updated) {
                String updatedJaasConfig = String.join((CharSequence)"\n", lines);
                String jassConfigProperty = updatedJaasConfig.substring(updatedJaasConfig.indexOf("{") + 1).substring(0, updatedJaasConfig.indexOf("}")).replace("\n", " ");
                streamConfigMap.putIfAbsent(SASL_JAAS_CONFIG, jassConfigProperty);
            }
        }
    }
}

