/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.metrics.dropwizard;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.plugin.metrics.dropwizard.DropWizardHistogram;
import org.apache.pinot.plugin.metrics.dropwizard.DropwizardCounter;
import org.apache.pinot.plugin.metrics.dropwizard.DropwizardGauge;
import org.apache.pinot.plugin.metrics.dropwizard.DropwizardMeter;
import org.apache.pinot.plugin.metrics.dropwizard.DropwizardMetric;
import org.apache.pinot.plugin.metrics.dropwizard.DropwizardMetricName;
import org.apache.pinot.plugin.metrics.dropwizard.DropwizardSettableGauge;
import org.apache.pinot.plugin.metrics.dropwizard.DropwizardTimer;
import org.apache.pinot.spi.metrics.PinotCounter;
import org.apache.pinot.spi.metrics.PinotGauge;
import org.apache.pinot.spi.metrics.PinotHistogram;
import org.apache.pinot.spi.metrics.PinotMeter;
import org.apache.pinot.spi.metrics.PinotMetric;
import org.apache.pinot.spi.metrics.PinotMetricName;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;
import org.apache.pinot.spi.metrics.PinotMetricsRegistryListener;
import org.apache.pinot.spi.metrics.PinotTimer;

public class DropwizardMetricsRegistry
implements PinotMetricsRegistry {
    MetricRegistry _metricRegistry = new MetricRegistry();

    public void removeMetric(PinotMetricName name) {
        this._metricRegistry.remove(name.getMetricName().toString());
    }

    public <T> PinotGauge<T> newGauge(PinotMetricName name, PinotGauge<T> gauge) {
        String metricName = name.getMetricName().toString();
        return gauge == null ? new DropwizardGauge((DropwizardSettableGauge)this._metricRegistry.gauge(metricName)) : new DropwizardGauge(this._metricRegistry.gauge(metricName, () -> (DropwizardSettableGauge)gauge.getGauge()));
    }

    public PinotMeter newMeter(PinotMetricName name, String eventType, TimeUnit unit) {
        return new DropwizardMeter(this._metricRegistry.meter(name.getMetricName().toString()));
    }

    public PinotCounter newCounter(PinotMetricName name) {
        return new DropwizardCounter(this._metricRegistry.counter(name.getMetricName().toString()));
    }

    public PinotTimer newTimer(PinotMetricName name, TimeUnit durationUnit, TimeUnit rateUnit) {
        Timer timer = this._metricRegistry.timer(name.getMetricName().toString(), () -> new Timer(new SlidingTimeWindowArrayReservoir(15L, TimeUnit.MINUTES)));
        return new DropwizardTimer(timer);
    }

    public PinotHistogram newHistogram(PinotMetricName name, boolean biased) {
        Histogram histogram = this._metricRegistry.histogram(name.getMetricName().toString(), () -> new Histogram(new SlidingTimeWindowArrayReservoir(15L, TimeUnit.MINUTES)));
        return new DropWizardHistogram(histogram);
    }

    public Map<PinotMetricName, PinotMetric> allMetrics() {
        Map<String, Metric> dropwizardMetrics = this._metricRegistry.getMetrics();
        HashMap<PinotMetricName, PinotMetric> allMetrics = new HashMap<PinotMetricName, PinotMetric>();
        for (Map.Entry<String, Metric> entry : dropwizardMetrics.entrySet()) {
            allMetrics.put(new DropwizardMetricName(entry.getKey()), new DropwizardMetric(entry.getValue()));
        }
        return allMetrics;
    }

    public void addListener(PinotMetricsRegistryListener listener) {
        this._metricRegistry.addListener((MetricRegistryListener)listener.getMetricsRegistryListener());
    }

    public Object getMetricsRegistry() {
        return this._metricRegistry;
    }

    public void shutdown() {
    }
}

