/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json.jackson2;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

final class JacksonParser
extends JsonParser {
    private final org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser parser;
    private final JsonFactory factory;

    @Override
    public JsonFactory getFactory() {
        return this.factory;
    }

    JacksonParser(JsonFactory factory, org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser parser) {
        this.factory = factory;
        this.parser = parser;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    @Override
    public JsonToken nextToken() throws IOException {
        return JacksonParser.convert(this.parser.nextToken());
    }

    @Override
    public String getCurrentName() throws IOException {
        return this.parser.getCurrentName();
    }

    @Override
    public JsonToken getCurrentToken() {
        return JacksonParser.convert(this.parser.getCurrentToken());
    }

    @Override
    public JsonParser skipChildren() throws IOException {
        this.parser.skipChildren();
        return this;
    }

    @Override
    public String getText() throws IOException {
        return this.parser.getText();
    }

    @Override
    public byte getByteValue() throws IOException {
        return this.parser.getByteValue();
    }

    @Override
    public float getFloatValue() throws IOException {
        return this.parser.getFloatValue();
    }

    @Override
    public int getIntValue() throws IOException {
        return this.parser.getIntValue();
    }

    @Override
    public short getShortValue() throws IOException {
        return this.parser.getShortValue();
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        return this.parser.getBigIntegerValue();
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        return this.parser.getDecimalValue();
    }

    @Override
    public double getDoubleValue() throws IOException {
        return this.parser.getDoubleValue();
    }

    @Override
    public long getLongValue() throws IOException {
        return this.parser.getLongValue();
    }

    private static JsonToken convert(org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken token) {
        if (token == null) {
            return null;
        }
        switch (token) {
            case END_ARRAY: {
                return JsonToken.END_ARRAY;
            }
            case START_ARRAY: {
                return JsonToken.START_ARRAY;
            }
            case END_OBJECT: {
                return JsonToken.END_OBJECT;
            }
            case START_OBJECT: {
                return JsonToken.START_OBJECT;
            }
            case VALUE_FALSE: {
                return JsonToken.VALUE_FALSE;
            }
            case VALUE_TRUE: {
                return JsonToken.VALUE_TRUE;
            }
            case VALUE_NULL: {
                return JsonToken.VALUE_NULL;
            }
            case VALUE_STRING: {
                return JsonToken.VALUE_STRING;
            }
            case VALUE_NUMBER_FLOAT: {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            case VALUE_NUMBER_INT: {
                return JsonToken.VALUE_NUMBER_INT;
            }
            case FIELD_NAME: {
                return JsonToken.FIELD_NAME;
            }
        }
        return JsonToken.NOT_AVAILABLE;
    }
}

