/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcLongRunningClient;
import com.google.api.gax.grpc.GrpcOperationSnapshotCallable;
import com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedBatchingCallable;
import com.google.api.gax.tracing.TracedBidiCallable;
import com.google.api.gax.tracing.TracedClientStreamingCallable;
import com.google.api.gax.tracing.TracedOperationCallable;
import com.google.api.gax.tracing.TracedOperationInitialCallable;
import com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.api.gax.tracing.TracedUnaryCallable;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import io.grpc.MethodDescriptor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableSet;

public class GrpcCallableFactory {
    private static final Pattern FULL_METHOD_NAME_REGEX = Pattern.compile("^.*?([^./]+)/([^./]+)$");

    private GrpcCallableFactory() {
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBaseUnaryCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, UnaryCallSettings<?, ?> callSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = GrpcRawCallableFactory.createUnaryCallable(grpcCallSettings, callSettings.getRetryableCodes());
        callable = grpcCallSettings.getRequestMutator() != null ? Callables.retrying(callable, callSettings, clientContext, grpcCallSettings.getRequestMutator()) : Callables.retrying(callable, callSettings, clientContext);
        return callable;
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, UnaryCallSettings<RequestT, ResponseT> callSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = GrpcCallableFactory.createBaseUnaryCallable(grpcCallSettings, callSettings, clientContext);
        callable = new TracedUnaryCallable<RequestT, ResponseT>(callable, clientContext.getTracerFactory(), GrpcCallableFactory.getSpanName(grpcCallSettings.getMethodDescriptor()));
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT, PagedListResponseT> UnaryCallable<RequestT, PagedListResponseT> createPagedCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, PagedCallSettings<RequestT, ResponseT, PagedListResponseT> pagedCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> innerCallable = GrpcCallableFactory.createBaseUnaryCallable(grpcCallSettings, pagedCallSettings, clientContext);
        UnaryCallable<RequestT, PagedListResponseT> pagedCallable = Callables.paged(innerCallable, pagedCallSettings);
        return pagedCallable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBatchingCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, BatchingCallSettings<RequestT, ResponseT> batchingCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> baseCallable = GrpcCallableFactory.createBaseUnaryCallable(grpcCallSettings, batchingCallSettings, clientContext);
        TracedBatchingCallable<RequestT, ResponseT> tracedCallable = new TracedBatchingCallable<RequestT, ResponseT>(baseCallable, clientContext.getTracerFactory(), GrpcCallableFactory.getSpanName(grpcCallSettings.getMethodDescriptor()), batchingCallSettings.getBatchingDescriptor());
        UnaryCallable<RequestT, ResponseT> batchingCallable = Callables.batching(tracedCallable, batchingCallSettings, clientContext);
        return batchingCallable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT, MetadataT> OperationCallable<RequestT, ResponseT, MetadataT> createOperationCallable(GrpcCallSettings<RequestT, Operation> grpcCallSettings, OperationCallSettings<RequestT, ResponseT, MetadataT> operationCallSettings, ClientContext clientContext, OperationsStub operationsStub) {
        SpanName initialSpanName = GrpcCallableFactory.getSpanName(grpcCallSettings.getMethodDescriptor());
        SpanName operationSpanName = SpanName.of(initialSpanName.getClientName(), initialSpanName.getMethodName() + "Operation");
        UnaryCallable<RequestT, Operation> initialGrpcCallable = GrpcCallableFactory.createBaseUnaryCallable(grpcCallSettings, operationCallSettings.getInitialCallSettings(), clientContext);
        GrpcOperationSnapshotCallable<RequestT> initialCallable = new GrpcOperationSnapshotCallable<RequestT>(initialGrpcCallable);
        TracedOperationInitialCallable tracedInitialCallable = new TracedOperationInitialCallable(initialCallable, clientContext.getTracerFactory(), initialSpanName);
        GrpcLongRunningClient longRunningClient = new GrpcLongRunningClient(operationsStub);
        OperationCallable<RequestT, ResponseT, MetadataT> operationCallable = Callables.longRunningOperation(tracedInitialCallable, operationCallSettings, clientContext, longRunningClient);
        TracedOperationCallable<RequestT, ResponseT, MetadataT> tracedOperationCallable = new TracedOperationCallable<RequestT, ResponseT, MetadataT>(operationCallable, clientContext.getTracerFactory(), operationSpanName);
        return tracedOperationCallable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> BidiStreamingCallable<RequestT, ResponseT> createBidiStreamingCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, StreamingCallSettings<RequestT, ResponseT> streamingCallSettings, ClientContext clientContext) {
        BidiStreamingCallable<RequestT, ResponseT> callable = GrpcRawCallableFactory.createBidiStreamingCallable(grpcCallSettings, ImmutableSet.of());
        callable = new TracedBidiCallable<RequestT, ResponseT>(callable, clientContext.getTracerFactory(), GrpcCallableFactory.getSpanName(grpcCallSettings.getMethodDescriptor()));
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    @Deprecated
    public static <RequestT, ResponseT> ServerStreamingCallable<RequestT, ResponseT> createServerStreamingCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, StreamingCallSettings<RequestT, ResponseT> streamingCallSettings, ClientContext clientContext) {
        StreamingCallSettings serverStreamingCallSettings = ServerStreamingCallSettings.newBuilder().build();
        return GrpcCallableFactory.createServerStreamingCallable(grpcCallSettings, serverStreamingCallSettings, clientContext);
    }

    public static <RequestT, ResponseT> ServerStreamingCallable<RequestT, ResponseT> createServerStreamingCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, ServerStreamingCallSettings<RequestT, ResponseT> streamingCallSettings, ClientContext clientContext) {
        ServerStreamingCallable<RequestT, ResponseT> callable = GrpcRawCallableFactory.createServerStreamingCallable(grpcCallSettings, streamingCallSettings.getRetryableCodes());
        if (clientContext.getStreamWatchdog() != null) {
            callable = Callables.watched(callable, streamingCallSettings, clientContext);
        }
        callable = Callables.retrying(callable, streamingCallSettings, clientContext);
        callable = new TracedServerStreamingCallable<RequestT, ResponseT>(callable, clientContext.getTracerFactory(), GrpcCallableFactory.getSpanName(grpcCallSettings.getMethodDescriptor()));
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> ClientStreamingCallable<RequestT, ResponseT> createClientStreamingCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, StreamingCallSettings<RequestT, ResponseT> streamingCallSettings, ClientContext clientContext) {
        ClientStreamingCallable<RequestT, ResponseT> callable = GrpcRawCallableFactory.createClientStreamingCallable(grpcCallSettings, ImmutableSet.of());
        callable = new TracedClientStreamingCallable<RequestT, ResponseT>(callable, clientContext.getTracerFactory(), GrpcCallableFactory.getSpanName(grpcCallSettings.getMethodDescriptor()));
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    @InternalApi(value="Visible for testing")
    static SpanName getSpanName(@Nonnull MethodDescriptor<?, ?> methodDescriptor) {
        Matcher matcher = FULL_METHOD_NAME_REGEX.matcher(methodDescriptor.getFullMethodName());
        Preconditions.checkArgument(matcher.matches(), "Invalid fullMethodName");
        return SpanName.of(matcher.group(1), matcher.group(2));
    }
}

