/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.ByteArrayContent;
import com.azure.core.implementation.util.ByteBufferContent;
import com.azure.core.implementation.util.FileContent;
import com.azure.core.implementation.util.FluxByteBufferContent;
import com.azure.core.implementation.util.InputStreamContent;
import com.azure.core.implementation.util.ListByteBufferContent;
import com.azure.core.implementation.util.SerializableContent;
import com.azure.core.implementation.util.StringContent;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.JsonSerializerProviders;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BinaryData {
    private static final ClientLogger LOGGER = new ClientLogger(BinaryData.class);
    static final JsonSerializer SERIALIZER = JsonSerializerProviders.createInstance(true);
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private final BinaryDataContent content;

    BinaryData(BinaryDataContent content) {
        this.content = Objects.requireNonNull(content, "'content' cannot be null.");
    }

    public static BinaryData fromStream(InputStream inputStream) {
        return BinaryData.fromStream(inputStream, null);
    }

    public static BinaryData fromStream(InputStream inputStream, Long length) {
        return new BinaryData(new InputStreamContent(inputStream, length));
    }

    public static Mono<BinaryData> fromStreamAsync(InputStream inputStream) {
        return BinaryData.fromStreamAsync(inputStream, null);
    }

    public static Mono<BinaryData> fromStreamAsync(InputStream inputStream, Long length) {
        return Mono.fromCallable(() -> BinaryData.fromStream(inputStream, length));
    }

    public static Mono<BinaryData> fromFlux(Flux<ByteBuffer> data) {
        return BinaryData.fromFlux(data, null);
    }

    public static Mono<BinaryData> fromFlux(Flux<ByteBuffer> data, Long length) {
        return BinaryData.fromFlux(data, length, true);
    }

    public static Mono<BinaryData> fromFlux(Flux<ByteBuffer> data, Long length, boolean bufferContent) {
        if (data == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'data' cannot be null."));
        }
        if (length != null && length < 0L) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalArgumentException("'length' cannot be less than 0."));
        }
        if (!bufferContent) {
            return Mono.just(new BinaryData(new FluxByteBufferContent(data, length)));
        }
        long[] trueLength = new long[]{0L};
        return data.map(buffer -> {
            int bufferSize = buffer.remaining();
            ByteBuffer copy = ByteBuffer.allocate(bufferSize);
            trueLength[0] = trueLength[0] + (long)bufferSize;
            copy.put((ByteBuffer)buffer);
            copy.flip();
            return copy;
        }).collect(LinkedList::new, LinkedList::add).map(buffers -> new BinaryData(new FluxByteBufferContent(Flux.fromIterable(buffers).map(ByteBuffer::duplicate), length != null ? length : trueLength[0], true)));
    }

    public static BinaryData fromString(String data) {
        return new BinaryData(new StringContent(data));
    }

    public static BinaryData fromBytes(byte[] data) {
        return new BinaryData(new ByteArrayContent(data));
    }

    public static BinaryData fromByteBuffer(ByteBuffer data) {
        return new BinaryData(new ByteBufferContent(data));
    }

    public static BinaryData fromListByteBuffer(List<ByteBuffer> data) {
        return new BinaryData(new ListByteBufferContent(data));
    }

    public static BinaryData fromObject(Object data) {
        return BinaryData.fromObject(data, SERIALIZER);
    }

    public static Mono<BinaryData> fromObjectAsync(Object data) {
        return BinaryData.fromObjectAsync(data, SERIALIZER);
    }

    public static BinaryData fromObject(Object data, ObjectSerializer serializer) {
        return new BinaryData(new SerializableContent(data, serializer));
    }

    public static Mono<BinaryData> fromObjectAsync(Object data, ObjectSerializer serializer) {
        return Mono.fromCallable(() -> BinaryData.fromObject(data, serializer));
    }

    public static BinaryData fromFile(Path file) {
        return BinaryData.fromFile(file, 8192);
    }

    public static BinaryData fromFile(Path file, int chunkSize) {
        return new BinaryData(new FileContent(file, chunkSize, null, null));
    }

    public static BinaryData fromFile(Path file, Long position, Long length) {
        return new BinaryData(new FileContent(file, 8192, position, length));
    }

    public static BinaryData fromFile(Path file, Long position, Long length, int chunkSize) {
        return new BinaryData(new FileContent(file, chunkSize, position, length));
    }

    public byte[] toBytes() {
        return this.content.toBytes();
    }

    public String toString() {
        return this.content.toString();
    }

    public <T> T toObject(Class<T> clazz) {
        return this.toObject(TypeReference.createInstance(clazz), (ObjectSerializer)SERIALIZER);
    }

    public <T> T toObject(TypeReference<T> typeReference) {
        return this.toObject(typeReference, (ObjectSerializer)SERIALIZER);
    }

    public <T> T toObject(Class<T> clazz, ObjectSerializer serializer) {
        return this.toObject(TypeReference.createInstance(clazz), serializer);
    }

    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        Objects.requireNonNull(typeReference, "'typeReference' cannot be null.");
        Objects.requireNonNull(serializer, "'serializer' cannot be null.");
        return this.content.toObject(typeReference, serializer);
    }

    public <T> Mono<T> toObjectAsync(Class<T> clazz) {
        return this.toObjectAsync(TypeReference.createInstance(clazz), (ObjectSerializer)SERIALIZER);
    }

    public <T> Mono<T> toObjectAsync(TypeReference<T> typeReference) {
        return this.toObjectAsync(typeReference, (ObjectSerializer)SERIALIZER);
    }

    public <T> Mono<T> toObjectAsync(Class<T> clazz, ObjectSerializer serializer) {
        return this.toObjectAsync(TypeReference.createInstance(clazz), serializer);
    }

    public <T> Mono<T> toObjectAsync(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return Mono.fromCallable(() -> this.toObject(typeReference, serializer));
    }

    public InputStream toStream() {
        return this.content.toStream();
    }

    public ByteBuffer toByteBuffer() {
        return this.content.toByteBuffer();
    }

    public Flux<ByteBuffer> toFluxByteBuffer() {
        return this.content.toFluxByteBuffer();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream, "'outputStream' cannot be null.");
        this.content.writeTo(outputStream);
    }

    public void writeTo(WritableByteChannel channel) throws IOException {
        Objects.requireNonNull(channel, "'channel' cannot be null.");
        this.content.writeTo(channel);
    }

    public Mono<Void> writeTo(AsynchronousByteChannel channel) {
        return this.content.writeTo(channel);
    }

    public void writeTo(JsonWriter jsonWriter) throws IOException {
        this.content.writeTo(jsonWriter);
    }

    public Long getLength() {
        return this.content.getLength();
    }

    public boolean isReplayable() {
        return this.content.isReplayable();
    }

    public BinaryData toReplayableBinaryData() {
        if (this.isReplayable()) {
            return this;
        }
        return new BinaryData(this.content.toReplayableContent());
    }

    public Mono<BinaryData> toReplayableBinaryDataAsync() {
        if (this.isReplayable()) {
            return Mono.just(this);
        }
        return this.content.toReplayableContentAsync().map(BinaryData::new);
    }

    static {
        BinaryDataHelper.setAccessor(new BinaryDataHelper.BinaryDataAccessor(){

            @Override
            public BinaryData createBinaryData(BinaryDataContent content) {
                return new BinaryData(content);
            }

            @Override
            public BinaryDataContent getContent(BinaryData binaryData) {
                return binaryData.content;
            }
        });
    }
}

