/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.BlobContainersSegment;
import com.azure.storage.blob.implementation.models.BlobStorageExceptionInternal;
import com.azure.storage.blob.implementation.models.FilterBlobSegment;
import com.azure.storage.blob.implementation.models.FilterBlobsIncludeItem;
import com.azure.storage.blob.implementation.models.ServicesFilterBlobsHeaders;
import com.azure.storage.blob.implementation.models.ServicesGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.models.ServicesGetPropertiesHeaders;
import com.azure.storage.blob.implementation.models.ServicesGetStatisticsHeaders;
import com.azure.storage.blob.implementation.models.ServicesGetUserDelegationKeyHeaders;
import com.azure.storage.blob.implementation.models.ServicesListBlobContainersSegmentHeaders;
import com.azure.storage.blob.implementation.models.ServicesListBlobContainersSegmentNextHeaders;
import com.azure.storage.blob.implementation.models.ServicesSetPropertiesHeaders;
import com.azure.storage.blob.implementation.models.ServicesSubmitBatchHeaders;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobServiceProperties;
import com.azure.storage.blob.models.BlobServiceStatistics;
import com.azure.storage.blob.models.KeyInfo;
import com.azure.storage.blob.models.ListBlobContainersIncludeType;
import com.azure.storage.blob.models.UserDelegationKey;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private final ServicesService service;
    private final AzureBlobStorageImpl client;

    ServicesImpl(AzureBlobStorageImpl client) {
        this.service = RestProxy.create(ServicesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.setPropertiesWithResponseAsync(blobServiceProperties, timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, blobServiceProperties, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId) {
        return this.setPropertiesWithResponseAsync(blobServiceProperties, timeout, requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId, Context context) {
        return this.setPropertiesWithResponseAsync(blobServiceProperties, timeout, requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.setPropertiesNoCustomHeadersWithResponseAsync(blobServiceProperties, timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, blobServiceProperties, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesSetPropertiesHeaders, Void> setPropertiesWithResponse(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId, Context context) {
        try {
            String restype = "service";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.setPropertiesSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, blobServiceProperties, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId) {
        this.setPropertiesWithResponse(blobServiceProperties, timeout, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesNoCustomHeadersWithResponse(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId, Context context) {
        try {
            String restype = "service";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.setPropertiesNoCustomHeadersSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, blobServiceProperties, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, BlobServiceProperties>> getPropertiesWithResponseAsync(Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getPropertiesWithResponseAsync(timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, BlobServiceProperties>> getPropertiesWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceProperties> getPropertiesAsync(Integer timeout, String requestId) {
        return this.getPropertiesWithResponseAsync(timeout, requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(res -> Mono.justOrEmpty((BlobServiceProperties)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceProperties> getPropertiesAsync(Integer timeout, String requestId, Context context) {
        return this.getPropertiesWithResponseAsync(timeout, requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(res -> Mono.justOrEmpty((BlobServiceProperties)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getPropertiesNoCustomHeadersWithResponseAsync(timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesGetPropertiesHeaders, BlobServiceProperties> getPropertiesWithResponse(Integer timeout, String requestId, Context context) {
        try {
            String restype = "service";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.getPropertiesSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobServiceProperties getProperties(Integer timeout, String requestId) {
        try {
            return this.getPropertiesWithResponse(timeout, requestId, Context.NONE).getValue();
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobServiceProperties> getPropertiesNoCustomHeadersWithResponse(Integer timeout, String requestId, Context context) {
        try {
            String restype = "service";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetStatisticsHeaders, BlobServiceStatistics>> getStatisticsWithResponseAsync(Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getStatisticsWithResponseAsync(timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetStatisticsHeaders, BlobServiceStatistics>> getStatisticsWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatistics(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceStatistics> getStatisticsAsync(Integer timeout, String requestId) {
        return this.getStatisticsWithResponseAsync(timeout, requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(res -> Mono.justOrEmpty((BlobServiceStatistics)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceStatistics> getStatisticsAsync(Integer timeout, String requestId, Context context) {
        return this.getStatisticsWithResponseAsync(timeout, requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(res -> Mono.justOrEmpty((BlobServiceStatistics)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceStatistics>> getStatisticsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getStatisticsNoCustomHeadersWithResponseAsync(timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceStatistics>> getStatisticsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatisticsNoCustomHeaders(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesGetStatisticsHeaders, BlobServiceStatistics> getStatisticsWithResponse(Integer timeout, String requestId, Context context) {
        try {
            String restype = "service";
            String comp = "stats";
            String accept = "application/xml";
            return this.service.getStatisticsSync(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobServiceStatistics getStatistics(Integer timeout, String requestId) {
        try {
            return this.getStatisticsWithResponse(timeout, requestId, Context.NONE).getValue();
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobServiceStatistics> getStatisticsNoCustomHeadersWithResponse(Integer timeout, String requestId, Context context) {
        try {
            String restype = "service";
            String comp = "stats";
            String accept = "application/xml";
            return this.service.getStatisticsNoCustomHeadersSync(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        String comp = "list";
        String accept = "application/xml";
        String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listBlobContainersSegment(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).map(res -> new PagedResponseBase<ServicesListBlobContainersSegmentHeaders, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), (ServicesListBlobContainersSegmentHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listBlobContainersSegment(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).map(res -> new PagedResponseBase<ServicesListBlobContainersSegmentHeaders, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), (ServicesListBlobContainersSegmentHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainersSegmentAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        return new PagedFlux<BlobContainerItem>(() -> this.listBlobContainersSegmentSinglePageAsync(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId), nextLink -> this.listBlobContainersSegmentNextSinglePageAsync((String)nextLink, requestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainersSegmentAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        return new PagedFlux<BlobContainerItem>(() -> this.listBlobContainersSegmentSinglePageAsync(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId, context), nextLink -> this.listBlobContainersSegmentNextSinglePageAsync((String)nextLink, requestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNoCustomHeadersSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        String comp = "list";
        String accept = "application/xml";
        String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listBlobContainersSegmentNoCustomHeaders(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).map(res -> new PagedResponseBase<Object, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNoCustomHeadersSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listBlobContainersSegmentNoCustomHeaders(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).map(res -> new PagedResponseBase<Object, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainersSegmentNoCustomHeadersAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        return new PagedFlux<BlobContainerItem>(() -> this.listBlobContainersSegmentNoCustomHeadersSinglePageAsync(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId), nextLink -> this.listBlobContainersSegmentNextSinglePageAsync((String)nextLink, requestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainersSegmentNoCustomHeadersAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        return new PagedFlux<BlobContainerItem>(() -> this.listBlobContainersSegmentNoCustomHeadersSinglePageAsync(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId, context), nextLink -> this.listBlobContainersSegmentNextSinglePageAsync((String)nextLink, requestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<BlobContainerItem> listBlobContainersSegmentSinglePage(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        try {
            String comp = "list";
            String accept = "application/xml";
            String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            ResponseBase<ServicesListBlobContainersSegmentHeaders, BlobContainersSegment> res = this.service.listBlobContainersSegmentSync(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", Context.NONE);
            return new PagedResponseBase<ServicesListBlobContainersSegmentHeaders, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getBlobContainerItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<BlobContainerItem> listBlobContainersSegmentSinglePage(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        try {
            String comp = "list";
            String accept = "application/xml";
            String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            ResponseBase<ServicesListBlobContainersSegmentHeaders, BlobContainersSegment> res = this.service.listBlobContainersSegmentSync(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context);
            return new PagedResponseBase<ServicesListBlobContainersSegmentHeaders, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getBlobContainerItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobContainerItem> listBlobContainersSegment(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        return new PagedIterable<BlobContainerItem>(() -> this.listBlobContainersSegmentSinglePage(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId, Context.NONE), nextLink -> this.listBlobContainersSegmentNextSinglePage((String)nextLink, requestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobContainerItem> listBlobContainersSegment(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        return new PagedIterable<BlobContainerItem>(() -> this.listBlobContainersSegmentSinglePage(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId, context), nextLink -> this.listBlobContainersSegmentNextSinglePage((String)nextLink, requestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<BlobContainerItem> listBlobContainersSegmentNoCustomHeadersSinglePage(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        try {
            String comp = "list";
            String accept = "application/xml";
            String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            Response<BlobContainersSegment> res = this.service.listBlobContainersSegmentNoCustomHeadersSync(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", Context.NONE);
            return new PagedResponseBase<Object, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getBlobContainerItems(), res.getValue().getNextMarker(), null);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<BlobContainerItem> listBlobContainersSegmentNoCustomHeadersSinglePage(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        try {
            String comp = "list";
            String accept = "application/xml";
            String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            Response<BlobContainersSegment> res = this.service.listBlobContainersSegmentNoCustomHeadersSync(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context);
            return new PagedResponseBase<Object, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getBlobContainerItems(), res.getValue().getNextMarker(), null);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobContainerItem> listBlobContainersSegmentNoCustomHeaders(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        return new PagedIterable<BlobContainerItem>(() -> this.listBlobContainersSegmentNoCustomHeadersSinglePage(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId, Context.NONE), nextLink -> this.listBlobContainersSegmentNextSinglePage((String)nextLink, requestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobContainerItem> listBlobContainersSegmentNoCustomHeaders(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        return new PagedIterable<BlobContainerItem>(() -> this.listBlobContainersSegmentNoCustomHeadersSinglePage(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId, context), nextLink -> this.listBlobContainersSegmentNextSinglePage((String)nextLink, requestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetUserDelegationKeyHeaders, UserDelegationKey>> getUserDelegationKeyWithResponseAsync(KeyInfo keyInfo, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getUserDelegationKeyWithResponseAsync(keyInfo, timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetUserDelegationKeyHeaders, UserDelegationKey>> getUserDelegationKeyWithResponseAsync(KeyInfo keyInfo, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "userdelegationkey";
        String accept = "application/xml";
        return this.service.getUserDelegationKey(this.client.getUrl(), "service", "userdelegationkey", timeout, this.client.getVersion(), requestId, keyInfo, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UserDelegationKey> getUserDelegationKeyAsync(KeyInfo keyInfo, Integer timeout, String requestId) {
        return this.getUserDelegationKeyWithResponseAsync(keyInfo, timeout, requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(res -> Mono.justOrEmpty((UserDelegationKey)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UserDelegationKey> getUserDelegationKeyAsync(KeyInfo keyInfo, Integer timeout, String requestId, Context context) {
        return this.getUserDelegationKeyWithResponseAsync(keyInfo, timeout, requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(res -> Mono.justOrEmpty((UserDelegationKey)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UserDelegationKey>> getUserDelegationKeyNoCustomHeadersWithResponseAsync(KeyInfo keyInfo, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getUserDelegationKeyNoCustomHeadersWithResponseAsync(keyInfo, timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UserDelegationKey>> getUserDelegationKeyNoCustomHeadersWithResponseAsync(KeyInfo keyInfo, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "userdelegationkey";
        String accept = "application/xml";
        return this.service.getUserDelegationKeyNoCustomHeaders(this.client.getUrl(), "service", "userdelegationkey", timeout, this.client.getVersion(), requestId, keyInfo, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesGetUserDelegationKeyHeaders, UserDelegationKey> getUserDelegationKeyWithResponse(KeyInfo keyInfo, Integer timeout, String requestId, Context context) {
        try {
            String restype = "service";
            String comp = "userdelegationkey";
            String accept = "application/xml";
            return this.service.getUserDelegationKeySync(this.client.getUrl(), "service", "userdelegationkey", timeout, this.client.getVersion(), requestId, keyInfo, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UserDelegationKey getUserDelegationKey(KeyInfo keyInfo, Integer timeout, String requestId) {
        try {
            return this.getUserDelegationKeyWithResponse(keyInfo, timeout, requestId, Context.NONE).getValue();
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<UserDelegationKey> getUserDelegationKeyNoCustomHeadersWithResponse(KeyInfo keyInfo, Integer timeout, String requestId, Context context) {
        try {
            String restype = "service";
            String comp = "userdelegationkey";
            String accept = "application/xml";
            return this.service.getUserDelegationKeyNoCustomHeadersSync(this.client.getUrl(), "service", "userdelegationkey", timeout, this.client.getVersion(), requestId, keyInfo, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetAccountInfoHeaders, Void>> getAccountInfoWithResponseAsync(Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getAccountInfoWithResponseAsync(timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetAccountInfoHeaders, Void>> getAccountInfoWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getAccountInfo(this.client.getUrl(), "account", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getAccountInfoAsync(Integer timeout, String requestId) {
        return this.getAccountInfoWithResponseAsync(timeout, requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getAccountInfoAsync(Integer timeout, String requestId, Context context) {
        return this.getAccountInfoWithResponseAsync(timeout, requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getAccountInfoNoCustomHeadersWithResponseAsync(Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getAccountInfoNoCustomHeadersWithResponseAsync(timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getAccountInfoNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getAccountInfoNoCustomHeaders(this.client.getUrl(), "account", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesGetAccountInfoHeaders, Void> getAccountInfoWithResponse(Integer timeout, String requestId, Context context) {
        try {
            String restype = "account";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.getAccountInfoSync(this.client.getUrl(), "account", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getAccountInfo(Integer timeout, String requestId) {
        this.getAccountInfoWithResponse(timeout, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getAccountInfoNoCustomHeadersWithResponse(Integer timeout, String requestId, Context context) {
        try {
            String restype = "account";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.getAccountInfoNoCustomHeadersSync(this.client.getUrl(), "account", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.submitBatchWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatch(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId) {
        return this.submitBatchWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        return this.submitBatchWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.submitBatchNoCustomHeadersWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatchNoCustomHeaders(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.submitBatchWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatch(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId) {
        return this.submitBatchWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        return this.submitBatchWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.submitBatchNoCustomHeadersWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatchNoCustomHeaders(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesSubmitBatchHeaders, InputStream> submitBatchWithResponse(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        try {
            String comp = "batch";
            String accept = "application/xml";
            return this.service.submitBatchSync(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream submitBatch(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId) {
        try {
            return this.submitBatchWithResponse(contentLength, multipartContentType, body, timeout, requestId, Context.NONE).getValue();
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<InputStream> submitBatchNoCustomHeadersWithResponse(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        try {
            String comp = "batch";
            String accept = "application/xml";
            return this.service.submitBatchNoCustomHeadersSync(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesFilterBlobsHeaders, FilterBlobSegment>> filterBlobsWithResponseAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include) {
        return FluxUtil.withContext(context -> this.filterBlobsWithResponseAsync(timeout, requestId, where, marker, maxresults, include, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesFilterBlobsHeaders, FilterBlobSegment>> filterBlobsWithResponseAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include, Context context) {
        String comp = "blobs";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.filterBlobs(this.client.getUrl(), "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, includeConverted, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilterBlobSegment> filterBlobsAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include) {
        return this.filterBlobsWithResponseAsync(timeout, requestId, where, marker, maxresults, include).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(res -> Mono.justOrEmpty((FilterBlobSegment)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilterBlobSegment> filterBlobsAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include, Context context) {
        return this.filterBlobsWithResponseAsync(timeout, requestId, where, marker, maxresults, include, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).flatMap(res -> Mono.justOrEmpty((FilterBlobSegment)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include) {
        return FluxUtil.withContext(context -> this.filterBlobsNoCustomHeadersWithResponseAsync(timeout, requestId, where, marker, maxresults, include, (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include, Context context) {
        String comp = "blobs";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.filterBlobsNoCustomHeaders(this.client.getUrl(), "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, includeConverted, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesFilterBlobsHeaders, FilterBlobSegment> filterBlobsWithResponse(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include, Context context) {
        try {
            String comp = "blobs";
            String accept = "application/xml";
            String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            return this.service.filterBlobsSync(this.client.getUrl(), "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, includeConverted, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FilterBlobSegment filterBlobs(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include) {
        try {
            return this.filterBlobsWithResponse(timeout, requestId, where, marker, maxresults, include, Context.NONE).getValue();
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FilterBlobSegment> filterBlobsNoCustomHeadersWithResponse(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include, Context context) {
        try {
            String comp = "blobs";
            String accept = "application/xml";
            String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            return this.service.filterBlobsNoCustomHeadersSync(this.client.getUrl(), "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, includeConverted, "application/xml", context);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNextSinglePageAsync(String nextLink, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listBlobContainersSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).map(res -> new PagedResponseBase<ServicesListBlobContainersSegmentNextHeaders, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), (ServicesListBlobContainersSegmentNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNextSinglePageAsync(String nextLink, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.listBlobContainersSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).map(res -> new PagedResponseBase<ServicesListBlobContainersSegmentNextHeaders, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), (ServicesListBlobContainersSegmentNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNextNoCustomHeadersSinglePageAsync(String nextLink, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listBlobContainersSegmentNextNoCustomHeaders(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", (Context)context)).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).map(res -> new PagedResponseBase<Object, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNextNoCustomHeadersSinglePageAsync(String nextLink, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.listBlobContainersSegmentNextNoCustomHeaders(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException).map(res -> new PagedResponseBase<Object, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<BlobContainerItem> listBlobContainersSegmentNextSinglePage(String nextLink, String requestId) {
        try {
            String accept = "application/xml";
            ResponseBase<ServicesListBlobContainersSegmentNextHeaders, BlobContainersSegment> res = this.service.listBlobContainersSegmentNextSync(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", Context.NONE);
            return new PagedResponseBase<ServicesListBlobContainersSegmentNextHeaders, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getBlobContainerItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<BlobContainerItem> listBlobContainersSegmentNextSinglePage(String nextLink, String requestId, Context context) {
        try {
            String accept = "application/xml";
            ResponseBase<ServicesListBlobContainersSegmentNextHeaders, BlobContainersSegment> res = this.service.listBlobContainersSegmentNextSync(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", context);
            return new PagedResponseBase<ServicesListBlobContainersSegmentNextHeaders, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getBlobContainerItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<BlobContainerItem> listBlobContainersSegmentNextNoCustomHeadersSinglePage(String nextLink, String requestId) {
        try {
            String accept = "application/xml";
            Response<BlobContainersSegment> res = this.service.listBlobContainersSegmentNextNoCustomHeadersSync(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", Context.NONE);
            return new PagedResponseBase<Object, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getBlobContainerItems(), res.getValue().getNextMarker(), null);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<BlobContainerItem> listBlobContainersSegmentNextNoCustomHeadersSinglePage(String nextLink, String requestId, Context context) {
        try {
            String accept = "application/xml";
            Response<BlobContainersSegment> res = this.service.listBlobContainersSegmentNextNoCustomHeadersSync(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", context);
            return new PagedResponseBase<Object, BlobContainerItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getBlobContainerItems(), res.getValue().getNextMarker(), null);
        }
        catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageServ")
    public static interface ServicesService {
        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") BlobServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<Response<Void>> setPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") BlobServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public ResponseBase<ServicesSetPropertiesHeaders, Void> setPropertiesSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") BlobServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Response<Void> setPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") BlobServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesGetPropertiesHeaders, BlobServiceProperties>> getProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<Response<BlobServiceProperties>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public ResponseBase<ServicesGetPropertiesHeaders, BlobServiceProperties> getPropertiesSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Response<BlobServiceProperties> getPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesGetStatisticsHeaders, BlobServiceStatistics>> getStatistics(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<Response<BlobServiceStatistics>> getStatisticsNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public ResponseBase<ServicesGetStatisticsHeaders, BlobServiceStatistics> getStatisticsSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Response<BlobServiceStatistics> getStatisticsNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesListBlobContainersSegmentHeaders, BlobContainersSegment>> listBlobContainersSegment(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<Response<BlobContainersSegment>> listBlobContainersSegmentNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public ResponseBase<ServicesListBlobContainersSegmentHeaders, BlobContainersSegment> listBlobContainersSegmentSync(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Response<BlobContainersSegment> listBlobContainersSegmentNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesGetUserDelegationKeyHeaders, UserDelegationKey>> getUserDelegationKey(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") KeyInfo var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<Response<UserDelegationKey>> getUserDelegationKeyNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") KeyInfo var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public ResponseBase<ServicesGetUserDelegationKeyHeaders, UserDelegationKey> getUserDelegationKeySync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") KeyInfo var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Response<UserDelegationKey> getUserDelegationKeyNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") KeyInfo var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesGetAccountInfoHeaders, Void>> getAccountInfo(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<Response<Void>> getAccountInfoNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public ResponseBase<ServicesGetAccountInfoHeaders, Void> getAccountInfoSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Response<Void> getAccountInfoNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatch(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="Content-Type") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") Flux<ByteBuffer> var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<StreamResponse> submitBatchNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="Content-Type") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") Flux<ByteBuffer> var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatch(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="Content-Type") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") BinaryData var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<StreamResponse> submitBatchNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="Content-Type") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") BinaryData var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public ResponseBase<ServicesSubmitBatchHeaders, InputStream> submitBatchSync(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="Content-Type") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") BinaryData var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Response<InputStream> submitBatchNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="Content-Type") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") BinaryData var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesFilterBlobsHeaders, FilterBlobSegment>> filterBlobs(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="where") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxresults") Integer var8, @QueryParam(value="include") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="where") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxresults") Integer var8, @QueryParam(value="include") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public ResponseBase<ServicesFilterBlobsHeaders, FilterBlobSegment> filterBlobsSync(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="where") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxresults") Integer var8, @QueryParam(value="include") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Response<FilterBlobSegment> filterBlobsNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="where") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxresults") Integer var8, @QueryParam(value="include") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesListBlobContainersSegmentNextHeaders, BlobContainersSegment>> listBlobContainersSegmentNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Mono<Response<BlobContainersSegment>> listBlobContainersSegmentNextNoCustomHeaders(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public ResponseBase<ServicesListBlobContainersSegmentNextHeaders, BlobContainersSegment> listBlobContainersSegmentNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageExceptionInternal.class)
        public Response<BlobContainersSegment> listBlobContainersSegmentNextNoCustomHeadersSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

