/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.PublicAccessType;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ContainersGetPropertiesHeaders {
    private LeaseStatusType xMsLeaseStatus;
    private String xMsVersion;
    private Boolean xMsImmutableStorageWithVersioningEnabled;
    private LeaseStateType xMsLeaseState;
    private Boolean xMsDenyEncryptionScopeOverride;
    private DateTimeRfc1123 lastModified;
    private Map<String, String> xMsMeta;
    private DateTimeRfc1123 date;
    private Boolean xMsHasLegalHold;
    private String xMsDefaultEncryptionScope;
    private String eTag;
    private Boolean xMsHasImmutabilityPolicy;
    private LeaseDurationType xMsLeaseDuration;
    private PublicAccessType xMsBlobPublicAccess;
    private String xMsRequestId;
    private String xMsClientRequestId;
    private static final HttpHeaderName X_MS_LEASE_STATUS = HttpHeaderName.fromString("x-ms-lease-status");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");
    private static final HttpHeaderName X_MS_IMMUTABLE_STORAGE_WITH_VERSIONING_ENABLED = HttpHeaderName.fromString("x-ms-immutable-storage-with-versioning-enabled");
    private static final HttpHeaderName X_MS_LEASE_STATE = HttpHeaderName.fromString("x-ms-lease-state");
    private static final HttpHeaderName X_MS_DENY_ENCRYPTION_SCOPE_OVERRIDE = HttpHeaderName.fromString("x-ms-deny-encryption-scope-override");
    private static final HttpHeaderName X_MS_HAS_LEGAL_HOLD = HttpHeaderName.fromString("x-ms-has-legal-hold");
    private static final HttpHeaderName X_MS_DEFAULT_ENCRYPTION_SCOPE = HttpHeaderName.fromString("x-ms-default-encryption-scope");
    private static final HttpHeaderName X_MS_HAS_IMMUTABILITY_POLICY = HttpHeaderName.fromString("x-ms-has-immutability-policy");
    private static final HttpHeaderName X_MS_LEASE_DURATION = HttpHeaderName.fromString("x-ms-lease-duration");
    private static final HttpHeaderName X_MS_BLOB_PUBLIC_ACCESS = HttpHeaderName.fromString("x-ms-blob-public-access");

    public ContainersGetPropertiesHeaders(HttpHeaders rawHeaders) {
        String xMsBlobPublicAccess;
        String xMsLeaseDuration;
        String xMsHasLegalHold;
        String date;
        String lastModified;
        String xMsDenyEncryptionScopeOverride;
        String xMsLeaseState;
        String xMsLeaseStatus = rawHeaders.getValue(X_MS_LEASE_STATUS);
        if (xMsLeaseStatus != null) {
            this.xMsLeaseStatus = LeaseStatusType.fromString(xMsLeaseStatus);
        }
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsImmutableStorageWithVersioningEnabled = rawHeaders.getValue(X_MS_IMMUTABLE_STORAGE_WITH_VERSIONING_ENABLED);
        if (xMsImmutableStorageWithVersioningEnabled != null) {
            this.xMsImmutableStorageWithVersioningEnabled = Boolean.parseBoolean(xMsImmutableStorageWithVersioningEnabled);
        }
        if ((xMsLeaseState = rawHeaders.getValue(X_MS_LEASE_STATE)) != null) {
            this.xMsLeaseState = LeaseStateType.fromString(xMsLeaseState);
        }
        if ((xMsDenyEncryptionScopeOverride = rawHeaders.getValue(X_MS_DENY_ENCRYPTION_SCOPE_OVERRIDE)) != null) {
            this.xMsDenyEncryptionScopeOverride = Boolean.parseBoolean(xMsDenyEncryptionScopeOverride);
        }
        if ((lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED)) != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        if ((date = rawHeaders.getValue(HttpHeaderName.DATE)) != null) {
            this.date = new DateTimeRfc1123(date);
        }
        if ((xMsHasLegalHold = rawHeaders.getValue(X_MS_HAS_LEGAL_HOLD)) != null) {
            this.xMsHasLegalHold = Boolean.parseBoolean(xMsHasLegalHold);
        }
        this.xMsDefaultEncryptionScope = rawHeaders.getValue(X_MS_DEFAULT_ENCRYPTION_SCOPE);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String xMsHasImmutabilityPolicy = rawHeaders.getValue(X_MS_HAS_IMMUTABILITY_POLICY);
        if (xMsHasImmutabilityPolicy != null) {
            this.xMsHasImmutabilityPolicy = Boolean.parseBoolean(xMsHasImmutabilityPolicy);
        }
        if ((xMsLeaseDuration = rawHeaders.getValue(X_MS_LEASE_DURATION)) != null) {
            this.xMsLeaseDuration = LeaseDurationType.fromString(xMsLeaseDuration);
        }
        if ((xMsBlobPublicAccess = rawHeaders.getValue(X_MS_BLOB_PUBLIC_ACCESS)) != null) {
            this.xMsBlobPublicAccess = PublicAccessType.fromString(xMsBlobPublicAccess);
        }
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        LinkedHashMap<String, String> xMsMetaHeaderCollection = new LinkedHashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            String headerName = header.getName();
            if (!headerName.startsWith("x-ms-meta-")) continue;
            xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
        }
        this.xMsMeta = xMsMetaHeaderCollection;
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public ContainersGetPropertiesHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public ContainersGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public Boolean isXMsImmutableStorageWithVersioningEnabled() {
        return this.xMsImmutableStorageWithVersioningEnabled;
    }

    public ContainersGetPropertiesHeaders setXMsImmutableStorageWithVersioningEnabled(Boolean xMsImmutableStorageWithVersioningEnabled) {
        this.xMsImmutableStorageWithVersioningEnabled = xMsImmutableStorageWithVersioningEnabled;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public ContainersGetPropertiesHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public Boolean isXMsDenyEncryptionScopeOverride() {
        return this.xMsDenyEncryptionScopeOverride;
    }

    public ContainersGetPropertiesHeaders setXMsDenyEncryptionScopeOverride(Boolean xMsDenyEncryptionScopeOverride) {
        this.xMsDenyEncryptionScopeOverride = xMsDenyEncryptionScopeOverride;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public ContainersGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public ContainersGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public ContainersGetPropertiesHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public Boolean isXMsHasLegalHold() {
        return this.xMsHasLegalHold;
    }

    public ContainersGetPropertiesHeaders setXMsHasLegalHold(Boolean xMsHasLegalHold) {
        this.xMsHasLegalHold = xMsHasLegalHold;
        return this;
    }

    public String getXMsDefaultEncryptionScope() {
        return this.xMsDefaultEncryptionScope;
    }

    public ContainersGetPropertiesHeaders setXMsDefaultEncryptionScope(String xMsDefaultEncryptionScope) {
        this.xMsDefaultEncryptionScope = xMsDefaultEncryptionScope;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public ContainersGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public Boolean isXMsHasImmutabilityPolicy() {
        return this.xMsHasImmutabilityPolicy;
    }

    public ContainersGetPropertiesHeaders setXMsHasImmutabilityPolicy(Boolean xMsHasImmutabilityPolicy) {
        this.xMsHasImmutabilityPolicy = xMsHasImmutabilityPolicy;
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public ContainersGetPropertiesHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public PublicAccessType getXMsBlobPublicAccess() {
        return this.xMsBlobPublicAccess;
    }

    public ContainersGetPropertiesHeaders setXMsBlobPublicAccess(PublicAccessType xMsBlobPublicAccess) {
        this.xMsBlobPublicAccess = xMsBlobPublicAccess;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public ContainersGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public ContainersGetPropertiesHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }
}

