/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.implementation.accesshelpers.BlobPropertiesConstructorProxy;
import com.azure.storage.blob.implementation.models.BlobPropertiesInternal;
import com.azure.storage.blob.implementation.models.BlobPropertiesInternalConstructorProperties;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.ObjectReplicationPolicy;
import com.azure.storage.blob.models.RehydratePriority;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class BlobProperties {
    private final BlobPropertiesInternal internalProperties;

    private BlobProperties(BlobPropertiesInternal internalProperties) {
        this.internalProperties = internalProperties;
    }

    public BlobProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long blobSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, Long blobSequenceNumber, BlobType blobType, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, String copyDestinationSnapshot, AccessTier accessTier, Boolean isAccessTierInferred, ArchiveStatus archiveStatus, String encryptionKeySha256, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, Integer committedBlockCount) {
        this(creationTime, lastModified, eTag, blobSize, contentType, contentMd5, contentEncoding, contentDisposition, contentLanguage, cacheControl, blobSequenceNumber, blobType, leaseStatus, leaseState, leaseDuration, copyId, copyStatus, copySource, copyProgress, copyCompletionTime, copyStatusDescription, isServerEncrypted, isIncrementalCopy, copyDestinationSnapshot, accessTier, isAccessTierInferred, archiveStatus, encryptionKeySha256, null, accessTierChangeTime, metadata, committedBlockCount, null, null, null, null, null);
    }

    public BlobProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long blobSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, Long blobSequenceNumber, BlobType blobType, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, String copyDestinationSnapshot, AccessTier accessTier, Boolean isAccessTierInferred, ArchiveStatus archiveStatus, String encryptionKeySha256, String encryptionScope, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, Integer committedBlockCount, String versionId, Boolean isCurrentVersion, Long tagCount, Map<String, String> objectReplicationStatus, String rehydratePriority, Boolean isSealed) {
        this(creationTime, lastModified, eTag, blobSize, contentType, contentMd5, contentEncoding, contentDisposition, contentLanguage, cacheControl, blobSequenceNumber, blobType, leaseStatus, leaseState, leaseDuration, copyId, copyStatus, copySource, copyProgress, copyCompletionTime, copyStatusDescription, isServerEncrypted, isIncrementalCopy, copyDestinationSnapshot, accessTier, isAccessTierInferred, archiveStatus, encryptionKeySha256, encryptionScope, accessTierChangeTime, metadata, committedBlockCount, tagCount, versionId, isCurrentVersion, ModelHelper.getObjectReplicationSourcePolicies(objectReplicationStatus), ModelHelper.getObjectReplicationDestinationPolicyId(objectReplicationStatus), RehydratePriority.fromString(rehydratePriority), isSealed, null, null);
    }

    public BlobProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long blobSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, Long blobSequenceNumber, BlobType blobType, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, String copyDestinationSnapshot, AccessTier accessTier, Boolean isAccessTierInferred, ArchiveStatus archiveStatus, String encryptionKeySha256, String encryptionScope, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, Integer committedBlockCount, Long tagCount, String versionId, Boolean isCurrentVersion, List<ObjectReplicationPolicy> objectReplicationSourcePolicies, String objectReplicationDestinationPolicyId) {
        this(creationTime, lastModified, eTag, blobSize, contentType, contentMd5, contentEncoding, contentDisposition, contentLanguage, cacheControl, blobSequenceNumber, blobType, leaseStatus, leaseState, leaseDuration, copyId, copyStatus, copySource, copyProgress, copyCompletionTime, copyStatusDescription, isServerEncrypted, isIncrementalCopy, copyDestinationSnapshot, accessTier, isAccessTierInferred, archiveStatus, encryptionKeySha256, encryptionScope, accessTierChangeTime, metadata, committedBlockCount, tagCount, versionId, isCurrentVersion, objectReplicationSourcePolicies, objectReplicationDestinationPolicyId, null, null, null, null);
    }

    public BlobProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long blobSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, Long blobSequenceNumber, BlobType blobType, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, String copyDestinationSnapshot, AccessTier accessTier, Boolean isAccessTierInferred, ArchiveStatus archiveStatus, String encryptionKeySha256, String encryptionScope, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, Integer committedBlockCount, Long tagCount, String versionId, Boolean isCurrentVersion, List<ObjectReplicationPolicy> objectReplicationSourcePolicies, String objectReplicationDestinationPolicyId, RehydratePriority rehydratePriority, Boolean isSealed, OffsetDateTime lastAccessedTime, OffsetDateTime expiresOn) {
        this(creationTime, lastModified, eTag, blobSize, contentType, contentMd5, contentEncoding, contentDisposition, contentLanguage, cacheControl, blobSequenceNumber, blobType, leaseStatus, leaseState, leaseDuration, copyId, copyStatus, copySource, copyProgress, copyCompletionTime, copyStatusDescription, isServerEncrypted, isIncrementalCopy, copyDestinationSnapshot, accessTier, isAccessTierInferred, archiveStatus, encryptionKeySha256, encryptionScope, accessTierChangeTime, metadata, committedBlockCount, tagCount, versionId, isCurrentVersion, objectReplicationSourcePolicies, objectReplicationDestinationPolicyId, rehydratePriority, isSealed, lastAccessedTime, expiresOn, null, false);
    }

    public BlobProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long blobSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, Long blobSequenceNumber, BlobType blobType, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, String copyDestinationSnapshot, AccessTier accessTier, Boolean isAccessTierInferred, ArchiveStatus archiveStatus, String encryptionKeySha256, String encryptionScope, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, Integer committedBlockCount, Long tagCount, String versionId, Boolean isCurrentVersion, List<ObjectReplicationPolicy> objectReplicationSourcePolicies, String objectReplicationDestinationPolicyId, RehydratePriority rehydratePriority, Boolean isSealed, OffsetDateTime lastAccessedTime, OffsetDateTime expiresOn, BlobImmutabilityPolicy immutabilityPolicy, Boolean hasLegalHold) {
        this(creationTime, lastModified, eTag, blobSize, contentType, contentMd5, contentEncoding, contentDisposition, contentLanguage, cacheControl, blobSequenceNumber, blobType, leaseStatus, leaseState, leaseDuration, copyId, copyStatus, copySource, copyProgress, copyCompletionTime, copyStatusDescription, isServerEncrypted, isIncrementalCopy, copyDestinationSnapshot, accessTier, isAccessTierInferred, archiveStatus, encryptionKeySha256, encryptionScope, accessTierChangeTime, metadata, committedBlockCount, tagCount, versionId, isCurrentVersion, objectReplicationSourcePolicies, objectReplicationDestinationPolicyId, rehydratePriority, isSealed, lastAccessedTime, expiresOn, immutabilityPolicy, hasLegalHold, null);
    }

    public BlobProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long blobSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, Long blobSequenceNumber, BlobType blobType, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, String copyDestinationSnapshot, AccessTier accessTier, Boolean isAccessTierInferred, ArchiveStatus archiveStatus, String encryptionKeySha256, String encryptionScope, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, Integer committedBlockCount, Long tagCount, String versionId, Boolean isCurrentVersion, List<ObjectReplicationPolicy> objectReplicationSourcePolicies, String objectReplicationDestinationPolicyId, RehydratePriority rehydratePriority, Boolean isSealed, OffsetDateTime lastAccessedTime, OffsetDateTime expiresOn, BlobImmutabilityPolicy immutabilityPolicy, Boolean hasLegalHold, String requestId) {
        this(new BlobPropertiesInternalConstructorProperties(creationTime, lastModified, eTag, blobSize, contentType, contentMd5, contentEncoding, contentDisposition, contentLanguage, cacheControl, blobSequenceNumber, blobType, leaseStatus, leaseState, leaseDuration, copyId, copyStatus, copySource, copyProgress, copyCompletionTime, copyStatusDescription, isServerEncrypted, isIncrementalCopy, copyDestinationSnapshot, accessTier, isAccessTierInferred, archiveStatus, encryptionKeySha256, encryptionScope, accessTierChangeTime, metadata, committedBlockCount, tagCount, versionId, isCurrentVersion, objectReplicationSourcePolicies, objectReplicationDestinationPolicyId, rehydratePriority, isSealed, lastAccessedTime, expiresOn, immutabilityPolicy, hasLegalHold, requestId));
    }

    public OffsetDateTime getCreationTime() {
        return this.internalProperties.getCreationTime();
    }

    public OffsetDateTime getLastModified() {
        return this.internalProperties.getLastModified();
    }

    public String getETag() {
        return this.internalProperties.getETag();
    }

    public long getBlobSize() {
        return this.internalProperties.getBlobSize();
    }

    public String getContentType() {
        return this.internalProperties.getContentType();
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone(this.internalProperties.getContentMd5());
    }

    public String getContentEncoding() {
        return this.internalProperties.getContentEncoding();
    }

    public String getContentDisposition() {
        return this.internalProperties.getContentDisposition();
    }

    public String getContentLanguage() {
        return this.internalProperties.getContentLanguage();
    }

    public String getCacheControl() {
        return this.internalProperties.getCacheControl();
    }

    public Long getBlobSequenceNumber() {
        return this.internalProperties.getBlobSequenceNumber();
    }

    public BlobType getBlobType() {
        return this.internalProperties.getBlobType();
    }

    public LeaseStatusType getLeaseStatus() {
        return this.internalProperties.getLeaseStatus();
    }

    public LeaseStateType getLeaseState() {
        return this.internalProperties.getLeaseState();
    }

    public LeaseDurationType getLeaseDuration() {
        return this.internalProperties.getLeaseDuration();
    }

    public String getCopyId() {
        return this.internalProperties.getCopyId();
    }

    public CopyStatusType getCopyStatus() {
        return this.internalProperties.getCopyStatus();
    }

    public String getCopySource() {
        return this.internalProperties.getCopySource();
    }

    public String getCopyProgress() {
        return this.internalProperties.getCopyProgress();
    }

    public OffsetDateTime getCopyCompletionTime() {
        return this.internalProperties.getCopyCompletionTime();
    }

    public String getCopyStatusDescription() {
        return this.internalProperties.getCopyStatusDescription();
    }

    public Boolean isServerEncrypted() {
        return this.internalProperties.isServerEncrypted();
    }

    public Boolean isIncrementalCopy() {
        return this.internalProperties.isIncrementalCopy();
    }

    public String getCopyDestinationSnapshot() {
        return this.internalProperties.getCopyDestinationSnapshot();
    }

    public AccessTier getAccessTier() {
        return this.internalProperties.getAccessTier();
    }

    public Boolean isAccessTierInferred() {
        return this.internalProperties.isAccessTierInferred();
    }

    public ArchiveStatus getArchiveStatus() {
        return this.internalProperties.getArchiveStatus();
    }

    public String getEncryptionKeySha256() {
        return this.internalProperties.getEncryptionKeySha256();
    }

    public String getEncryptionScope() {
        return this.internalProperties.getEncryptionScope();
    }

    public OffsetDateTime getAccessTierChangeTime() {
        return this.internalProperties.getAccessTierChangeTime();
    }

    public Map<String, String> getMetadata() {
        return this.internalProperties.getMetadata();
    }

    public Integer getCommittedBlockCount() {
        return this.internalProperties.getCommittedBlockCount();
    }

    public Long getTagCount() {
        return this.internalProperties.getTagCount();
    }

    public String getVersionId() {
        return this.internalProperties.getVersionId();
    }

    public Boolean isCurrentVersion() {
        return this.internalProperties.isCurrentVersion();
    }

    public List<ObjectReplicationPolicy> getObjectReplicationSourcePolicies() {
        return Collections.unmodifiableList(this.internalProperties.getObjectReplicationSourcePolicies());
    }

    public String getObjectReplicationDestinationPolicyId() {
        return this.internalProperties.getObjectReplicationDestinationPolicyId();
    }

    public RehydratePriority getRehydratePriority() {
        return this.internalProperties.getRehydratePriority();
    }

    public Boolean isSealed() {
        return this.internalProperties.isSealed();
    }

    public OffsetDateTime getLastAccessedTime() {
        return this.internalProperties.getLastAccessedTime();
    }

    public OffsetDateTime getExpiresOn() {
        return this.internalProperties.getExpiresOn();
    }

    public BlobImmutabilityPolicy getImmutabilityPolicy() {
        return this.internalProperties.getImmutabilityPolicy();
    }

    public Boolean hasLegalHold() {
        return this.internalProperties.hasLegalHold();
    }

    public String getRequestId() {
        return this.internalProperties.getRequestId();
    }

    static {
        BlobPropertiesConstructorProxy.setAccessor(new BlobPropertiesConstructorProxy.BlobPropertiesConstructorAccessor(){

            @Override
            public BlobProperties create(BlobPropertiesInternal internalProperties) {
                return new BlobProperties(internalProperties);
            }
        });
    }
}

