/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.resolver.AddressResolverGroup;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;
import reactor.netty.ChannelBindException;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.AddressUtils;
import reactor.netty.transport.TransportConfig;
import reactor.netty.transport.TransportConnector;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class NewConnectionProvider
implements ConnectionProvider {
    static final Logger log = Loggers.getLogger(NewConnectionProvider.class);
    static final NewConnectionProvider INSTANCE = new NewConnectionProvider();

    NewConnectionProvider() {
    }

    @Override
    public Mono<? extends Connection> acquire(TransportConfig config, ConnectionObserver observer, @Nullable Supplier<? extends SocketAddress> remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        return Mono.create((MonoSink<T> sink) -> {
            SocketAddress remote = null;
            if (remoteAddress != null) {
                remote = Objects.requireNonNull((SocketAddress)remoteAddress.get(), "Remote Address supplier returned null");
            }
            NewConnectionObserver connectionObserver = new NewConnectionObserver((MonoSink<Connection>)sink, observer);
            DisposableConnect disposableConnect = new DisposableConnect((MonoSink<Connection>)sink, config.bindAddress());
            if (remote != null && resolverGroup != null) {
                ChannelInitializer<Channel> channelInitializer = config.channelInitializer(connectionObserver, remote, false);
                TransportConnector.connect(config, remote, resolverGroup, channelInitializer, sink.contextView()).subscribe(disposableConnect);
            } else {
                InetSocketAddress localInet;
                Objects.requireNonNull(config.bindAddress(), "bindAddress");
                SocketAddress local = Objects.requireNonNull(config.bindAddress().get(), "Bind Address supplier returned null");
                if (local instanceof InetSocketAddress && (localInet = (InetSocketAddress)local).isUnresolved()) {
                    local = AddressUtils.createResolved(localInet.getHostName(), localInet.getPort());
                }
                ChannelInitializer<Channel> channelInitializer = config.channelInitializer(connectionObserver, null, true);
                TransportConnector.bind(config, channelInitializer, local, local instanceof DomainSocketAddress).subscribe(disposableConnect);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public int maxConnections() {
        return 1;
    }

    static final class NewConnectionObserver
    implements ConnectionObserver {
        final MonoSink<Connection> sink;
        final Context currentContext;
        final ConnectionObserver obs;

        NewConnectionObserver(MonoSink<Connection> sink, ConnectionObserver obs) {
            this.sink = sink;
            this.currentContext = Context.of(sink.contextView());
            this.obs = obs;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(connection.channel(), "onStateChange({}, {})"), newState, connection);
            }
            if (newState == ConnectionObserver.State.CONFIGURED) {
                this.sink.success(connection);
            } else if (newState == ConnectionObserver.State.DISCONNECTING && connection.channel().isActive()) {
                connection.channel().close();
            }
            this.obs.onStateChange(connection, newState);
        }

        @Override
        public void onUncaughtException(Connection c, Throwable error) {
            this.sink.error(error);
            this.obs.onUncaughtException(c, error);
        }
    }

    static final class DisposableConnect
    implements CoreSubscriber<Channel>,
    Disposable {
        final MonoSink<Connection> sink;
        final Context currentContext;
        final Supplier<? extends SocketAddress> bindAddress;
        Subscription subscription;

        DisposableConnect(MonoSink<Connection> sink, @Nullable Supplier<? extends SocketAddress> bindAddress) {
            this.sink = sink;
            this.currentContext = Context.of(sink.contextView());
            this.bindAddress = bindAddress;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void dispose() {
            this.subscription.cancel();
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable t) {
            if (this.bindAddress != null && (t instanceof BindException || t instanceof IOException && t.getMessage() != null && t.getMessage().contains("bind(..)"))) {
                this.sink.error(ChannelBindException.fail(this.bindAddress.get(), null));
            } else {
                this.sink.error(t);
            }
        }

        @Override
        public void onNext(Channel channel) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Connected new channel"));
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.subscription, s)) {
                this.subscription = s;
                this.sink.onCancel(this);
                s.request(Long.MAX_VALUE);
            }
        }
    }
}

