/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protobuf.dynamic;

import com.github.os72.protobuf.dynamic.EnumDefinition;
import com.github.os72.protobuf.dynamic.MessageDefinition;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ProtocolStringList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicSchema {
    private DescriptorProtos.FileDescriptorSet mFileDescSet;
    private Map<String, Descriptors.Descriptor> mMsgDescriptorMapFull = new HashMap<String, Descriptors.Descriptor>();
    private Map<String, Descriptors.Descriptor> mMsgDescriptorMapShort = new HashMap<String, Descriptors.Descriptor>();
    private Map<String, Descriptors.EnumDescriptor> mEnumDescriptorMapFull = new HashMap<String, Descriptors.EnumDescriptor>();
    private Map<String, Descriptors.EnumDescriptor> mEnumDescriptorMapShort = new HashMap<String, Descriptors.EnumDescriptor>();

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicSchema parseFrom(InputStream schemaDescIn) throws Descriptors.DescriptorValidationException, IOException {
        try {
            int len;
            byte[] buf = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((len = schemaDescIn.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            DynamicSchema dynamicSchema = DynamicSchema.parseFrom(baos.toByteArray());
            return dynamicSchema;
        }
        finally {
            schemaDescIn.close();
        }
    }

    public static DynamicSchema parseFrom(byte[] schemaDescBuf) throws Descriptors.DescriptorValidationException, IOException {
        return new DynamicSchema(DescriptorProtos.FileDescriptorSet.parseFrom(schemaDescBuf));
    }

    public DynamicMessage.Builder newMessageBuilder(String msgTypeName) {
        Descriptors.Descriptor msgType = this.getMessageDescriptor(msgTypeName);
        if (msgType == null) {
            return null;
        }
        return DynamicMessage.newBuilder(msgType);
    }

    public Descriptors.Descriptor getMessageDescriptor(String msgTypeName) {
        Descriptors.Descriptor msgType = this.mMsgDescriptorMapShort.get(msgTypeName);
        if (msgType == null) {
            msgType = this.mMsgDescriptorMapFull.get(msgTypeName);
        }
        return msgType;
    }

    public Descriptors.EnumValueDescriptor getEnumValue(String enumTypeName, String enumName) {
        Descriptors.EnumDescriptor enumType = this.getEnumDescriptor(enumTypeName);
        if (enumType == null) {
            return null;
        }
        return enumType.findValueByName(enumName);
    }

    public Descriptors.EnumValueDescriptor getEnumValue(String enumTypeName, int enumNumber) {
        Descriptors.EnumDescriptor enumType = this.getEnumDescriptor(enumTypeName);
        if (enumType == null) {
            return null;
        }
        return enumType.findValueByNumber(enumNumber);
    }

    public Descriptors.EnumDescriptor getEnumDescriptor(String enumTypeName) {
        Descriptors.EnumDescriptor enumType = this.mEnumDescriptorMapShort.get(enumTypeName);
        if (enumType == null) {
            enumType = this.mEnumDescriptorMapFull.get(enumTypeName);
        }
        return enumType;
    }

    public Set<String> getMessageTypes() {
        return new TreeSet<String>(this.mMsgDescriptorMapFull.keySet());
    }

    public Set<String> getEnumTypes() {
        return new TreeSet<String>(this.mEnumDescriptorMapFull.keySet());
    }

    public DescriptorProtos.FileDescriptorSet getFileDescriptorSet() {
        return this.mFileDescSet;
    }

    public byte[] toByteArray() {
        return this.mFileDescSet.toByteArray();
    }

    public String toString() {
        Set<String> msgTypes = this.getMessageTypes();
        Set<String> enumTypes = this.getEnumTypes();
        return "types: " + msgTypes + "\nenums: " + enumTypes + "\n" + this.mFileDescSet;
    }

    private DynamicSchema(DescriptorProtos.FileDescriptorSet fileDescSet) throws Descriptors.DescriptorValidationException {
        this.mFileDescSet = fileDescSet;
        Map<String, Descriptors.FileDescriptor> fileDescMap = this.init(fileDescSet);
        HashSet<String> msgDupes = new HashSet<String>();
        HashSet<String> enumDupes = new HashSet<String>();
        for (Descriptors.FileDescriptor fileDesc : fileDescMap.values()) {
            for (Descriptors.Descriptor msgType : fileDesc.getMessageTypes()) {
                this.addMessageType(msgType, null, msgDupes, enumDupes);
            }
            for (Descriptors.EnumDescriptor enumType : fileDesc.getEnumTypes()) {
                this.addEnumType(enumType, null, enumDupes);
            }
        }
        for (String msgName : msgDupes) {
            this.mMsgDescriptorMapShort.remove(msgName);
        }
        for (String enumName : enumDupes) {
            this.mEnumDescriptorMapShort.remove(enumName);
        }
    }

    private Map<String, Descriptors.FileDescriptor> init(DescriptorProtos.FileDescriptorSet fileDescSet) throws Descriptors.DescriptorValidationException {
        HashSet<String> allFdProtoNames = new HashSet<String>();
        for (DescriptorProtos.FileDescriptorProto fdProto : fileDescSet.getFileList()) {
            if (allFdProtoNames.contains(fdProto.getName())) {
                throw new IllegalArgumentException("duplicate name: " + fdProto.getName());
            }
            allFdProtoNames.add(fdProto.getName());
        }
        HashMap<String, Descriptors.FileDescriptor> resolvedFileDescMap = new HashMap<String, Descriptors.FileDescriptor>();
        while (resolvedFileDescMap.size() < fileDescSet.getFileCount()) {
            for (DescriptorProtos.FileDescriptorProto fdProto : fileDescSet.getFileList()) {
                if (resolvedFileDescMap.containsKey(fdProto.getName())) continue;
                ProtocolStringList dependencyList = fdProto.getDependencyList();
                ArrayList<Descriptors.FileDescriptor> resolvedFdList = new ArrayList<Descriptors.FileDescriptor>();
                for (String depName : dependencyList) {
                    if (!allFdProtoNames.contains(depName)) {
                        throw new IllegalArgumentException("cannot resolve import " + depName + " in " + fdProto.getName());
                    }
                    Descriptors.FileDescriptor fd = (Descriptors.FileDescriptor)resolvedFileDescMap.get(depName);
                    if (fd == null) continue;
                    resolvedFdList.add(fd);
                }
                if (resolvedFdList.size() != dependencyList.size()) continue;
                Descriptors.FileDescriptor[] fds = new Descriptors.FileDescriptor[resolvedFdList.size()];
                Descriptors.FileDescriptor fd = Descriptors.FileDescriptor.buildFrom(fdProto, resolvedFdList.toArray(fds));
                resolvedFileDescMap.put(fdProto.getName(), fd);
            }
        }
        return resolvedFileDescMap;
    }

    private void addMessageType(Descriptors.Descriptor msgType, String scope, Set<String> msgDupes, Set<String> enumDupes) {
        String msgTypeNameShort;
        String msgTypeNameFull = msgType.getFullName();
        String string = msgTypeNameShort = scope == null ? msgType.getName() : scope + "." + msgType.getName();
        if (this.mMsgDescriptorMapFull.containsKey(msgTypeNameFull)) {
            throw new IllegalArgumentException("duplicate name: " + msgTypeNameFull);
        }
        if (this.mMsgDescriptorMapShort.containsKey(msgTypeNameShort)) {
            msgDupes.add(msgTypeNameShort);
        }
        this.mMsgDescriptorMapFull.put(msgTypeNameFull, msgType);
        this.mMsgDescriptorMapShort.put(msgTypeNameShort, msgType);
        for (Descriptors.Descriptor nestedType : msgType.getNestedTypes()) {
            this.addMessageType(nestedType, msgTypeNameShort, msgDupes, enumDupes);
        }
        for (Descriptors.EnumDescriptor enumType : msgType.getEnumTypes()) {
            this.addEnumType(enumType, msgTypeNameShort, enumDupes);
        }
    }

    private void addEnumType(Descriptors.EnumDescriptor enumType, String scope, Set<String> enumDupes) {
        String enumTypeNameShort;
        String enumTypeNameFull = enumType.getFullName();
        String string = enumTypeNameShort = scope == null ? enumType.getName() : scope + "." + enumType.getName();
        if (this.mEnumDescriptorMapFull.containsKey(enumTypeNameFull)) {
            throw new IllegalArgumentException("duplicate name: " + enumTypeNameFull);
        }
        if (this.mEnumDescriptorMapShort.containsKey(enumTypeNameShort)) {
            enumDupes.add(enumTypeNameShort);
        }
        this.mEnumDescriptorMapFull.put(enumTypeNameFull, enumType);
        this.mEnumDescriptorMapShort.put(enumTypeNameShort, enumType);
    }

    public static class Builder {
        private DescriptorProtos.FileDescriptorProto.Builder mFileDescProtoBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
        private DescriptorProtos.FileDescriptorSet.Builder mFileDescSetBuilder = DescriptorProtos.FileDescriptorSet.newBuilder();

        public DynamicSchema build() throws Descriptors.DescriptorValidationException {
            DescriptorProtos.FileDescriptorSet.Builder fileDescSetBuilder = DescriptorProtos.FileDescriptorSet.newBuilder();
            fileDescSetBuilder.addFile(this.mFileDescProtoBuilder.build());
            fileDescSetBuilder.mergeFrom(this.mFileDescSetBuilder.build());
            return new DynamicSchema(fileDescSetBuilder.build());
        }

        public Builder setName(String name) {
            this.mFileDescProtoBuilder.setName(name);
            return this;
        }

        public Builder setPackage(String name) {
            this.mFileDescProtoBuilder.setPackage(name);
            return this;
        }

        public Builder addMessageDefinition(MessageDefinition msgDef) {
            this.mFileDescProtoBuilder.addMessageType(msgDef.getMessageType());
            return this;
        }

        public Builder addEnumDefinition(EnumDefinition enumDef) {
            this.mFileDescProtoBuilder.addEnumType(enumDef.getEnumType());
            return this;
        }

        public Builder addDependency(String dependency) {
            this.mFileDescProtoBuilder.addDependency(dependency);
            return this;
        }

        public Builder addPublicDependency(String dependency) {
            for (int i = 0; i < this.mFileDescProtoBuilder.getDependencyCount(); ++i) {
                if (!this.mFileDescProtoBuilder.getDependency(i).equals(dependency)) continue;
                this.mFileDescProtoBuilder.addPublicDependency(i);
                return this;
            }
            this.mFileDescProtoBuilder.addDependency(dependency);
            this.mFileDescProtoBuilder.addPublicDependency(this.mFileDescProtoBuilder.getDependencyCount() - 1);
            return this;
        }

        public Builder addSchema(DynamicSchema schema) {
            this.mFileDescSetBuilder.mergeFrom(schema.mFileDescSet);
            return this;
        }

        private Builder() {
        }
    }
}

