/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.m3ql.operator;

import java.util.List;
import org.apache.pinot.tsdb.spi.operator.BaseTimeSeriesOperator;
import org.apache.pinot.tsdb.spi.series.TimeSeries;
import org.apache.pinot.tsdb.spi.series.TimeSeriesBlock;

public class KeepLastValueOperator
extends BaseTimeSeriesOperator {
    public KeepLastValueOperator(List<BaseTimeSeriesOperator> childOperators) {
        super(childOperators);
    }

    public TimeSeriesBlock getNextBlock() {
        TimeSeriesBlock seriesBlock = ((BaseTimeSeriesOperator)this._childOperators.get(0)).nextBlock();
        seriesBlock.getSeriesMap().values().parallelStream().forEach(unionOfSeries -> {
            for (TimeSeries series : unionOfSeries) {
                Double[] values = series.getDoubleValues();
                Double lastValue = null;
                for (int index = 0; index < values.length; ++index) {
                    if (values[index] != null) {
                        lastValue = values[index];
                        continue;
                    }
                    values[index] = lastValue;
                }
            }
        });
        return seriesBlock;
    }

    public String getExplainName() {
        return "KEEP_LAST_VALUE";
    }
}

