/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.m3ql.operator;

import java.util.List;
import org.apache.pinot.tsdb.spi.operator.BaseTimeSeriesOperator;
import org.apache.pinot.tsdb.spi.series.TimeSeries;
import org.apache.pinot.tsdb.spi.series.TimeSeriesBlock;

public class TransformNullOperator
extends BaseTimeSeriesOperator {
    private final Double _defaultValue;

    public TransformNullOperator(Double defaultValue, List<BaseTimeSeriesOperator> childOperators) {
        super(childOperators);
        this._defaultValue = defaultValue;
    }

    public TimeSeriesBlock getNextBlock() {
        TimeSeriesBlock seriesBlock = ((BaseTimeSeriesOperator)this._childOperators.get(0)).nextBlock();
        seriesBlock.getSeriesMap().values().parallelStream().forEach(unionOfSeries -> {
            for (TimeSeries series : unionOfSeries) {
                Double[] values = series.getDoubleValues();
                for (int index = 0; index < values.length; ++index) {
                    values[index] = values[index] == null ? this._defaultValue : values[index];
                }
            }
        });
        return seriesBlock;
    }

    public String getExplainName() {
        return "TRANSFORM_NULL";
    }
}

