/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class FetchSessionHandler {
    private final Logger log;
    private final int node;
    private FetchMetadata nextMetadata = FetchMetadata.INITIAL;
    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> sessionPartitions = new LinkedHashMap(0);

    public FetchSessionHandler(LogContext logContext, int node) {
        this.log = logContext.logger(FetchSessionHandler.class);
        this.node = node;
    }

    public Builder newBuilder() {
        return new Builder();
    }

    public Builder newBuilder(int size, boolean copySessionPartitions) {
        return new Builder(size, copySessionPartitions);
    }

    private String partitionsToLogString(Collection<TopicPartition> partitions) {
        if (!this.log.isTraceEnabled()) {
            return String.format("%d partition(s)", partitions.size());
        }
        return "(" + Utils.join(partitions, ", ") + ")";
    }

    static Set<TopicPartition> findMissing(Set<TopicPartition> toFind, Set<TopicPartition> toSearch) {
        LinkedHashSet<TopicPartition> ret = new LinkedHashSet<TopicPartition>();
        for (TopicPartition partition2 : toFind) {
            if (toSearch.contains(partition2)) continue;
            ret.add(partition2);
        }
        return ret;
    }

    String verifyFullFetchResponsePartitions(FetchResponse<?> response) {
        StringBuilder bld = new StringBuilder();
        Set<TopicPartition> extra = FetchSessionHandler.findMissing(response.responseData().keySet(), this.sessionPartitions.keySet());
        Set<TopicPartition> omitted = FetchSessionHandler.findMissing(this.sessionPartitions.keySet(), response.responseData().keySet());
        if (!omitted.isEmpty()) {
            bld.append("omitted=(").append(Utils.join(omitted, ", ")).append(", ");
        }
        if (!extra.isEmpty()) {
            bld.append("extra=(").append(Utils.join(extra, ", ")).append(", ");
        }
        if (!omitted.isEmpty() || !extra.isEmpty()) {
            bld.append("response=(").append(Utils.join(response.responseData().keySet(), ", ")).append(")");
            return bld.toString();
        }
        return null;
    }

    String verifyIncrementalFetchResponsePartitions(FetchResponse<?> response) {
        Set<TopicPartition> extra = FetchSessionHandler.findMissing(response.responseData().keySet(), this.sessionPartitions.keySet());
        if (!extra.isEmpty()) {
            StringBuilder bld = new StringBuilder();
            bld.append("extra=(").append(Utils.join(extra, ", ")).append("), ");
            bld.append("response=(").append(Utils.join(response.responseData().keySet(), ", ")).append("), ");
            return bld.toString();
        }
        return null;
    }

    private String responseDataToLogString(FetchResponse<?> response) {
        if (!this.log.isTraceEnabled()) {
            int implied = this.sessionPartitions.size() - response.responseData().size();
            if (implied > 0) {
                return String.format(" with %d response partition(s), %d implied partition(s)", response.responseData().size(), implied);
            }
            return String.format(" with %d response partition(s)", response.responseData().size());
        }
        StringBuilder bld = new StringBuilder();
        bld.append(" with response=(").append(Utils.join(response.responseData().keySet(), ", ")).append(")");
        String prefix = ", implied=(";
        String suffix = "";
        for (TopicPartition partition2 : this.sessionPartitions.keySet()) {
            if (response.responseData().containsKey(partition2)) continue;
            bld.append(prefix);
            bld.append(partition2);
            prefix = ", ";
            suffix = ")";
        }
        bld.append(suffix);
        return bld.toString();
    }

    public boolean handleResponse(FetchResponse<?> response) {
        if (response.error() != Errors.NONE) {
            this.log.info("Node {} was unable to process the fetch request with {}: {}.", new Object[]{this.node, this.nextMetadata, response.error()});
            this.nextMetadata = response.error() == Errors.FETCH_SESSION_ID_NOT_FOUND ? FetchMetadata.INITIAL : this.nextMetadata.nextCloseExisting();
            return false;
        }
        if (this.nextMetadata.isFull()) {
            if (response.responseData().isEmpty() && response.throttleTimeMs() > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Node {} sent a empty full fetch response to indicate that this client should be throttled for {} ms.", (Object)this.node, (Object)response.throttleTimeMs());
                }
                this.nextMetadata = FetchMetadata.INITIAL;
                return false;
            }
            String problem = this.verifyFullFetchResponsePartitions(response);
            if (problem != null) {
                this.log.info("Node {} sent an invalid full fetch response with {}", (Object)this.node, (Object)problem);
                this.nextMetadata = FetchMetadata.INITIAL;
                return false;
            }
            if (response.sessionId() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Node {} sent a full fetch response{}", (Object)this.node, (Object)this.responseDataToLogString(response));
                }
                this.nextMetadata = FetchMetadata.INITIAL;
                return true;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Node {} sent a full fetch response that created a new incremental fetch session {}{}", this.node, response.sessionId(), this.responseDataToLogString(response));
            }
            this.nextMetadata = FetchMetadata.newIncremental(response.sessionId());
            return true;
        }
        String problem = this.verifyIncrementalFetchResponsePartitions(response);
        if (problem != null) {
            this.log.info("Node {} sent an invalid incremental fetch response with {}", (Object)this.node, (Object)problem);
            this.nextMetadata = this.nextMetadata.nextCloseExisting();
            return false;
        }
        if (response.sessionId() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Node {} sent an incremental fetch response closing session {}{}", this.node, this.nextMetadata.sessionId(), this.responseDataToLogString(response));
            }
            this.nextMetadata = FetchMetadata.INITIAL;
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Node {} sent an incremental fetch response with throttleTimeMs = {} for session {}{}", this.node, response.throttleTimeMs(), response.sessionId(), this.responseDataToLogString(response));
        }
        this.nextMetadata = this.nextMetadata.nextIncremental();
        return true;
    }

    public void handleError(Throwable t2) {
        this.log.info("Error sending fetch request {} to node {}:", this.nextMetadata, this.node, t2);
        this.nextMetadata = this.nextMetadata.nextCloseExisting();
    }

    public class Builder {
        private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> next;
        private final boolean copySessionPartitions;

        Builder() {
            this.next = new LinkedHashMap();
            this.copySessionPartitions = true;
        }

        Builder(int initialSize, boolean copySessionPartitions) {
            this.next = new LinkedHashMap(initialSize);
            this.copySessionPartitions = copySessionPartitions;
        }

        public void add(TopicPartition topicPartition, FetchRequest.PartitionData data) {
            this.next.put(topicPartition, data);
        }

        public FetchRequestData build() {
            TopicPartition topicPartition;
            if (FetchSessionHandler.this.nextMetadata.isFull()) {
                if (FetchSessionHandler.this.log.isDebugEnabled()) {
                    FetchSessionHandler.this.log.debug("Built full fetch {} for node {} with {}.", FetchSessionHandler.this.nextMetadata, FetchSessionHandler.this.node, FetchSessionHandler.this.partitionsToLogString(this.next.keySet()));
                }
                FetchSessionHandler.this.sessionPartitions = this.next;
                this.next = null;
                Map<TopicPartition, FetchRequest.PartitionData> toSend = Collections.unmodifiableMap(new LinkedHashMap(FetchSessionHandler.this.sessionPartitions));
                return new FetchRequestData(toSend, Collections.emptyList(), toSend, FetchSessionHandler.this.nextMetadata);
            }
            ArrayList<TopicPartition> added = new ArrayList<TopicPartition>();
            ArrayList<TopicPartition> removed = new ArrayList<TopicPartition>();
            ArrayList<TopicPartition> altered = new ArrayList<TopicPartition>();
            Iterator<Map.Entry<Object, Object>> iter = FetchSessionHandler.this.sessionPartitions.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                topicPartition = (TopicPartition)entry.getKey();
                FetchRequest.PartitionData prevData = (FetchRequest.PartitionData)entry.getValue();
                FetchRequest.PartitionData nextData = (FetchRequest.PartitionData)this.next.remove(topicPartition);
                if (nextData != null) {
                    if (prevData.equals(nextData)) continue;
                    this.next.put(topicPartition, nextData);
                    entry.setValue(nextData);
                    altered.add(topicPartition);
                    continue;
                }
                iter.remove();
                removed.add(topicPartition);
            }
            for (Map.Entry<Object, Object> entry : this.next.entrySet()) {
                topicPartition = (TopicPartition)entry.getKey();
                FetchRequest.PartitionData nextData = (FetchRequest.PartitionData)entry.getValue();
                if (FetchSessionHandler.this.sessionPartitions.containsKey(topicPartition)) break;
                FetchSessionHandler.this.sessionPartitions.put(topicPartition, nextData);
                added.add(topicPartition);
            }
            if (FetchSessionHandler.this.log.isDebugEnabled()) {
                FetchSessionHandler.this.log.debug("Built incremental fetch {} for node {}. Added {}, altered {}, removed {} out of {}", FetchSessionHandler.this.nextMetadata, FetchSessionHandler.this.node, FetchSessionHandler.this.partitionsToLogString(added), FetchSessionHandler.this.partitionsToLogString(altered), FetchSessionHandler.this.partitionsToLogString(removed), FetchSessionHandler.this.partitionsToLogString(FetchSessionHandler.this.sessionPartitions.keySet()));
            }
            Map<TopicPartition, FetchRequest.PartitionData> toSend = Collections.unmodifiableMap(this.next);
            Map<TopicPartition, FetchRequest.PartitionData> map = this.copySessionPartitions ? Collections.unmodifiableMap(new LinkedHashMap(FetchSessionHandler.this.sessionPartitions)) : Collections.unmodifiableMap(FetchSessionHandler.this.sessionPartitions);
            this.next = null;
            return new FetchRequestData(toSend, Collections.unmodifiableList(removed), map, FetchSessionHandler.this.nextMetadata);
        }
    }

    public static class FetchRequestData {
        private final Map<TopicPartition, FetchRequest.PartitionData> toSend;
        private final List<TopicPartition> toForget;
        private final Map<TopicPartition, FetchRequest.PartitionData> sessionPartitions;
        private final FetchMetadata metadata;

        FetchRequestData(Map<TopicPartition, FetchRequest.PartitionData> toSend, List<TopicPartition> toForget, Map<TopicPartition, FetchRequest.PartitionData> sessionPartitions, FetchMetadata metadata) {
            this.toSend = toSend;
            this.toForget = toForget;
            this.sessionPartitions = sessionPartitions;
            this.metadata = metadata;
        }

        public Map<TopicPartition, FetchRequest.PartitionData> toSend() {
            return this.toSend;
        }

        public List<TopicPartition> toForget() {
            return this.toForget;
        }

        public Map<TopicPartition, FetchRequest.PartitionData> sessionPartitions() {
            return this.sessionPartitions;
        }

        public FetchMetadata metadata() {
            return this.metadata;
        }

        public String toString() {
            if (this.metadata.isFull()) {
                StringBuilder bld = new StringBuilder("FullFetchRequest(");
                String prefix = "";
                for (TopicPartition partition2 : this.toSend.keySet()) {
                    bld.append(prefix);
                    bld.append(partition2);
                    prefix = ", ";
                }
                bld.append(")");
                return bld.toString();
            }
            StringBuilder bld = new StringBuilder("IncrementalFetchRequest(toSend=(");
            String prefix = "";
            for (TopicPartition partition3 : this.toSend.keySet()) {
                bld.append(prefix);
                bld.append(partition3);
                prefix = ", ";
            }
            bld.append("), toForget=(");
            prefix = "";
            for (TopicPartition partition3 : this.toForget) {
                bld.append(prefix);
                bld.append(partition3);
                prefix = ", ";
            }
            bld.append("), implied=(");
            prefix = "";
            for (TopicPartition partition3 : this.sessionPartitions.keySet()) {
                if (this.toSend.containsKey(partition3)) continue;
                bld.append(prefix);
                bld.append(partition3);
                prefix = ", ";
            }
            bld.append("))");
            return bld.toString();
        }
    }
}

