/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.EncoderFactory;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;
import org.apache.pinot.shaded.com.google.common.cache.Cache;
import org.apache.pinot.shaded.com.google.common.cache.CacheBuilder;

public abstract class AbstractKafkaAvroSerializer
extends AbstractKafkaSchemaSerDe {
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    protected boolean normalizeSchema;
    protected boolean autoRegisterSchema;
    protected boolean removeJavaProperties;
    protected int useSchemaId = -1;
    protected boolean idCompatStrict;
    protected boolean latestCompatStrict;
    protected boolean avroReflectionAllowNull = false;
    protected boolean avroUseLogicalTypeConverters = false;
    private final Cache<Schema, DatumWriter<Object>> datumWriterCache = CacheBuilder.newBuilder().maximumSize(1000L).weakKeys().build();

    protected void configure(KafkaAvroSerializerConfig config) {
        this.configureClientProperties(config, new AvroSchemaProvider());
        this.normalizeSchema = config.normalizeSchema();
        this.autoRegisterSchema = config.autoRegisterSchema();
        this.removeJavaProperties = config.getBoolean("avro.remove.java.properties");
        this.useSchemaId = config.useSchemaId();
        this.idCompatStrict = config.getIdCompatibilityStrict();
        this.latestCompatStrict = config.getLatestCompatibilityStrict();
        this.avroReflectionAllowNull = config.getBoolean("avro.reflection.allow.null");
        this.avroUseLogicalTypeConverters = config.getBoolean("avro.use.logical.type.converters");
    }

    protected KafkaAvroSerializerConfig serializerConfig(Map<String, ?> props) {
        return new KafkaAvroSerializerConfig(props);
    }

    protected KafkaAvroSerializerConfig serializerConfig(Properties props) {
        return new KafkaAvroSerializerConfig(props);
    }

    protected byte[] serializeImpl(String subject, Object object, AvroSchema schema) throws SerializationException, InvalidConfigurationException {
        return this.serializeImpl(subject, null, null, object, schema);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] serializeImpl(String subject, String topic, Headers headers, Object object, AvroSchema schema) throws SerializationException, InvalidConfigurationException {
        if (this.schemaRegistry == null) {
            StringBuilder userFriendlyMsgBuilder = new StringBuilder();
            userFriendlyMsgBuilder.append("You must configure() before serialize()");
            userFriendlyMsgBuilder.append(" or use serializer constructor with SchemaRegistryClient");
            throw new InvalidConfigurationException(userFriendlyMsgBuilder.toString());
        }
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            int id;
            if (this.autoRegisterSchema) {
                Optional<ParsedSchema> optSchema;
                restClientErrorMsg = "Error registering Avro schema";
                io.confluent.kafka.schemaregistry.client.rest.entities.Schema s2 = this.registerWithResponse(subject, schema, this.normalizeSchema);
                if (s2.getSchema() != null && (optSchema = this.schemaRegistry.parseSchema(s2)).isPresent()) {
                    schema = (AvroSchema)optSchema.get();
                    schema = schema.copy(s2.getVersion());
                }
                id = s2.getId();
            } else if (this.useSchemaId >= 0) {
                restClientErrorMsg = "Error retrieving schema ID";
                schema = (AvroSchema)this.lookupSchemaBySubjectAndId(subject, this.useSchemaId, schema, this.idCompatStrict);
                id = this.schemaRegistry.getId(subject, schema);
            } else if (this.metadata != null) {
                restClientErrorMsg = "Error retrieving latest with metadata '" + this.metadata + "'";
                schema = (AvroSchema)this.getLatestWithMetadata(subject);
                id = this.schemaRegistry.getId(subject, schema);
            } else if (this.useLatestVersion) {
                restClientErrorMsg = "Error retrieving latest version of Avro schema";
                schema = (AvroSchema)this.lookupLatestVersion(subject, schema, this.latestCompatStrict);
                id = this.schemaRegistry.getId(subject, schema);
            } else {
                restClientErrorMsg = "Error retrieving Avro schema";
                id = this.schemaRegistry.getId(subject, schema, this.normalizeSchema);
            }
            object = this.executeRules(subject, topic, headers, RuleMode.WRITE, null, schema, object);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            Object value = object instanceof NonRecordContainer ? ((NonRecordContainer)object).getValue() : object;
            Schema rawSchema = schema.rawSchema();
            if (rawSchema.getType().equals((Object)Schema.Type.BYTES)) {
                if (value instanceof byte[]) {
                    out.write((byte[])value);
                } else {
                    if (!(value instanceof ByteBuffer)) throw new SerializationException("Unrecognized bytes object of type: " + value.getClass().getName());
                    out.write(((ByteBuffer)value).array());
                }
            } else {
                this.writeDatum(out, value, rawSchema);
            }
            byte[] bytes = out.toByteArray();
            out.close();
            byte[] byArray = bytes;
            return byArray;
        }
        catch (ExecutionException ex) {
            throw new SerializationException("Error serializing Avro message", ex.getCause());
        }
        catch (InterruptedIOException e) {
            throw new TimeoutException("Error serializing Avro message", e);
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing Avro message", e);
        }
        catch (RestClientException e) {
            throw AbstractKafkaAvroSerializer.toKafkaException(e, restClientErrorMsg + schema);
        }
        finally {
            this.postOp(object);
        }
    }

    private void writeDatum(ByteArrayOutputStream out, Object value, Schema rawSchema) throws ExecutionException, IOException {
        BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder(out, null);
        DatumWriter writer = this.datumWriterCache.get(rawSchema, () -> AvroSchemaUtils.getDatumWriter(value, rawSchema, this.avroUseLogicalTypeConverters));
        writer.write(value, encoder);
        encoder.flush();
    }
}

