/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.com.fasterxml.jackson.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonStreamContext;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.io.NumberInput;

public class JsonPointer
implements Serializable {
    public static final char ESC = '~';
    public static final String ESC_SLASH = "~1";
    public static final String ESC_TILDE = "~0";
    private static final long serialVersionUID = 1L;
    public static final char SEPARATOR = '/';
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected volatile JsonPointer _head;
    protected final String _asString;
    protected final int _asStringOffset;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;
    protected int _hashCode;

    protected JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = null;
        this._matchingElementIndex = -1;
        this._asString = "";
        this._asStringOffset = 0;
    }

    protected JsonPointer(String fullString, int fullStringOffset, String segment, JsonPointer next) {
        this._asString = fullString;
        this._asStringOffset = fullStringOffset;
        this._nextSegment = next;
        this._matchingPropertyName = segment;
        this._matchingElementIndex = JsonPointer._parseIndex(segment);
    }

    protected JsonPointer(String fullString, int fullStringOffset, String segment, int matchIndex, JsonPointer next) {
        this._asString = fullString;
        this._asStringOffset = fullStringOffset;
        this._nextSegment = next;
        this._matchingPropertyName = segment;
        this._matchingElementIndex = matchIndex;
    }

    protected JsonPointer(JsonPointer src, JsonPointer next) {
        this._asString = src._asString;
        this._asStringOffset = src._asStringOffset;
        this._nextSegment = next;
        this._matchingPropertyName = src._matchingPropertyName;
        this._matchingElementIndex = src._matchingElementIndex;
    }

    protected JsonPointer(JsonPointer src, String newFullString, int newFullStringOffset) {
        this._asString = newFullString;
        this._asStringOffset = newFullStringOffset;
        this._nextSegment = null;
        this._matchingPropertyName = src._matchingPropertyName;
        this._matchingElementIndex = src._matchingElementIndex;
    }

    public static JsonPointer compile(String expr) throws IllegalArgumentException {
        if (expr == null || expr.length() == 0) {
            return EMPTY;
        }
        if (expr.charAt(0) != '/') {
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + expr + "\"");
        }
        return JsonPointer._parseTail(expr);
    }

    public static JsonPointer valueOf(String expr) {
        return JsonPointer.compile(expr);
    }

    public static JsonPointer empty() {
        return EMPTY;
    }

    public static JsonPointer forPath(JsonStreamContext context, boolean includeRoot) {
        if (context == null) {
            return EMPTY;
        }
        if (!(context.hasPathSegment() || includeRoot && context.inRoot() && context.hasCurrentIndex())) {
            context = context.getParent();
        }
        PointerSegment next = null;
        int approxLength = 0;
        while (context != null) {
            if (context.inObject()) {
                String propName = context.getCurrentName();
                if (propName == null) {
                    propName = "";
                }
                approxLength += 2 + propName.length();
                next = new PointerSegment(next, propName, -1);
            } else if (context.inArray() || includeRoot) {
                int ix = context.getCurrentIndex();
                approxLength += 6;
                next = new PointerSegment(next, null, ix);
            }
            context = context.getParent();
        }
        if (next == null) {
            return EMPTY;
        }
        StringBuilder pathBuilder = new StringBuilder(approxLength);
        PointerSegment last = null;
        while (next != null) {
            last = next;
            next.pathOffset = pathBuilder.length();
            pathBuilder.append('/');
            if (next.property != null) {
                JsonPointer._appendEscaped(pathBuilder, next.property);
            } else {
                pathBuilder.append(next.index);
            }
            next = next.next;
        }
        String fullPath = pathBuilder.toString();
        PointerSegment currSegment = last;
        JsonPointer currPtr = EMPTY;
        while (currSegment != null) {
            if (currSegment.property != null) {
                currPtr = new JsonPointer(fullPath, currSegment.pathOffset, currSegment.property, currPtr);
            } else {
                int index = currSegment.index;
                currPtr = new JsonPointer(fullPath, currSegment.pathOffset, String.valueOf(index), index, currPtr);
            }
            currSegment = currSegment.prev;
        }
        return currPtr;
    }

    private static void _appendEscaped(StringBuilder sb, String segment) {
        int end = segment.length();
        for (int i = 0; i < end; ++i) {
            char c = segment.charAt(i);
            if (c == '/') {
                sb.append(ESC_SLASH);
                continue;
            }
            if (c == '~') {
                sb.append(ESC_TILDE);
                continue;
            }
            sb.append(c);
        }
    }

    public int length() {
        return this._asString.length() - this._asStringOffset;
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer last() {
        JsonPointer next;
        JsonPointer current = this;
        if (current == EMPTY) {
            return null;
        }
        while ((next = current._nextSegment) != EMPTY) {
            current = next;
        }
        return current;
    }

    public JsonPointer append(JsonPointer tail) {
        if (this == EMPTY) {
            return tail;
        }
        if (tail == EMPTY) {
            return this;
        }
        String currentJsonPointer = this.toString();
        return JsonPointer.compile(currentJsonPointer + tail.toString());
    }

    public JsonPointer appendProperty(String property) {
        if (property == null) {
            return this;
        }
        StringBuilder sb = this.toStringBuilder(property.length() + 2).append('/');
        JsonPointer._appendEscaped(sb, property);
        return JsonPointer.compile(sb.toString());
    }

    public JsonPointer appendIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index cannot be appended");
        }
        return JsonPointer.compile(this.toStringBuilder(8).append('/').append(index).toString());
    }

    public boolean matchesProperty(String name) {
        return this._nextSegment != null && this._matchingPropertyName.equals(name);
    }

    public JsonPointer matchProperty(String name) {
        if (this._nextSegment != null && this._matchingPropertyName.equals(name)) {
            return this._nextSegment;
        }
        return null;
    }

    public boolean matchesElement(int index) {
        return index == this._matchingElementIndex && index >= 0;
    }

    public JsonPointer matchElement(int index) {
        if (index != this._matchingElementIndex || index < 0) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public JsonPointer head() {
        JsonPointer h2 = this._head;
        if (h2 == null) {
            if (this != EMPTY) {
                h2 = this._constructHead();
            }
            this._head = h2;
        }
        return h2;
    }

    public String toString() {
        if (this._asStringOffset <= 0) {
            return this._asString;
        }
        return this._asString.substring(this._asStringOffset);
    }

    protected StringBuilder toStringBuilder(int slack) {
        if (this._asStringOffset <= 0) {
            return new StringBuilder(this._asString);
        }
        int len = this._asString.length();
        StringBuilder sb = new StringBuilder(len - this._asStringOffset + slack);
        sb.append(this._asString, this._asStringOffset, len);
        return sb;
    }

    public int hashCode() {
        int h2 = this._hashCode;
        if (h2 == 0) {
            h2 = this.toString().hashCode();
            if (h2 == 0) {
                h2 = -1;
            }
            this._hashCode = h2;
        }
        return h2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof JsonPointer)) {
            return false;
        }
        JsonPointer other = (JsonPointer)o;
        return this._compare(this._asString, this._asStringOffset, other._asString, other._asStringOffset);
    }

    private final boolean _compare(String str1, int offset1, String str2, int offset2) {
        int end1 = str1.length();
        if (end1 - offset1 != str2.length() - offset2) {
            return false;
        }
        while (offset1 < end1) {
            if (str1.charAt(offset1++) == str2.charAt(offset2++)) continue;
            return false;
        }
        return true;
    }

    private static final int _parseIndex(String str) {
        int len = str.length();
        if (len == 0 || len > 10) {
            return -1;
        }
        char c = str.charAt(0);
        if (c <= '0') {
            return len == 1 && c == '0' ? 0 : -1;
        }
        if (c > '9') {
            return -1;
        }
        for (int i = 1; i < len; ++i) {
            c = str.charAt(i);
            if (c <= '9' && c >= '0') continue;
            return -1;
        }
        if (len == 10) {
            long l = Long.parseLong(str);
            if (l > Integer.MAX_VALUE) {
                return -1;
            }
            return (int)l;
        }
        return NumberInput.parseInt(str);
    }

    protected static JsonPointer _parseTail(String fullPath) {
        PointerParent parent = null;
        int i = 1;
        int end = fullPath.length();
        int startOffset = 0;
        while (i < end) {
            char c = fullPath.charAt(i);
            if (c == '/') {
                parent = new PointerParent(parent, startOffset, fullPath.substring(startOffset + 1, i));
                startOffset = i++;
                continue;
            }
            if (c != '~' || ++i >= end) continue;
            StringBuilder sb = new StringBuilder(32);
            i = JsonPointer._extractEscapedSegment(fullPath, startOffset + 1, i, sb);
            String segment = sb.toString();
            if (i < 0) {
                return JsonPointer._buildPath(fullPath, startOffset, segment, parent);
            }
            parent = new PointerParent(parent, startOffset, segment);
            startOffset = i++;
        }
        return JsonPointer._buildPath(fullPath, startOffset, fullPath.substring(startOffset + 1), parent);
    }

    private static JsonPointer _buildPath(String fullPath, int fullPathOffset, String segment, PointerParent parent) {
        JsonPointer curr = new JsonPointer(fullPath, fullPathOffset, segment, EMPTY);
        while (parent != null) {
            curr = new JsonPointer(fullPath, parent.fullPathOffset, parent.segment, curr);
            parent = parent.parent;
        }
        return curr;
    }

    protected static int _extractEscapedSegment(String input, int firstCharOffset, int i, StringBuilder sb) {
        int end = input.length();
        int toCopy = i - 1 - firstCharOffset;
        if (toCopy > 0) {
            sb.append(input, firstCharOffset, i - 1);
        }
        i += JsonPointer._appendEscape(sb, input.charAt(i));
        while (i < end) {
            char c = input.charAt(i);
            if (c == '/') {
                return i;
            }
            if (c == '~' && ++i < end) {
                i += JsonPointer._appendEscape(sb, input.charAt(i));
                continue;
            }
            sb.append(c);
        }
        return -1;
    }

    private static int _appendEscape(StringBuilder sb, char c) {
        if (c == '0') {
            sb.append('~');
            return 1;
        }
        if (c == '1') {
            sb.append('/');
            return 1;
        }
        sb.append('~');
        return 0;
    }

    protected JsonPointer _constructHead() {
        JsonPointer last = this.last();
        if (last == this) {
            return EMPTY;
        }
        ArrayList<JsonPointer> pointers = new ArrayList<JsonPointer>();
        JsonPointer current = this;
        String origFullString = this.toString();
        String fullString = origFullString.substring(0, origFullString.length() - last.length());
        int offsetDiff = -this._asStringOffset;
        while (current != last) {
            JsonPointer nextSegment = new JsonPointer(current, fullString, current._asStringOffset + offsetDiff);
            pointers.add(nextSegment);
            current = current._nextSegment;
        }
        JsonPointer head = EMPTY;
        for (int i = pointers.size() - 1; i >= 0; --i) {
            head = new JsonPointer((JsonPointer)pointers.get(i), head);
        }
        return head;
    }

    private Object writeReplace() {
        return new Serialization(this.toString());
    }

    static class Serialization
    implements Externalizable {
        private String _fullPath;

        public Serialization() {
        }

        Serialization(String fullPath) {
            this._fullPath = fullPath;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this._fullPath);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._fullPath = in.readUTF();
        }

        private Object readResolve() throws ObjectStreamException {
            return JsonPointer.compile(this._fullPath);
        }
    }

    private static class PointerSegment {
        public final PointerSegment next;
        public final String property;
        public final int index;
        public int pathOffset;
        public PointerSegment prev;

        public PointerSegment(PointerSegment next, String pn, int ix) {
            this.next = next;
            this.property = pn;
            this.index = ix;
            if (next != null) {
                next.prev = this;
            }
        }
    }

    private static class PointerParent {
        public final PointerParent parent;
        public final int fullPathOffset;
        public final String segment;

        PointerParent(PointerParent pp, int fpo, String sgm) {
            this.parent = pp;
            this.fullPathOffset = fpo;
            this.segment = sgm;
        }
    }
}

