/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.counters.AbstractCounterGroup;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.hadoop.mapreduce.counters.CounterGroupFactory;
import org.apache.hadoop.mapreduce.counters.FileSystemCounterGroup;
import org.apache.hadoop.mapreduce.counters.FrameworkCounterGroup;
import org.apache.hadoop.mapreduce.counters.GenericCounter;
import org.apache.hadoop.mapreduce.counters.Limits;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormatCounter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormatCounter;
import org.apache.hadoop.mapreduce.util.CountersStrings;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterators;
import org.slf4j.Logger;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Counters
extends AbstractCounters<Counter, Group> {
    public static final int MAX_COUNTER_LIMIT = Limits.getCountersMax();
    public static final int MAX_GROUP_LIMIT = Limits.getGroupsMax();
    private static final HashMap<String, String> depricatedCounterMap = new HashMap();
    private static final GroupFactory groupFactory;

    public Counters() {
        super(groupFactory);
    }

    public Counters(org.apache.hadoop.mapreduce.Counters newCounters) {
        super(newCounters, groupFactory);
    }

    private static void initDepricatedMap() {
        depricatedCounterMap.put(FileInputFormat.Counter.class.getName(), FileInputFormatCounter.class.getName());
        depricatedCounterMap.put(FileOutputFormat.Counter.class.getName(), FileOutputFormatCounter.class.getName());
        depricatedCounterMap.put(FileInputFormat.Counter.class.getName(), FileInputFormatCounter.class.getName());
        depricatedCounterMap.put(FileOutputFormat.Counter.class.getName(), FileOutputFormatCounter.class.getName());
    }

    private static String getNewGroupKey(String oldGroup) {
        if (depricatedCounterMap.containsKey(oldGroup)) {
            return depricatedCounterMap.get(oldGroup);
        }
        return null;
    }

    static Counters downgrade(org.apache.hadoop.mapreduce.Counters newCounters) {
        return new Counters(newCounters);
    }

    @Override
    public synchronized Group getGroup(String groupName) {
        return (Group)super.getGroup(groupName);
    }

    public synchronized Collection<String> getGroupNames() {
        return IteratorUtils.toList(super.getGroupNames().iterator());
    }

    public synchronized String makeCompactString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Group group : this) {
            for (Counter counter : group) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(group.getDisplayName());
                builder.append('.');
                builder.append(counter.getDisplayName());
                builder.append(':');
                builder.append(counter.getCounter());
            }
        }
        return builder.toString();
    }

    static long getCounterValue(CounterGroupBase<Counter> group, String counterName) {
        Counter counter = group.findCounter(counterName, false);
        if (counter != null) {
            return counter.getValue();
        }
        return 0L;
    }

    @Override
    public synchronized Counter findCounter(String group, String name) {
        if (name.equals("MAP_INPUT_BYTES")) {
            LOG.warn("Counter name MAP_INPUT_BYTES is deprecated. Use FileInputFormatCounters as group name and  BYTES_READ as counter name instead");
            return (Counter)this.findCounter(FileInputFormatCounter.BYTES_READ);
        }
        String newGroupKey = Counters.getNewGroupKey(group);
        if (newGroupKey != null) {
            group = newGroupKey;
        }
        return this.getGroup(group).getCounterForName(name);
    }

    @Deprecated
    public Counter findCounter(String group, int id, String name) {
        return this.findCounter(group, name);
    }

    public void incrCounter(Enum<?> key, long amount) {
        ((Counter)this.findCounter(key)).increment(amount);
    }

    public void incrCounter(String group, String counter, long amount) {
        this.findCounter(group, counter).increment(amount);
    }

    public synchronized long getCounter(Enum<?> key) {
        return ((Counter)this.findCounter(key)).getValue();
    }

    public synchronized void incrAllCounters(Counters other) {
        for (Group otherGroup : other) {
            Group group = this.getGroup(otherGroup.getName());
            group.setDisplayName(otherGroup.getDisplayName());
            for (Counter otherCounter : otherGroup) {
                Counter counter = group.getCounterForName(otherCounter.getName());
                counter.setDisplayName(otherCounter.getDisplayName());
                counter.increment(otherCounter.getValue());
            }
        }
    }

    public int size() {
        return this.countCounters();
    }

    public static Counters sum(Counters a, Counters b) {
        Counters counters = new Counters();
        counters.incrAllCounters(a);
        counters.incrAllCounters(b);
        return counters;
    }

    public void log(Logger log) {
        log.info("Counters: " + this.size());
        for (Group group : this) {
            log.info("  " + group.getDisplayName());
            for (Counter counter : group) {
                log.info("    " + counter.getDisplayName() + "=" + counter.getCounter());
            }
        }
    }

    public String makeEscapedCompactString() {
        return CountersStrings.toEscapedCompactString(this);
    }

    public static Counters fromEscapedCompactString(String compactString) throws ParseException {
        return CountersStrings.parseEscapedCompactString(compactString, new Counters());
    }

    static {
        Counters.initDepricatedMap();
        groupFactory = new GroupFactory();
    }

    public static class CountersExceededException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CountersExceededException(String msg) {
            super(msg);
        }

        public CountersExceededException(CountersExceededException cause) {
            super(cause);
        }
    }

    static class GroupFactory
    extends CounterGroupFactory<Counter, Group> {
        GroupFactory() {
        }

        @Override
        protected <T extends Enum<T>> CounterGroupFactory.FrameworkGroupFactory<Group> newFrameworkGroupFactory(final Class<T> cls) {
            return new CounterGroupFactory.FrameworkGroupFactory<Group>(){

                @Override
                public Group newGroup(String name) {
                    return new Group(new FrameworkGroupImpl(cls));
                }
            };
        }

        @Override
        protected Group newGenericGroup(String name, String displayName, Limits limits) {
            return new Group(new GenericGroup(name, displayName, limits));
        }

        @Override
        protected Group newFileSystemGroup() {
            return new Group(new FSGroupImpl());
        }
    }

    private static class FSGroupImpl
    extends FileSystemCounterGroup<Counter> {
        private FSGroupImpl() {
        }

        @Override
        protected Counter newCounter(String scheme, FileSystemCounter key) {
            return new Counter(new FileSystemCounterGroup.FSCounter(scheme, key));
        }

        @Override
        public CounterGroupBase<Counter> getUnderlyingGroup() {
            return this;
        }
    }

    private static class FrameworkGroupImpl<T extends Enum<T>>
    extends FrameworkCounterGroup<T, Counter> {
        FrameworkGroupImpl(Class<T> cls) {
            super(cls);
        }

        @Override
        protected Counter newCounter(T key) {
            return new Counter(new FrameworkCounterGroup.FrameworkCounter<T>(key, this.getName()));
        }

        @Override
        public CounterGroupBase<Counter> getUnderlyingGroup() {
            return this;
        }
    }

    private static class GenericGroup
    extends AbstractCounterGroup<Counter> {
        GenericGroup(String name, String displayName, Limits limits) {
            super(name, displayName, limits);
        }

        @Override
        protected Counter newCounter(String counterName, String displayName, long value) {
            return new Counter(new GenericCounter(counterName, displayName, value));
        }

        @Override
        protected Counter newCounter() {
            return new Counter();
        }

        @Override
        public CounterGroupBase<Counter> getUnderlyingGroup() {
            return this;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static class Group
    implements CounterGroupBase<Counter> {
        private CounterGroupBase<Counter> realGroup;

        protected Group() {
            this.realGroup = null;
        }

        Group(GenericGroup group) {
            this.realGroup = group;
        }

        Group(FSGroupImpl group) {
            this.realGroup = group;
        }

        Group(FrameworkGroupImpl group) {
            this.realGroup = group;
        }

        public long getCounter(String counterName) {
            return Counters.getCounterValue(this.realGroup, counterName);
        }

        public String makeEscapedCompactString() {
            return CountersStrings.toEscapedCompactString(this.realGroup);
        }

        @Deprecated
        public Counter getCounter(int id, String name) {
            return this.findCounter(name);
        }

        public Counter getCounterForName(String name) {
            return this.findCounter(name);
        }

        public void write(DataOutput out) throws IOException {
            this.realGroup.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.realGroup.readFields(in);
        }

        @Override
        public Iterator<Counter> iterator() {
            return this.realGroup.iterator();
        }

        @Override
        public String getName() {
            return this.realGroup.getName();
        }

        @Override
        public String getDisplayName() {
            return this.realGroup.getDisplayName();
        }

        @Override
        public void setDisplayName(String displayName) {
            this.realGroup.setDisplayName(displayName);
        }

        @Override
        public void addCounter(Counter counter) {
            this.realGroup.addCounter(counter);
        }

        @Override
        public Counter addCounter(String name, String displayName, long value) {
            return this.realGroup.addCounter(name, displayName, value);
        }

        @Override
        public Counter findCounter(String counterName, String displayName) {
            return this.realGroup.findCounter(counterName, displayName);
        }

        @Override
        public Counter findCounter(String counterName, boolean create) {
            return this.realGroup.findCounter(counterName, create);
        }

        @Override
        public Counter findCounter(String counterName) {
            return this.realGroup.findCounter(counterName);
        }

        @Override
        public int size() {
            return this.realGroup.size();
        }

        @Override
        public void incrAllCounters(CounterGroupBase<Counter> rightGroup) {
            this.realGroup.incrAllCounters(rightGroup);
        }

        @Override
        public CounterGroupBase<Counter> getUnderlyingGroup() {
            return this.realGroup;
        }

        public synchronized boolean equals(Object genericRight) {
            if (genericRight instanceof CounterGroupBase) {
                CounterGroupBase right = ((CounterGroupBase)genericRight).getUnderlyingGroup();
                return Iterators.elementsEqual(this.iterator(), right.iterator());
            }
            return false;
        }

        public int hashCode() {
            return this.realGroup.hashCode();
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static class Counter
    implements org.apache.hadoop.mapreduce.Counter {
        org.apache.hadoop.mapreduce.Counter realCounter;

        Counter(org.apache.hadoop.mapreduce.Counter counter) {
            this.realCounter = counter;
        }

        public Counter() {
            this(new GenericCounter());
        }

        @Override
        public void setDisplayName(String displayName) {
            this.realCounter.setDisplayName(displayName);
        }

        @Override
        public String getName() {
            return this.realCounter.getName();
        }

        @Override
        public String getDisplayName() {
            return this.realCounter.getDisplayName();
        }

        @Override
        public long getValue() {
            return this.realCounter.getValue();
        }

        @Override
        public void setValue(long value) {
            this.realCounter.setValue(value);
        }

        @Override
        public void increment(long incr) {
            this.realCounter.increment(incr);
        }

        public void write(DataOutput out) throws IOException {
            this.realCounter.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.realCounter.readFields(in);
        }

        public String makeEscapedCompactString() {
            return CountersStrings.toEscapedCompactString(this.realCounter);
        }

        @Deprecated
        public boolean contentEquals(Counter counter) {
            return this.realCounter.equals(counter.getUnderlyingCounter());
        }

        public long getCounter() {
            return this.realCounter.getValue();
        }

        @Override
        public org.apache.hadoop.mapreduce.Counter getUnderlyingCounter() {
            return this.realCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean equals(Object genericRight) {
            if (genericRight instanceof Counter) {
                Object object = genericRight;
                synchronized (object) {
                    Counter right = (Counter)genericRight;
                    return this.getName().equals(right.getName()) && this.getDisplayName().equals(right.getDisplayName()) && this.getValue() == right.getValue();
                }
            }
            return false;
        }

        public int hashCode() {
            return this.realCounter.hashCode();
        }
    }
}

