/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.PriorityQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.join.ComposableRecordReader;
import org.apache.hadoop.mapred.join.MultiFilterRecordReader;
import org.apache.hadoop.mapred.join.TupleWritable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class OverrideRecordReader<K extends WritableComparable, V extends Writable>
extends MultiFilterRecordReader<K, V> {
    OverrideRecordReader(int id, JobConf conf, int capacity, Class<? extends WritableComparator> cmpcl) throws IOException {
        super(id, conf, capacity, cmpcl);
    }

    @Override
    protected V emit(TupleWritable dst) {
        return (V)dst.iterator().next();
    }

    @Override
    protected void fillJoinCollector(K iterkey) throws IOException {
        PriorityQueue q = this.getRecordReaderQueue();
        if (!q.isEmpty()) {
            ComposableRecordReader t2;
            int highpos = -1;
            ArrayList<ComposableRecordReader> list = new ArrayList<ComposableRecordReader>(this.kids.length);
            q.peek().key(iterkey);
            WritableComparator cmp = this.getComparator();
            while (0 == cmp.compare(q.peek().key(), iterkey)) {
                t2 = q.poll();
                if (-1 == highpos || ((ComposableRecordReader)list.get(highpos)).id() < t2.id()) {
                    highpos = list.size();
                }
                list.add(t2);
                if (!q.isEmpty()) continue;
                break;
            }
            t2 = (ComposableRecordReader)list.remove(highpos);
            t2.accept(this.jc, iterkey);
            for (ComposableRecordReader rr : list) {
                rr.skip(iterkey);
            }
            list.add(t2);
            for (ComposableRecordReader rr : list) {
                if (!rr.hasNext()) continue;
                q.add(rr);
            }
        }
    }
}

