/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.type.LogicalType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.util.ClassUtil;
import org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.deser.util.RangeFactory;
import org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.deser.util.RangeHelper;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.collect.BoundType;
import org.apache.pinot.shaded.com.google.common.collect.Range;

public class RangeDeserializer
extends StdDeserializer<Range<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected static final Pattern PATTERN_DOUBLE_DOT = Pattern.compile("\\.\\.");
    protected final JavaType _rangeType;
    protected final JsonDeserializer<Object> _endpointDeserializer;
    protected final KeyDeserializer _fromStringDeserializer;
    protected final BoundType _defaultBoundType;
    protected final RangeHelper.RangeProperties _fieldNames;
    protected final JsonFormat.Shape _shape;

    public RangeDeserializer(BoundType defaultBoundType, JavaType rangeType) {
        this(rangeType, null, defaultBoundType, RangeHelper.standardNames(), JsonFormat.Shape.ANY, null);
    }

    @Deprecated
    public RangeDeserializer(JavaType rangeType, JsonDeserializer<?> endpointDeser) {
        this(rangeType, endpointDeser, null);
    }

    @Deprecated
    public RangeDeserializer(JavaType rangeType, JsonDeserializer<?> endpointDeser, BoundType defaultBoundType) {
        this(rangeType, endpointDeser, defaultBoundType, RangeHelper.standardNames());
    }

    @Deprecated
    protected RangeDeserializer(JavaType rangeType, JsonDeserializer<?> endpointDeser, BoundType defaultBoundType, RangeHelper.RangeProperties fieldNames) {
        this(rangeType, endpointDeser, defaultBoundType, fieldNames, JsonFormat.Shape.ANY, null);
    }

    protected RangeDeserializer(JavaType rangeType, JsonDeserializer<?> endpointDeser, BoundType defaultBoundType, RangeHelper.RangeProperties fieldNames, JsonFormat.Shape shape, KeyDeserializer fromStringDeserializer) {
        super(rangeType);
        this._rangeType = rangeType;
        this._endpointDeserializer = endpointDeser;
        this._fromStringDeserializer = fromStringDeserializer;
        this._defaultBoundType = defaultBoundType;
        this._fieldNames = fieldNames;
        this._shape = shape;
    }

    @Override
    public JavaType getValueType() {
        return this._rangeType;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.POJO;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        JsonFormat.Shape shape = format.getShape();
        RangeHelper.RangeProperties fieldNames = RangeHelper.getPropertyNames(ctxt.getConfig(), ctxt.getConfig().getPropertyNamingStrategy());
        JavaType endpointType = this._rangeType.containedType(0);
        if (endpointType == null) {
            endpointType = TypeFactory.unknownType();
        }
        if ((deser = this._endpointDeserializer) == null) {
            deser = ctxt.findContextualValueDeserializer(endpointType, property);
        } else if (deser instanceof ContextualDeserializer) {
            deser = ((ContextualDeserializer)((Object)deser)).createContextual(ctxt, property);
        }
        KeyDeserializer kd = this._fromStringDeserializer;
        if (shape == JsonFormat.Shape.STRING) {
            kd = ctxt.findKeyDeserializer(endpointType, property);
        }
        if (deser != this._endpointDeserializer || fieldNames != this._fieldNames || shape != this._shape || kd != this._fromStringDeserializer) {
            return new RangeDeserializer(this._rangeType, deser, this._defaultBoundType, fieldNames, shape, kd);
        }
        return this;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(p, ctxt);
    }

    @Override
    public Range<?> deserialize(JsonParser p, DeserializationContext context) throws IOException {
        JsonToken t2 = p.currentToken();
        if (t2 == JsonToken.START_OBJECT) {
            t2 = p.nextToken();
        }
        Comparable<?> lowerEndpoint = null;
        Comparable<?> upperEndpoint = null;
        BoundType lowerBoundType = this._defaultBoundType;
        BoundType upperBoundType = this._defaultBoundType;
        if (this._shape == JsonFormat.Shape.STRING) {
            this.expect(context, JsonToken.VALUE_STRING, t2);
            return this.deserializeRangeFromString(context, p);
        }
        while (t2 != JsonToken.END_OBJECT) {
            this.expect(context, JsonToken.FIELD_NAME, t2);
            String fieldName = p.currentName();
            try {
                if (fieldName.equals(this._fieldNames.lowerEndpoint)) {
                    p.nextToken();
                    lowerEndpoint = this.deserializeEndpoint(context, p);
                } else if (fieldName.equals(this._fieldNames.upperEndpoint)) {
                    p.nextToken();
                    upperEndpoint = this.deserializeEndpoint(context, p);
                } else if (fieldName.equals(this._fieldNames.lowerBoundType)) {
                    p.nextToken();
                    lowerBoundType = this.deserializeBoundType(context, p);
                } else if (fieldName.equals(this._fieldNames.upperBoundType)) {
                    p.nextToken();
                    upperBoundType = this.deserializeBoundType(context, p);
                } else {
                    context.handleUnknownProperty(p, this, Range.class, fieldName);
                }
            }
            catch (IllegalStateException e) {
                return (Range)context.reportBadDefinition(this.handledType(), e.getMessage());
            }
            t2 = p.nextToken();
        }
        try {
            if (lowerEndpoint != null && upperEndpoint != null) {
                Preconditions.checkState(lowerEndpoint.getClass() == upperEndpoint.getClass(), "Endpoint types are not the same - 'lowerEndpoint' deserialized to [%s], and 'upperEndpoint' deserialized to [%s].", (Object)lowerEndpoint.getClass().getName(), (Object)upperEndpoint.getClass().getName());
                Preconditions.checkState(lowerBoundType != null, "'lowerEndpoint' field found, but not 'lowerBoundType'");
                Preconditions.checkState(upperBoundType != null, "'upperEndpoint' field found, but not 'upperBoundType'");
                return RangeFactory.range(lowerEndpoint, lowerBoundType, upperEndpoint, upperBoundType);
            }
            if (lowerEndpoint != null) {
                Preconditions.checkState(lowerBoundType != null, "'lowerEndpoint' field found, but not 'lowerBoundType'");
                return RangeFactory.downTo(lowerEndpoint, lowerBoundType);
            }
            if (upperEndpoint != null) {
                Preconditions.checkState(upperBoundType != null, "'upperEndpoint' field found, but not 'upperBoundType'");
                return RangeFactory.upTo(upperEndpoint, upperBoundType);
            }
            return RangeFactory.all();
        }
        catch (IllegalStateException e) {
            return (Range)context.reportBadDefinition(this.getValueType(context), e.getMessage());
        }
    }

    private Range<?> deserializeRangeFromString(DeserializationContext context, JsonParser p) throws IOException {
        String rangeInterval = p.getText();
        if (rangeInterval.isEmpty()) {
            return null;
        }
        if (this.isValidBracketNotation(rangeInterval)) {
            BoundType lowerBoundType = rangeInterval.startsWith("[") ? BoundType.CLOSED : BoundType.OPEN;
            BoundType upperBoundType = rangeInterval.endsWith("]") ? BoundType.CLOSED : BoundType.OPEN;
            String[] parts = PATTERN_DOUBLE_DOT.split(rangeInterval = rangeInterval.substring(1, rangeInterval.length() - 1));
            if (parts.length == 2) {
                boolean isLowerInfinite = parts[0].equals("-\u221e");
                boolean isUpperInfinite = parts[1].equals("+\u221e");
                if (isLowerInfinite && isUpperInfinite) {
                    return RangeFactory.all();
                }
                if (isLowerInfinite) {
                    return RangeFactory.upTo(this.deserializeStringified(context, parts[1]), upperBoundType);
                }
                if (isUpperInfinite) {
                    return RangeFactory.downTo(this.deserializeStringified(context, parts[0]), lowerBoundType);
                }
                return RangeFactory.range(this.deserializeStringified(context, parts[0]), lowerBoundType, this.deserializeStringified(context, parts[1]), upperBoundType);
            }
        } else {
            String msg = "Invalid Range: should start with '[' or '(', end with ')' or ']'";
            return (Range)context.handleWeirdStringValue(this.handledType(), rangeInterval, msg, new Object[0]);
        }
        return (Range)context.handleWeirdStringValue(this.handledType(), rangeInterval, "Invalid bracket-notation representation (possibly missing \"..\" delimiter in your Stringified Range)", new Object[0]);
    }

    private BoundType deserializeBoundType(DeserializationContext context, JsonParser p) throws IOException {
        this.expect(context, JsonToken.VALUE_STRING, p.currentToken());
        String name = p.getText();
        if (name == null) {
            name = "";
        }
        switch (name) {
            case "OPEN": {
                return BoundType.OPEN;
            }
            case "CLOSED": {
                return BoundType.CLOSED;
            }
        }
        if (context.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS)) {
            if (name.equalsIgnoreCase("open")) {
                return BoundType.OPEN;
            }
            if (name.equalsIgnoreCase("closed")) {
                return BoundType.CLOSED;
            }
        }
        return (BoundType)((Object)context.handleWeirdStringValue(BoundType.class, name, "not a valid BoundType name (should be one of: %s)", Arrays.asList(BoundType.values())));
    }

    private Comparable<?> deserializeEndpoint(DeserializationContext context, JsonParser p) throws IOException {
        Object obj = this._endpointDeserializer.deserialize(p, context);
        if (!(obj instanceof Comparable)) {
            context.reportBadDefinition(this._rangeType, String.format("Field '%s' deserialized to a %s, which does not implement `Comparable`", p.currentName(), ClassUtil.classNameOf(obj)));
        }
        return (Comparable)obj;
    }

    private Comparable<?> deserializeStringified(DeserializationContext context, String value) throws IOException {
        Object obj = this._fromStringDeserializer.deserializeKey(value, context);
        if (!(obj instanceof Comparable)) {
            context.reportBadDefinition(this._rangeType, String.format("Stringified endpoint '%s' deserialized to a %s, which does not implement `Comparable`", value, ClassUtil.classNameOf(obj)));
        }
        return (Comparable)obj;
    }

    private void expect(DeserializationContext context, JsonToken expected, JsonToken actual) throws JsonMappingException {
        if (actual != expected) {
            context.reportInputMismatch(this, String.format("Problem deserializing %s: expecting %s, found %s", new Object[]{ClassUtil.getTypeDescription(this.getValueType()), expected, actual}), new Object[0]);
        }
    }

    private boolean isValidBracketNotation(String range) {
        char first = range.charAt(0);
        char last = range.charAt(range.length() - 1);
        return !(first != '[' && first != '(' || last != ']' && last != ')');
    }
}

