/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonObjectIterator;
import org.everit.json.schema.loader.JsonValue;

class ProjectedJsonObject
extends JsonObject {
    private final JsonObject original;
    private final Set<String> hiddenKeys;

    ProjectedJsonObject(JsonObject original, Set<String> hiddenKeys) {
        super(Collections.emptyMap());
        this.ls = original.ls;
        this.original = Objects.requireNonNull(original, "original cannot be null");
        this.hiddenKeys = Objects.requireNonNull(hiddenKeys, "hiddenKeys cannot be null");
    }

    @Override
    JsonValue childFor(String key) {
        return this.original.childFor(key);
    }

    @Override
    boolean containsKey(String key) {
        return this.isVisibleKey(key) && this.original.containsKey(key);
    }

    private boolean isVisibleKey(String key) {
        return !this.hiddenKeys.contains(key);
    }

    @Override
    void require(String key, Consumer<JsonValue> consumer) {
        this.throwExceptionIfNotVisible(key);
        this.original.require(key, consumer);
    }

    private void throwExceptionIfNotVisible(String key) {
        if (!this.isVisibleKey(key)) {
            throw this.ls.createSchemaException(String.format("required key [%s] not found", key));
        }
    }

    @Override
    JsonValue require(String key) {
        this.throwExceptionIfNotVisible(key);
        return this.original.require(key);
    }

    @Override
    <R> R requireMapping(String key, Function<JsonValue, R> fn) {
        this.throwExceptionIfNotVisible(key);
        return this.original.requireMapping(key, fn);
    }

    @Override
    void maybe(String key, Consumer<JsonValue> consumer) {
        if (this.isVisibleKey(key)) {
            this.original.maybe(key, consumer);
        }
    }

    @Override
    Optional<JsonValue> maybe(String key) {
        if (this.isVisibleKey(key)) {
            return this.original.maybe(key);
        }
        return Optional.empty();
    }

    @Override
    <R> Optional<R> maybeMapping(String key, Function<JsonValue, R> fn) {
        if (this.isVisibleKey(key)) {
            return this.original.maybeMapping(key, fn);
        }
        return Optional.empty();
    }

    @Override
    void forEach(JsonObjectIterator iterator2) {
        this.original.forEach((key, value) -> {
            if (this.isVisibleKey(key)) {
                iterator2.apply(key, value);
            }
        });
    }

    @Override
    protected Object unwrap() {
        HashMap<String, Object> storage = new HashMap<String, Object>(this.original.storage);
        this.removeHiddenKeysFrom(storage);
        return storage;
    }

    @Override
    Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.original.toMap());
        this.removeHiddenKeysFrom(map);
        return map;
    }

    private void removeHiddenKeysFrom(Map<String, Object> map) {
        this.hiddenKeys.forEach(map::remove);
    }

    @Override
    boolean isEmpty() {
        Set<String> origKeys = this.original.keySet();
        return this.original.isEmpty() || origKeys.containsAll(this.hiddenKeys) && origKeys.size() == this.hiddenKeys.size();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys2 = new HashSet<String>(this.original.keySet());
        keys2.removeAll(this.hiddenKeys);
        return keys2;
    }

    @Override
    public Object get(String name) {
        return super.get(name);
    }
}

