/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core;

import java.io.OutputStream;
import java.io.Writer;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.TreeNode;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.tree.ArrayTreeNode;
import tools.jackson.core.tree.ObjectTreeNode;

public interface ObjectWriteContext {
    public static ObjectWriteContext empty() {
        return Base.EMPTY_CONTEXT;
    }

    public FormatSchema getSchema();

    public CharacterEscapes getCharacterEscapes();

    public PrettyPrinter getPrettyPrinter();

    public boolean hasPrettyPrinter();

    public SerializableString getRootValueSeparator(SerializableString var1);

    public int getStreamWriteFeatures(int var1);

    public int getFormatWriteFeatures(int var1);

    public TokenStreamFactory tokenStreamFactory();

    default public JsonGenerator createGenerator(OutputStream out) throws JacksonException {
        return this.tokenStreamFactory().createGenerator(this, out);
    }

    default public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws JacksonException {
        return this.tokenStreamFactory().createGenerator(this, out, enc);
    }

    default public JsonGenerator createGenerator(Writer w) throws JacksonException {
        return this.tokenStreamFactory().createGenerator(this, w);
    }

    public ArrayTreeNode createArrayNode();

    public ObjectTreeNode createObjectNode();

    public void writeValue(JsonGenerator var1, Object var2) throws JacksonException;

    public void writeTree(JsonGenerator var1, TreeNode var2) throws JacksonException;

    public static class Base
    implements ObjectWriteContext {
        protected static Base EMPTY_CONTEXT = new Base();

        @Override
        public FormatSchema getSchema() {
            return null;
        }

        @Override
        public CharacterEscapes getCharacterEscapes() {
            return null;
        }

        @Override
        public PrettyPrinter getPrettyPrinter() {
            return null;
        }

        @Override
        public boolean hasPrettyPrinter() {
            return this.getPrettyPrinter() != null;
        }

        @Override
        public SerializableString getRootValueSeparator(SerializableString defaultSeparator) {
            return defaultSeparator;
        }

        @Override
        public int getStreamWriteFeatures(int defaults) {
            return defaults;
        }

        @Override
        public TokenStreamFactory tokenStreamFactory() {
            return (TokenStreamFactory)this._reportUnsupportedOperation();
        }

        @Override
        public int getFormatWriteFeatures(int defaults) {
            return defaults;
        }

        @Override
        public ObjectTreeNode createObjectNode() {
            return (ObjectTreeNode)this._reportUnsupportedOperation();
        }

        @Override
        public ArrayTreeNode createArrayNode() {
            return (ArrayTreeNode)this._reportUnsupportedOperation();
        }

        @Override
        public void writeValue(JsonGenerator g, Object value) {
            this._reportUnsupportedOperation();
        }

        @Override
        public void writeTree(JsonGenerator g, TreeNode value) {
            this._reportUnsupportedOperation();
        }

        protected <T> T _reportUnsupportedOperation() {
            throw new UnsupportedOperationException("Operation not supported by `ObjectWriteContext` of type " + this.getClass().getName());
        }
    }
}

