/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.schema.registry.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.schema.registry.client.AutocompletionAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaRegistryResourceMgr.class);
    private static final String REGISTRY_SERVICE = "registry-service";
    private static final String SERDE = "serde";
    private static final String SCHEMA_GROUP = "schema-group";
    private static final String SCHEMA_METADATA = "schema-metadata";
    private static final String SCHEMA_BRANCH = "schema-branch";
    private static final String SCHEMA_VERSION = "schema-version";
    private static final List<String> asteriskList = Collections.singletonList("*");
    private static final int LOOKUP_TIMEOUT_SEC = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSchemaRegistryResources(String serviceName, Map<String, String> configs, ResourceLookupContext context, AutocompletionAgent registryClient) throws Exception {
        String userInput = context.getUserInput();
        String resource = context.getResourceName();
        Map resourceMap = context.getResources();
        List resultList = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SchemaRegistryResourceMgr.getSchemaRegistryResources()  UserInput: \"" + userInput + "\" resource : " + resource + " resourceMap: " + resourceMap);
        }
        if (userInput != null && !userInput.isEmpty() && serviceName != null && resource != null && resourceMap != null && !resourceMap.isEmpty() && registryClient != null) {
            Callable<List> callableObj = null;
            try {
                switch (resource.trim().toLowerCase()) {
                    case "schema-group": {
                        List schemaGroupList = (List)resourceMap.get(SCHEMA_GROUP);
                        String finalSchemaGroupName = userInput;
                        callableObj = () -> registryClient.getSchemaGroupList(finalSchemaGroupName, schemaGroupList);
                        break;
                    }
                    case "schema-metadata": {
                        List schemaGroupList = (List)resourceMap.get(SCHEMA_GROUP);
                        List schemaMeatadataList = (List)resourceMap.get(SCHEMA_METADATA);
                        String finalSchemaName = userInput;
                        callableObj = () -> registryClient.getSchemaMetadataList(finalSchemaName, schemaGroupList, schemaMeatadataList);
                        break;
                    }
                    case "schema-branch": {
                        List schemaGroupList = (List)resourceMap.get(SCHEMA_GROUP);
                        List schemaMeatadataList = (List)resourceMap.get(SCHEMA_METADATA);
                        List branchList = (List)resourceMap.get(SCHEMA_BRANCH);
                        String finalBranchName = userInput;
                        callableObj = () -> registryClient.getBranchList(finalBranchName, schemaGroupList, schemaMeatadataList, branchList);
                        break;
                    }
                    case "schema-version": 
                    case "serde": 
                    case "registry-service": {
                        return asteriskList;
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Unable to get Schema Registry resources.", (Throwable)e);
                throw e;
            }
            if (callableObj != null) {
                Object object = registryClient;
                synchronized (object) {
                    resultList = (List)TimedEventUtil.timedTask(callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                }
            } else {
                LOG.error("Could not initiate at timedTask");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== SchemaRegistryResourceMgr.getSchemaRegistryResources() UserInput: " + userInput + " configs: " + configs + "Result :" + resultList);
        }
        return resultList;
    }
}

