/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.metrics;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class CountDistinctMetric
extends Metric {
    public static final String COUNT_DISTINCT = "countDist";
    public static final String APPROX_COUNT_DISTINCT = "hll";
    private String columnName;

    public CountDistinctMetric(String columnName) {
        this(columnName, false);
    }

    public CountDistinctMetric(String columnName, boolean isApproximate) {
        this.init(isApproximate ? APPROX_COUNT_DISTINCT : COUNT_DISTINCT, columnName);
    }

    public CountDistinctMetric(StreamExpression expression, StreamFactory factory) throws IOException {
        String functionName = expression.getFunctionName();
        String columnName = factory.getValueOperand(expression, 0);
        if (null == columnName) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expected %s(columnName)", expression, functionName));
        }
        this.init(functionName, columnName);
    }

    private void init(String functionName, String columnName) {
        this.columnName = columnName;
        this.outputLong = true;
        this.setFunctionName(functionName);
        this.setIdentifier(functionName, "(", columnName, ")");
    }

    @Override
    public void update(Tuple tuple) {
    }

    @Override
    public Metric newInstance() {
        return new CountDistinctMetric(this.columnName);
    }

    @Override
    public String[] getColumns() {
        return new String[]{this.columnName};
    }

    @Override
    public Number getValue() {
        return null;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpression(this.getFunctionName()).withParameter(this.columnName).withParameter(Boolean.toString(this.outputLong));
    }
}

