/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.thrift.TException;

public final class SynchronizedMetaStoreClient {
    private final IMetaStoreClient client;

    public SynchronizedMetaStoreClient(IMetaStoreClient client) {
        this.client = client;
    }

    public synchronized long openTxn(String user) throws TException {
        return this.client.openTxn(user);
    }

    public synchronized void commitTxn(long txnid) throws TException {
        this.client.commitTxn(txnid);
    }

    public synchronized void rollbackTxn(long txnid) throws TException {
        this.client.rollbackTxn(txnid);
    }

    public synchronized void heartbeat(long txnid, long lockid) throws TException {
        this.client.heartbeat(txnid, lockid);
    }

    public synchronized ValidTxnList getValidTxns(long currentTxn) throws TException {
        return this.client.getValidTxns(currentTxn);
    }

    public synchronized LockResponse lock(LockRequest request) throws TException {
        return this.client.lock(request);
    }

    public synchronized Partition add_partition(Partition partition) throws TException {
        return this.client.add_partition(partition);
    }

    public synchronized void alter_partition(String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws TException {
        this.client.alter_partition(dbName, tblName, newPart, environmentContext);
    }

    public synchronized LockResponse checkLock(long lockid) throws TException {
        return this.client.checkLock(lockid);
    }

    public synchronized void unlock(long lockid) throws TException {
        this.client.unlock(lockid);
    }

    public synchronized ShowLocksResponse showLocks(ShowLocksRequest showLocksRequest) throws TException {
        return this.client.showLocks(showLocksRequest);
    }

    public synchronized Partition getPartitionWithAuthInfo(String dbName, String tableName, List<String> pvals, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.client.getPartitionWithAuthInfo(dbName, tableName, pvals, userName, groupNames);
    }

    public synchronized Partition appendPartition(String db_name, String table_name, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.client.appendPartition(db_name, table_name, part_vals);
    }

    public synchronized FireEventResponse fireListenerEvent(FireEventRequest rqst) throws TException {
        return this.client.fireListenerEvent(rqst);
    }

    public synchronized void close() {
        this.client.close();
    }

    public boolean isSameConfObj(Configuration c) {
        return this.client.isSameConfObj(c);
    }

    public boolean isCompatibleWith(Configuration c) {
        return this.client.isCompatibleWith(c);
    }
}

