/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.ArrayValueBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;

public class BufferedArrayValueBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BufferedArrayValueBuilder.class);
    private int bufferSize;
    private BlockBuilder valueBuilder;

    public static BufferedArrayValueBuilder createBuffered(ArrayType arrayType) {
        return new BufferedArrayValueBuilder(arrayType, 1024);
    }

    BufferedArrayValueBuilder(ArrayType arrayType, int bufferSize) {
        this.bufferSize = bufferSize;
        this.valueBuilder = arrayType.getElementType().createBlockBuilder(null, bufferSize);
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.valueBuilder.getRetainedSizeInBytes();
    }

    public <E extends Throwable> Block build(int entryCount, ArrayValueBuilder<E> builder) throws E {
        if (this.valueBuilder.getPositionCount() + entryCount > this.bufferSize) {
            if (this.bufferSize < entryCount) {
                this.bufferSize = entryCount;
            }
            this.valueBuilder = this.valueBuilder.newBlockBuilderLike(this.bufferSize, null);
        }
        int startSize = this.valueBuilder.getPositionCount();
        builder.build(this.valueBuilder);
        int endSize = this.valueBuilder.getPositionCount();
        return this.valueBuilder.build().getRegion(startSize, endSize - startSize);
    }
}

