/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapHashTables;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.MapType;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class MapBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(MapBlockBuilder.class);
    private final MapType mapType;
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private int positionCount;
    private int[] offsets;
    private boolean[] mapIsNull;
    private boolean hasNullValue;
    private final BlockBuilder keyBlockBuilder;
    private final BlockBuilder valueBlockBuilder;
    private boolean currentEntryOpened;
    private MapHashTables.HashBuildMode hashBuildMode = MapHashTables.HashBuildMode.DUPLICATE_NOT_CHECKED;

    public MapBlockBuilder(MapType mapType, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(mapType, blockBuilderStatus, mapType.getKeyType().createBlockBuilder(blockBuilderStatus, expectedEntries), mapType.getValueType().createBlockBuilder(blockBuilderStatus, expectedEntries), new int[expectedEntries + 1], new boolean[expectedEntries]);
    }

    private MapBlockBuilder(MapType mapType, @Nullable BlockBuilderStatus blockBuilderStatus, BlockBuilder keyBlockBuilder, BlockBuilder valueBlockBuilder, int[] offsets, boolean[] mapIsNull) {
        this.mapType = Objects.requireNonNull(mapType, "mapType is null");
        this.blockBuilderStatus = blockBuilderStatus;
        this.positionCount = 0;
        this.offsets = Objects.requireNonNull(offsets, "offsets is null");
        this.mapIsNull = Objects.requireNonNull(mapIsNull, "mapIsNull is null");
        this.keyBlockBuilder = Objects.requireNonNull(keyBlockBuilder, "keyBlockBuilder is null");
        this.valueBlockBuilder = Objects.requireNonNull(valueBlockBuilder, "valueBlockBuilder is null");
    }

    public MapBlockBuilder strict() {
        this.hashBuildMode = MapHashTables.HashBuildMode.STRICT_EQUALS;
        return this;
    }

    public MapBlockBuilder strictNotDistinctFrom() {
        this.hashBuildMode = MapHashTables.HashBuildMode.STRICT_NOT_DISTINCT_FROM;
        return this;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.keyBlockBuilder.getSizeInBytes() + this.valueBlockBuilder.getSizeInBytes() + 5L * (long)this.positionCount + 8L * (long)this.keyBlockBuilder.getPositionCount();
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes() + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((boolean[])this.mapIsNull);
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    public <E extends Throwable> void buildEntry(MapValueBuilder<E> builder) throws E {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        builder.build(this.keyBlockBuilder, this.valueBlockBuilder);
        this.entryAdded(false);
        this.currentEntryOpened = false;
    }

    @Override
    public void append(ValueBlock block, int position) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        MapBlock mapBlock = (MapBlock)block;
        if (block.isNull(position)) {
            this.entryAdded(true);
            return;
        }
        int offsetBase = mapBlock.getOffsetBase();
        int[] offsets = mapBlock.getOffsets();
        int startOffset = offsets[offsetBase + position];
        int length = offsets[offsetBase + position + 1] - startOffset;
        BlockUtil.appendRawBlockRange(mapBlock.getRawKeyBlock(), startOffset, length, this.keyBlockBuilder);
        BlockUtil.appendRawBlockRange(mapBlock.getRawValueBlock(), startOffset, length, this.valueBlockBuilder);
        this.entryAdded(false);
    }

    @Override
    public void appendRange(ValueBlock block, int offset, int length) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        for (int i = 0; i < length; ++i) {
            this.append(block, offset + i);
        }
    }

    @Override
    public void appendRepeated(ValueBlock block, int position, int count) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        for (int i = 0; i < count; ++i) {
            this.append(block, position);
        }
    }

    @Override
    public void appendPositions(ValueBlock block, int[] positions, int offset, int length) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        for (int i = 0; i < length; ++i) {
            this.append(block, positions[offset + i]);
        }
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    @Override
    public void resetTo(int position) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        Objects.checkIndex(position, this.positionCount + 1);
        this.positionCount = position;
        this.keyBlockBuilder.resetTo(this.offsets[this.positionCount]);
        this.valueBlockBuilder.resetTo(this.offsets[this.positionCount]);
    }

    private void entryAdded(boolean isNull) {
        if (this.keyBlockBuilder.getPositionCount() != this.valueBlockBuilder.getPositionCount()) {
            throw new IllegalStateException(String.format("keyBlock and valueBlock has different size: %s %s", this.keyBlockBuilder.getPositionCount(), this.valueBlockBuilder.getPositionCount()));
        }
        if (this.mapIsNull.length <= this.positionCount) {
            int newSize = BlockUtil.calculateNewArraySize(this.mapIsNull.length);
            this.mapIsNull = Arrays.copyOf(this.mapIsNull, newSize);
            this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        }
        this.offsets[this.positionCount + 1] = this.keyBlockBuilder.getPositionCount();
        this.mapIsNull[this.positionCount] = isNull;
        this.hasNullValue |= isNull;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
            this.blockBuilderStatus.addBytes((this.offsets[this.positionCount] - this.offsets[this.positionCount - 1]) * 2 * 4);
        }
    }

    @Override
    public Block build() {
        if (this.positionCount > 1 && this.hasNullValue) {
            boolean hasNonNull = false;
            for (int i = 0; i < this.positionCount; ++i) {
                hasNonNull |= !this.mapIsNull[i];
            }
            if (!hasNonNull) {
                Block emptyKeyBlock = this.mapType.getKeyType().createBlockBuilder(null, 0).build();
                Block emptyValueBlock = this.mapType.getValueType().createBlockBuilder(null, 0).build();
                int[] emptyOffsets = new int[]{0, 0};
                boolean[] nulls = new boolean[]{true};
                return RunLengthEncodedBlock.create(MapBlock.createMapBlockInternal(this.mapType, 0, 1, Optional.of(nulls), emptyOffsets, emptyKeyBlock, emptyValueBlock, MapHashTables.create(this.hashBuildMode, this.mapType, 0, emptyKeyBlock, emptyOffsets, nulls)), this.positionCount);
            }
        }
        return this.buildValueBlock();
    }

    @Override
    public MapBlock buildValueBlock() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        Block keyBlock = this.keyBlockBuilder.build();
        Block valueBlock = this.valueBlockBuilder.build();
        MapHashTables hashTables = MapHashTables.create(this.hashBuildMode, this.mapType, this.positionCount, keyBlock, this.offsets, this.mapIsNull);
        return MapBlock.createMapBlockInternal(this.mapType, 0, this.positionCount, this.hasNullValue ? Optional.of(this.mapIsNull) : Optional.empty(), this.offsets, keyBlock, valueBlock, hashTables);
    }

    public String toString() {
        return "MapBlockBuilder{positionCount=" + this.getPositionCount() + "}";
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        return new MapBlockBuilder(this.mapType, blockBuilderStatus, this.keyBlockBuilder.newBlockBuilderLike(blockBuilderStatus), this.valueBlockBuilder.newBlockBuilderLike(blockBuilderStatus), new int[expectedEntries + 1], new boolean[expectedEntries]);
    }
}

