/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.trino.spi.type.DecimalParseResult;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;

public final class SqlDecimal {
    private final BigInteger unscaledValue;
    private final int precision;
    private final int scale;

    public SqlDecimal(BigInteger unscaledValue, int precision, int scale) {
        this.unscaledValue = unscaledValue;
        this.precision = precision;
        this.scale = scale;
    }

    public static SqlDecimal decimal(String value, DecimalType type) {
        DecimalParseResult parseResult = Decimals.parse(value);
        BigInteger unscaledValue = parseResult.getType().isShort() ? BigInteger.valueOf((Long)parseResult.getObject()) : ((Int128)parseResult.getObject()).toBigInteger();
        return new SqlDecimal(unscaledValue, type.getPrecision(), type.getScale());
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public static SqlDecimal of(long unscaledValue, int precision, int scale) {
        return new SqlDecimal(BigInteger.valueOf(unscaledValue), precision, scale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlDecimal that = (SqlDecimal)o;
        return this.precision == that.precision && this.scale == that.scale && this.unscaledValue.equals(that.unscaledValue);
    }

    public int hashCode() {
        return Objects.hash(this.unscaledValue, this.precision, this.scale);
    }

    @JsonValue
    public String toString() {
        return Decimals.toString(this.unscaledValue, this.scale);
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.unscaledValue, this.scale, new MathContext(this.precision));
    }

    public BigInteger getUnscaledValue() {
        return this.unscaledValue;
    }
}

