/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.trino.spi.type.Timestamps;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

public final class SqlTimestamp {
    private final int precision;
    private final long epochMicros;
    private final int picosOfMicros;

    public static SqlTimestamp fromMillis(int precision, long millis) {
        return SqlTimestamp.newInstanceWithRounding(precision, millis * 1000L, 0);
    }

    public static SqlTimestamp fromSeconds(int precision, long seconds, long nanosOfSecond) {
        long fractionInPicos = nanosOfSecond * 1000L;
        long epochMicros = Math.addExact(Math.multiplyExact(seconds, 1000000), fractionInPicos / 1000000L);
        int picosOfMicro = (int)(fractionInPicos % 1000000L);
        return SqlTimestamp.newInstanceWithRounding(precision, epochMicros, picosOfMicro);
    }

    public static SqlTimestamp newInstance(int precision, long epochMicros, int picosOfMicro) {
        if (precision < 0 || precision > 12) {
            throw new IllegalArgumentException("Invalid precision: " + precision);
        }
        if (precision <= 6) {
            if (picosOfMicro != 0) {
                throw new IllegalArgumentException(String.format("Expected picosOfMicro to be 0 for precision %s: %s", precision, picosOfMicro));
            }
            if (Timestamps.round(epochMicros, 6 - precision) != epochMicros) {
                throw new IllegalArgumentException(String.format("Expected 0s for digits beyond precision %s: epochMicros = %s", precision, epochMicros));
            }
        } else if (Timestamps.round(picosOfMicro, 12 - precision) != (long)picosOfMicro) {
            throw new IllegalArgumentException(String.format("Expected 0s for digits beyond precision %s: picosOfMicro = %s", precision, picosOfMicro));
        }
        if (picosOfMicro < 0 || picosOfMicro > 1000000) {
            throw new IllegalArgumentException("picosOfMicro is out of range: " + picosOfMicro);
        }
        return new SqlTimestamp(precision, epochMicros, picosOfMicro);
    }

    private static SqlTimestamp newInstanceWithRounding(int precision, long epochMicros, int picosOfMicro) {
        if (precision < 6) {
            epochMicros = Timestamps.round(epochMicros, 6 - precision);
            picosOfMicro = 0;
        } else if (precision == 6) {
            if (Timestamps.round(picosOfMicro, 6) == 1000000L) {
                ++epochMicros;
            }
            picosOfMicro = 0;
        } else {
            picosOfMicro = (int)Timestamps.round(picosOfMicro, 12 - precision);
        }
        return new SqlTimestamp(precision, epochMicros, picosOfMicro);
    }

    private SqlTimestamp(int precision, long epochMicros, int picosOfMicro) {
        this.precision = precision;
        this.epochMicros = epochMicros;
        this.picosOfMicros = picosOfMicro;
    }

    public int getPrecision() {
        return this.precision;
    }

    public long getMillis() {
        return Timestamps.roundDiv(this.epochMicros, 1000L);
    }

    public long getEpochMicros() {
        return this.epochMicros;
    }

    public int getPicosOfMicros() {
        return this.picosOfMicros;
    }

    public SqlTimestamp roundTo(int precision) {
        return SqlTimestamp.newInstanceWithRounding(precision, this.epochMicros, this.picosOfMicros);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTimestamp that = (SqlTimestamp)o;
        return this.epochMicros == that.epochMicros && this.picosOfMicros == that.picosOfMicros && this.precision == that.precision;
    }

    public int hashCode() {
        return Objects.hash(this.epochMicros, this.picosOfMicros, this.precision);
    }

    @JsonValue
    public String toString() {
        return Timestamps.formatTimestamp(this.precision, this.epochMicros, this.picosOfMicros);
    }

    public LocalDateTime toLocalDateTime() {
        long epochSecond = Math.floorDiv(this.epochMicros, 1000000);
        int microOfSecond = Math.floorMod(this.epochMicros, 1000000);
        int nanoOfSecond = microOfSecond * 1000 + Timestamps.roundDiv(this.picosOfMicros, 1000L);
        return LocalDateTime.ofEpochSecond(epochSecond, nanoOfSecond, ZoneOffset.UTC);
    }
}

