/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
public class TableState {
    private final TableName tableName;
    private final State state;

    public boolean isEnabled() {
        return this.isInStates(State.ENABLED);
    }

    public boolean isEnabling() {
        return this.isInStates(State.ENABLING);
    }

    public boolean isEnabledOrEnabling() {
        return this.isInStates(State.ENABLED, State.ENABLING);
    }

    public boolean isDisabled() {
        return this.isInStates(State.DISABLED);
    }

    public boolean isDisabling() {
        return this.isInStates(State.DISABLING);
    }

    public boolean isDisabledOrDisabling() {
        return this.isInStates(State.DISABLED, State.DISABLING);
    }

    public TableState(TableName tableName, State state) {
        this.tableName = tableName;
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public boolean inStates(State state) {
        return this.state.equals((Object)state);
    }

    public boolean inStates(State ... states) {
        for (State s : states) {
            if (!s.equals((Object)this.state)) continue;
            return true;
        }
        return false;
    }

    public HBaseProtos.TableState convert() {
        return HBaseProtos.TableState.newBuilder().setState(this.state.convert()).build();
    }

    public static TableState convert(TableName tableName, HBaseProtos.TableState tableState) {
        State state = State.convert(tableState.getState());
        return new TableState(tableName, state);
    }

    public static TableState parseFrom(TableName tableName, byte[] bytes) throws DeserializationException {
        try {
            return TableState.convert(tableName, HBaseProtos.TableState.parseFrom((byte[])bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    public boolean isInStates(State ... target) {
        for (State tableState : target) {
            if (!this.state.equals((Object)tableState)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableState)) {
            return false;
        }
        TableState that = (TableState)o;
        if (this.state != that.state) {
            return false;
        }
        return !(this.tableName != null ? !this.tableName.equals((Object)that.tableName) : that.tableName != null);
    }

    public int hashCode() {
        int result = this.tableName != null ? this.tableName.hashCode() : 0;
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "tableName=" + this.tableName + ", state=" + (Object)((Object)this.state);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static enum State {
        ENABLED,
        DISABLED,
        DISABLING,
        ENABLING;


        public static State convert(HBaseProtos.TableState.State state) {
            State ret;
            switch (state) {
                case ENABLED: {
                    ret = ENABLED;
                    break;
                }
                case DISABLED: {
                    ret = DISABLED;
                    break;
                }
                case DISABLING: {
                    ret = DISABLING;
                    break;
                }
                case ENABLING: {
                    ret = ENABLING;
                    break;
                }
                default: {
                    throw new IllegalStateException(state.toString());
                }
            }
            return ret;
        }

        public HBaseProtos.TableState.State convert() {
            HBaseProtos.TableState.State state;
            switch (this) {
                case ENABLED: {
                    state = HBaseProtos.TableState.State.ENABLED;
                    break;
                }
                case DISABLED: {
                    state = HBaseProtos.TableState.State.DISABLED;
                    break;
                }
                case DISABLING: {
                    state = HBaseProtos.TableState.State.DISABLING;
                    break;
                }
                case ENABLING: {
                    state = HBaseProtos.TableState.State.ENABLING;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
            return state;
        }
    }
}

