/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.HostAndPort;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLHandshakeException;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.ha.GrpcOMFailoverProxyProvider;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.om.protocolPB.grpc.ClientAddressClientInterceptor;
import org.apache.hadoop.ozone.om.protocolPB.grpc.GrpcClientConstants;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerServiceGrpc;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcOmTransport
implements OmTransport {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcOmTransport.class);
    private static final String CLIENT_NAME = "GrpcOmTransport";
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private static List<X509Certificate> caCerts = null;
    private OzoneManagerServiceGrpc.OzoneManagerServiceBlockingStub client;
    private Map<String, OzoneManagerServiceGrpc.OzoneManagerServiceBlockingStub> clients;
    private Map<String, ManagedChannel> channels = new HashMap<String, ManagedChannel>();
    private int lastVisited = -1;
    private ConfigurationSource conf;
    private AtomicReference<String> host;
    private AtomicInteger syncFailoverCount;
    private final int maxSize;
    private SecurityConfig secConfig;
    private List<String> oms;
    private RetryPolicy retryPolicy;
    private int failoverCount = 0;
    private GrpcOMFailoverProxyProvider<OzoneManagerProtocolPB> omFailoverProxyProvider;

    public static void setCaCerts(List<X509Certificate> x509Certificates) {
        caCerts = x509Certificates;
    }

    public GrpcOmTransport(ConfigurationSource conf, UserGroupInformation ugi, String omServiceId) throws IOException {
        this.clients = new HashMap<String, OzoneManagerServiceGrpc.OzoneManagerServiceBlockingStub>();
        this.conf = conf;
        this.host = new AtomicReference();
        this.failoverCount = 0;
        this.syncFailoverCount = new AtomicInteger();
        this.secConfig = new SecurityConfig(conf);
        this.maxSize = conf.getInt("ozone.om.grpc.maximum.response.length", 0x8000000);
        this.omFailoverProxyProvider = new GrpcOMFailoverProxyProvider<OzoneManagerProtocolPB>(conf, omServiceId, OzoneManagerProtocolPB.class);
        this.start();
    }

    public void start() throws IOException {
        this.host.set(this.omFailoverProxyProvider.getGrpcProxyAddress(this.omFailoverProxyProvider.getCurrentProxyOMNodeId()));
        if (!this.isRunning.compareAndSet(false, true)) {
            LOG.info("Ignore. already started.");
            return;
        }
        List<String> nodes = this.omFailoverProxyProvider.getGrpcOmNodeIDList();
        for (String nodeId : nodes) {
            String hostaddr = this.omFailoverProxyProvider.getGrpcProxyAddress(nodeId);
            HostAndPort hp = HostAndPort.fromString((String)hostaddr);
            NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)hp.getHost(), (int)hp.getPort()).usePlaintext().maxInboundMessageSize(this.maxSize);
            if (this.secConfig.isSecurityEnabled() && this.secConfig.isGrpcTlsEnabled()) {
                try {
                    SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
                    if (caCerts != null) {
                        sslContextBuilder.trustManager(caCerts);
                    } else {
                        LOG.error("x509Certificates empty");
                    }
                    channelBuilder.useTransportSecurity().sslContext(sslContextBuilder.build());
                }
                catch (Exception ex) {
                    LOG.error("cannot establish TLS for grpc om transport client");
                }
            } else {
                channelBuilder.usePlaintext();
            }
            this.channels.put(hostaddr, ((NettyChannelBuilder)channelBuilder.intercept(new ClientInterceptor[]{new ClientAddressClientInterceptor()})).build());
            this.clients.put(hostaddr, OzoneManagerServiceGrpc.newBlockingStub((Channel)((Channel)this.channels.get(hostaddr))));
        }
        int maxFailovers = this.conf.getInt("ozone.client.failover.max.attempts", 500);
        this.retryPolicy = this.omFailoverProxyProvider.getRetryPolicy(maxFailovers);
        LOG.info("{}: started", (Object)CLIENT_NAME);
    }

    @Override
    public OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest payload) throws IOException {
        AtomicReference resp = new AtomicReference();
        boolean tryOtherHost = true;
        int expectedFailoverCount = 0;
        OMException.ResultCodes resultCode = OMException.ResultCodes.INTERNAL_ERROR;
        while (tryOtherHost) {
            tryOtherHost = false;
            expectedFailoverCount = this.syncFailoverCount.get();
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                Context.current().withValue(GrpcClientConstants.CLIENT_IP_ADDRESS_CTX_KEY, (Object)inetAddress.getHostAddress()).withValue(GrpcClientConstants.CLIENT_HOSTNAME_CTX_KEY, (Object)inetAddress.getHostName()).run(() -> resp.set(this.clients.get(this.host.get()).submitRequest(payload)));
            }
            catch (StatusRuntimeException e) {
                Exception exp;
                LOG.error("Failed to submit request", (Throwable)e);
                if (e.getStatus().getCode() == Status.Code.UNAVAILABLE) {
                    if (e.getCause() != null && e.getCause() instanceof SSLHandshakeException) {
                        throw new OMException(OMException.ResultCodes.SSL_CONNECTION_FAILURE);
                    }
                    resultCode = OMException.ResultCodes.TIMEOUT;
                }
                if (tryOtherHost = this.shouldRetry(this.unwrapException(exp = new Exception(e)), expectedFailoverCount)) continue;
                throw new OMException(resultCode);
            }
        }
        return (OzoneManagerProtocolProtos.OMResponse)resp.get();
    }

    private Exception unwrapException(Exception ex) {
        Throwable grpcException = null;
        try {
            StatusRuntimeException srexp = (StatusRuntimeException)ex.getCause();
            Status status = srexp.getStatus();
            LOG.debug("GRPC exception wrapped: {}", (Object)status.getDescription());
            if (status.getCode() == Status.Code.INTERNAL) {
                Class<?> realClass = Class.forName(status.getDescription().substring(0, status.getDescription().indexOf(":")));
                Class<Exception> cls = realClass.asSubclass(Exception.class);
                Constructor<Exception> cn = cls.getConstructor(String.class);
                cn.setAccessible(true);
                grpcException = cn.newInstance(status.getDescription());
                RemoteException remote = null;
                try {
                    String cause = status.getDescription();
                    cause = cause.substring(cause.indexOf(":") + 2);
                    remote = new RemoteException(cause.substring(0, cause.indexOf(":")), cause.substring(cause.indexOf(":") + 1));
                    grpcException.initCause((Throwable)remote);
                }
                catch (Exception e) {
                    LOG.error("cannot get cause for remote exception");
                }
            } else {
                grpcException = status.getCode() == Status.Code.RESOURCE_EXHAUSTED || status.getCode() == Status.Code.DATA_LOSS ? srexp : ex;
            }
        }
        catch (Exception e) {
            grpcException = new IOException(e);
            LOG.error("error unwrapping exception from OMResponse {}");
        }
        return grpcException;
    }

    private boolean shouldRetry(Exception ex, int expectedFailoverCount) {
        boolean retry;
        block8: {
            retry = false;
            RetryPolicy.RetryAction action = null;
            try {
                action = this.retryPolicy.shouldRetry(ex, 0, this.failoverCount++, true);
                LOG.debug("grpc failover retry action {}", (Object)action.action);
                if (action.action == RetryPolicy.RetryAction.RetryDecision.FAIL) {
                    retry = false;
                    LOG.error("Retry request failed. Action : {}, {}", (Object)action.action, (Object)ex.toString());
                    break block8;
                }
                if (action.action != RetryPolicy.RetryAction.RetryDecision.RETRY && action.action != RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY) break block8;
                if (action.delayMillis > 0L) {
                    try {
                        Thread.sleep(action.delayMillis);
                    }
                    catch (Exception e) {
                        LOG.error("Error trying sleep thread for {}", (Object)action.delayMillis);
                    }
                }
                if (this.syncFailoverCount.get() == expectedFailoverCount) {
                    this.omFailoverProxyProvider.performFailover(null);
                    this.syncFailoverCount.getAndIncrement();
                } else {
                    LOG.warn("A failover has occurred since the start of current thread retry, NOT failover using current proxy");
                }
                this.host.set(this.omFailoverProxyProvider.getGrpcProxyAddress(this.omFailoverProxyProvider.getCurrentProxyOMNodeId()));
                retry = true;
            }
            catch (Exception e) {
                LOG.error("Failed failover exception {}", (Throwable)e);
            }
        }
        return retry;
    }

    @Override
    public Text getDelegationTokenService() {
        return new Text();
    }

    public void shutdown() {
        for (Map.Entry<String, ManagedChannel> entry : this.channels.entrySet()) {
            ManagedChannel channel = entry.getValue();
            channel.shutdown();
            try {
                channel.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("failed to shutdown OzoneManagerServiceGrpc channel {} : {}", (Object)entry.getKey(), (Object)e);
            }
        }
        LOG.info("{}: stopped", (Object)CLIENT_NAME);
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    @VisibleForTesting
    public void startClient(ManagedChannel testChannel) throws IOException {
        List<String> nodes = this.omFailoverProxyProvider.getGrpcOmNodeIDList();
        for (String nodeId : nodes) {
            String hostaddr = this.omFailoverProxyProvider.getGrpcProxyAddress(nodeId);
            this.clients.put(hostaddr, OzoneManagerServiceGrpc.newBlockingStub((Channel)testChannel));
        }
        LOG.info("{}: started", (Object)CLIENT_NAME);
    }

    @ConfigGroup(prefix="ozone.om.grpc")
    public static final class GrpcOmTransportConfig {
        @Config(key="port", defaultValue="8981", description="Port used for the GrpcOmTransport OzoneManagerServiceGrpc server", tags={ConfigTag.MANAGEMENT})
        private int port;

        public int getPort() {
            return this.port;
        }

        public GrpcOmTransportConfig setPort(int portParam) {
            this.port = portParam;
            return this;
        }
    }
}

