/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository;

import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.type.AtlasStructType;
import org.apache.commons.configuration.Configuration;

public final class Constants {
    public static final String INTERNAL_PROPERTY_KEY_PREFIX = "__";
    public static final String RELATIONSHIP_PROPERTY_KEY_PREFIX = "_r";
    public static final String GUID_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__guid");
    public static final String RELATIONSHIP_GUID_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)("_r" + GUID_PROPERTY_KEY));
    public static final String HISTORICAL_GUID_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__historicalGuids");
    public static final String FREETEXT_REQUEST_HANDLER = "/freetext";
    public static final String TERMS_REQUEST_HANDLER = "/terms";
    public static final String ENTITY_TYPE_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__typeName");
    public static final String RELATIONSHIP_TYPE_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)("_r" + ENTITY_TYPE_PROPERTY_KEY));
    public static final String TYPE_NAME_INTERNAL = "__internal";
    public static final String ASSET_ENTITY_TYPE = "Asset";
    public static final String OWNER_ATTRIBUTE = "owner";
    public static final String SUPER_TYPES_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__superTypeNames");
    public static final String ENTITY_TEXT_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"entityText");
    public static final String TYPE_CATEGORY_PROPERTY_KEY = Constants.getEncodedTypePropertyKey("__type.category");
    public static final String VERTEX_TYPE_PROPERTY_KEY = Constants.getEncodedTypePropertyKey("__type");
    public static final String TYPENAME_PROPERTY_KEY = Constants.getEncodedTypePropertyKey("__type.name");
    public static final String TYPEDESCRIPTION_PROPERTY_KEY = Constants.getEncodedTypePropertyKey("__type.description");
    public static final String TYPEVERSION_PROPERTY_KEY = Constants.getEncodedTypePropertyKey("__type.version");
    public static final String TYPEOPTIONS_PROPERTY_KEY = Constants.getEncodedTypePropertyKey("__type.options");
    public static final String TYPESERVICETYPE_PROPERTY_KEY = Constants.getEncodedTypePropertyKey("__type.servicetype");
    public static final String RELATIONSHIPTYPE_END1_KEY = "endDef1";
    public static final String RELATIONSHIPTYPE_END2_KEY = "endDef2";
    public static final String RELATIONSHIPTYPE_CATEGORY_KEY = "relationshipCategory";
    public static final String RELATIONSHIPTYPE_LABEL_KEY = "relationshipLabel";
    public static final String RELATIONSHIPTYPE_TAG_PROPAGATION_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"tagPropagation");
    public static final String RELATIONSHIPTYPE_BLOCKED_PROPAGATED_CLASSIFICATIONS_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"blockedPropagatedClassifications");
    public static final String TRAIT_NAMES_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__traitNames");
    public static final String PROPAGATED_TRAIT_NAMES_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__propagatedTraitNames");
    public static final String VERSION_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__version");
    public static final String STATE_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__state");
    public static final String CREATED_BY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__createdBy");
    public static final String MODIFIED_BY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__modifiedBy");
    public static final String CLASSIFICATION_TEXT_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__classificationsText");
    public static final String CLASSIFICATION_NAMES_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__classificationNames");
    public static final String PROPAGATED_CLASSIFICATION_NAMES_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__propagatedClassificationNames");
    public static final String CUSTOM_ATTRIBUTES_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__customAttributes");
    public static final String LABELS_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__labels");
    public static final String EDGE_PENDING_TASKS_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"_r__pendingTasks");
    public static final String PATCH_ID_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__patch.id");
    public static final String PATCH_DESCRIPTION_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__patch.description");
    public static final String PATCH_TYPE_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__patch.type");
    public static final String PATCH_ACTION_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__patch.action");
    public static final String PATCH_STATE_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__patch.state");
    public static final String HOME_ID_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__homeId");
    public static final String IS_PROXY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__isProxy");
    public static final String PROVENANCE_TYPE_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__provenanceType");
    public static final String TIMESTAMP_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__timestamp");
    public static final String ENTITY_DELETED_TIMESTAMP_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__entityDeletedTimestamp");
    public static final String MODIFICATION_TIMESTAMP_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__modificationTimestamp");
    public static final String IS_INCOMPLETE_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__isIncomplete");
    public static final String BACKING_INDEX = "search";
    public static final String VERTEX_INDEX = "vertex_index";
    public static final String EDGE_INDEX = "edge_index";
    public static final String FULLTEXT_INDEX = "fulltext_index";
    public static final String QUALIFIED_NAME = "Referenceable.qualifiedName";
    public static final String TYPE_NAME_PROPERTY_KEY = "__typeName";
    public static final String INDEX_SEARCH_MAX_RESULT_SET_SIZE = "atlas.graph.index.search.max-result-set-size";
    public static final String INDEX_SEARCH_TYPES_MAX_QUERY_STR_LENGTH = "atlas.graph.index.search.types.max-query-str-length";
    public static final String INDEX_SEARCH_TAGS_MAX_QUERY_STR_LENGTH = "atlas.graph.index.search.tags.max-query-str-length";
    public static final String INDEX_SEARCH_VERTEX_PREFIX_PROPERTY = "atlas.graph.index.search.vertex.prefix";
    public static final String INDEX_SEARCH_VERTEX_PREFIX_DEFAULT = "$v$";
    public static final String MAX_FULLTEXT_QUERY_STR_LENGTH = "atlas.graph.fulltext-max-query-str-length";
    public static final String MAX_DSL_QUERY_STR_LENGTH = "atlas.graph.dsl-max-query-str-length";
    public static final String ATTRIBUTE_NAME_GUID = "guid";
    public static final String ATTRIBUTE_NAME_TYPENAME = "typeName";
    public static final String ATTRIBUTE_NAME_SUPERTYPENAMES = "superTypeNames";
    public static final String ATTRIBUTE_NAME_STATE = "state";
    public static final String ATTRIBUTE_NAME_VERSION = "version";
    public static final String TEMP_STRUCT_NAME_PREFIX = "__tempQueryResultStruct";
    public static final String CLASSIFICATION_ENTITY_GUID = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__entityGuid");
    public static final String CLASSIFICATION_ENTITY_STATUS = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__entityStatus");
    public static final String CLASSIFICATION_VALIDITY_PERIODS_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__validityPeriods");
    public static final String CLASSIFICATION_VERTEX_PROPAGATE_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__propagate");
    public static final String CLASSIFICATION_VERTEX_REMOVE_PROPAGATIONS_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__removePropagations");
    public static final String CLASSIFICATION_VERTEX_NAME_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__typeName");
    public static final String CLASSIFICATION_EDGE_NAME_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__name");
    public static final String CLASSIFICATION_EDGE_IS_PROPAGATED_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__isPropagated");
    public static final String CLASSIFICATION_EDGE_STATE_PROPERTY_KEY = STATE_PROPERTY_KEY;
    public static final String CLASSIFICATION_LABEL = "classifiedAs";
    public static final String CLASSIFICATION_NAME_DELIMITER = "|";
    public static final String LABEL_NAME_DELIMITER = "|";
    public static final String TERM_ASSIGNMENT_LABEL = "r:AtlasGlossarySemanticAssignment";
    public static final String ATTRIBUTE_INDEX_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__index");
    public static final String ATTRIBUTE_KEY_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__key");
    public static final String ATTRIBUTE_VALUE_DELIMITER = ",";
    public static final String VERTEX_ID_IN_IMPORT_KEY = "__vIdInImport";
    public static final String EDGE_ID_IN_IMPORT_KEY = "__eIdInImport";
    public static final String ATTR_NAME_REFERENCEABLE = "Referenceable.";
    public static final String ATTR_NAME_REPLICATED_TO = "replicatedTo";
    public static final String ATTR_NAME_REPLICATED_FROM = "replicatedFrom";
    public static final Integer INCOMPLETE_ENTITY_VALUE = 1;
    public static final String TYPEDEF_PATCH_ADD_MANDATORY_ATTRIBUTE = "ADD_MANDATORY_ATTRIBUTE";
    public static final String TASK_PREFIX = "__task_";
    public static final String TASK_TYPE_PROPERTY_KEY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_v_type");
    public static final String TASK_TYPE_NAME = "__AtlasTaskDef";
    public static final String TASK_GUID = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_guid");
    public static final String TASK_TYPE = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_type");
    public static final String TASK_CREATED_TIME = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_timestamp");
    public static final String TASK_UPDATED_TIME = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_modificationTimestamp");
    public static final String TASK_CREATED_BY = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_createdBy");
    public static final String TASK_STATUS = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_status");
    public static final String TASK_ATTEMPT_COUNT = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_attemptCount");
    public static final String TASK_PARAMETERS = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_parameters");
    public static final String TASK_ERROR_MESSAGE = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_errorMessage");
    public static final String TASK_START_TIME = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_startTime");
    public static final String TASK_END_TIME = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__task_endTime");
    public static final String INDEX_RECOVERY_PREFIX = "__idxRecovery_";
    public static final String PROPERTY_KEY_INDEX_RECOVERY_NAME = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__idxRecovery_name");
    public static final String PROPERTY_KEY_INDEX_RECOVERY_START_TIME = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__idxRecovery_startTime");
    public static final String PROPERTY_KEY_INDEX_RECOVERY_PREV_TIME = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__idxRecovery_prevTime");
    public static final String PROPERTY_KEY_INDEX_RECOVERY_CUSTOM_TIME = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__idxRecovery_customTime");
    public static final String AUDIT_REDUCTION_PREFIX = "__auditReduction_";
    public static final String PROPERTY_KEY_AUDIT_REDUCTION_NAME = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__auditReduction_name");
    public static final String PROPERTY_KEY_GUIDS_TO_AGEOUT_BY_DEFAULT = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__auditReduction_default");
    public static final String PROPERTY_KEY_GUIDS_TO_AGEOUT_BY_CUSTOM = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__auditReduction_custom");
    public static final String PROPERTY_KEY_GUIDS_TO_SWEEPOUT = AtlasStructType.AtlasAttribute.encodePropertyKey((String)"__auditReduction_sweepout");
    public static final String SQOOP_SOURCE = "sqoop";
    public static final String FALCON_SOURCE = "falcon";
    public static final String HBASE_SOURCE = "hbase";
    public static final String HS2_SOURCE = "hive_server2";
    public static final String HMS_SOURCE = "hive_metastore";
    public static final String IMPALA_SOURCE = "impala";
    public static final String STORM_SOURCE = "storm";
    public static final String FILE_SPOOL_SOURCE = "file_spool";
    public static final String AUDIT_REDUCTION_TYPE_NAME = "__auditReductionInfo";
    public static final String AUDIT_AGING_TYPE_KEY = "auditAgingType";
    public static final String AUDIT_AGING_TTL_KEY = "ttl";
    public static final String AUDIT_AGING_COUNT_KEY = "auditCount";
    public static final String AUDIT_AGING_ENTITY_TYPES_KEY = "entityTypes";
    public static final String AUDIT_AGING_ACTION_TYPES_KEY = "actionTypes";
    public static final String AUDIT_AGING_EXCLUDE_ENTITY_TYPES_KEY = "excludeEntityTypes";
    public static final String CREATE_EVENTS_AGEOUT_ALLOWED_KEY = "createEventsAgeoutAllowed";
    public static final String AUDIT_AGING_SUBTYPES_INCLUDED_KEY = "subTypesIncluded";

    private Constants() {
    }

    private static String getEncodedTypePropertyKey(String defaultKey) {
        try {
            Configuration configuration = ApplicationProperties.get();
            if (configuration.containsKey("atlas.graph.index.search.backend") && configuration.getString("atlas.graph.index.search.backend").equals("elasticsearch")) {
                return defaultKey.replaceAll("\\.", "_");
            }
            return AtlasStructType.AtlasAttribute.encodePropertyKey((String)defaultKey);
        }
        catch (AtlasException e) {
            return AtlasStructType.AtlasAttribute.encodePropertyKey((String)defaultKey);
        }
    }

    public static enum SupportedFileExtensions {
        XLSX,
        XLS,
        CSV;

    }

    public static enum AtlasAuditAgingType {
        DEFAULT,
        CUSTOM,
        SWEEP;

    }
}

