/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.model.instance.AtlasEntity;

public class PathExtractorContext {
    private final String metadataNamespace;
    private final Map<String, AtlasEntity> knownEntities;
    private final boolean isConvertPathToLowerCase;
    private final String awsS3AtlasModelVersion;

    public PathExtractorContext(String metadataNamespace) {
        this(metadataNamespace, new HashMap<String, AtlasEntity>(), false, null);
    }

    public PathExtractorContext(String metadataNamespace, String awsS3AtlasModelVersion) {
        this(metadataNamespace, new HashMap<String, AtlasEntity>(), false, awsS3AtlasModelVersion);
    }

    public PathExtractorContext(String metadataNamespace, boolean isConvertPathToLowerCase, String awsS3AtlasModelVersion) {
        this(metadataNamespace, new HashMap<String, AtlasEntity>(), isConvertPathToLowerCase, awsS3AtlasModelVersion);
    }

    public PathExtractorContext(String metadataNamespace, Map<String, AtlasEntity> knownEntities, boolean isConvertPathToLowerCase, String awsS3AtlasModelVersion) {
        this.metadataNamespace = metadataNamespace;
        this.knownEntities = knownEntities;
        this.isConvertPathToLowerCase = isConvertPathToLowerCase;
        this.awsS3AtlasModelVersion = awsS3AtlasModelVersion;
    }

    public String getMetadataNamespace() {
        return this.metadataNamespace;
    }

    public Map<String, AtlasEntity> getKnownEntities() {
        return this.knownEntities;
    }

    public void putEntity(String qualifiedName, AtlasEntity entity) {
        this.knownEntities.put(qualifiedName, entity);
    }

    public AtlasEntity getEntity(String qualifiedName) {
        return this.knownEntities.get(qualifiedName);
    }

    public boolean isConvertPathToLowerCase() {
        return this.isConvertPathToLowerCase;
    }

    public String getAwsS3AtlasModelVersion() {
        return this.awsS3AtlasModelVersion;
    }
}

