/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.model;

import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.tagsync.model.TagSink;
import org.apache.ranger.tagsync.model.TagSource;
import org.apache.ranger.tagsync.process.TagSyncConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTagSource
implements TagSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTagSource.class);
    private TagSink tagSink;
    private String name;

    @Override
    public void setTagSink(TagSink sink) {
        if (sink == null) {
            LOG.error("Sink is null!!!");
        } else {
            this.tagSink = sink;
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    protected void updateSink(ServiceTags toUpload) throws Exception {
        try {
            if (toUpload == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No ServiceTags to upload");
                }
            } else {
                if (!TagSyncConfig.isTagSyncServiceActive()) {
                    LOG.error("This TagSync server is not in active state. Cannot commit transaction!");
                    throw new RuntimeException("This TagSync server is not in active state. Cannot commit transaction!");
                }
                if (LOG.isDebugEnabled()) {
                    String toUploadJSON = JsonUtils.objectToJson((Object)toUpload);
                    LOG.debug("Uploading serviceTags=" + toUploadJSON);
                }
                ServiceTags uploaded = this.tagSink.upload(toUpload);
                if (LOG.isDebugEnabled()) {
                    String uploadedJSON = JsonUtils.objectToJson((Object)uploaded);
                    LOG.debug("Uploaded serviceTags=" + uploadedJSON);
                }
            }
        }
        catch (Exception exception) {
            LOG.error("Failed to upload serviceTags: " + JsonUtils.objectToJson((Object)toUpload));
            LOG.error("Exception : ", (Throwable)exception);
            throw exception;
        }
    }
}

