/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.nestedstructureplugin;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;

public class AtlasNestedStructureResourceMapper
extends AtlasResourceMapper {
    public static final String RANGER_SERVICETYPE = "nestedstructure";
    public static final String ENTITY_TYPE_NESTEDSTRUCTURE_SCHEMA = "json_object";
    public static final String ENTITY_TYPE_NESTEDSTRUCTURE_FIELD = "json_field";
    public static final String RANGER_TYPE_NESTEDSTRUCTURE_SCHEMA = "schema";
    public static final String RANGER_TYPE_NESTEDSTRUCTURE_FIELD = "field";
    public static final String QUALIFIED_NAME_DELIMITER = "#";
    public static final String[] SUPPORTED_ENTITY_TYPES = new String[]{"json_object", "json_field"};

    public AtlasNestedStructureResourceMapper() {
        super(RANGER_SERVICETYPE, SUPPORTED_ENTITY_TYPES);
    }

    @Override
    public RangerServiceResource buildResource(RangerAtlasEntity entity) throws Exception {
        String clusterName;
        String qualifiedName = (String)entity.getAttributes().get("qualifiedName");
        if (StringUtils.isEmpty((String)qualifiedName)) {
            throw new Exception("attribute 'qualifiedName' not found in entity");
        }
        String resourceStr = this.getResourceNameFromQualifiedName(qualifiedName);
        if (StringUtils.isEmpty((String)resourceStr)) {
            this.throwExceptionWithMessage("resource not found in attribute 'qualifiedName': " + qualifiedName);
        }
        if (StringUtils.isEmpty((String)(clusterName = this.getClusterNameFromQualifiedName(qualifiedName)))) {
            clusterName = this.defaultClusterName;
        }
        String entityType = entity.getTypeName();
        String entityGuid = entity.getGuid();
        String serviceName = this.getRangerServiceName(clusterName);
        String[] resources = resourceStr.split(QUALIFIED_NAME_DELIMITER);
        String schemaName = resources.length > 0 ? resources[0] : null;
        String fieldName = resources.length > 1 ? resources[1] : null;
        HashMap<String, RangerPolicy.RangerPolicyResource> elements = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_NESTEDSTRUCTURE_SCHEMA)) {
            if (StringUtils.isNotEmpty((String)schemaName)) {
                elements.put(RANGER_TYPE_NESTEDSTRUCTURE_SCHEMA, new RangerPolicy.RangerPolicyResource(schemaName));
            }
        } else if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_NESTEDSTRUCTURE_FIELD)) {
            if (StringUtils.isNotEmpty((String)schemaName) && StringUtils.isNotEmpty((String)fieldName)) {
                elements.put(RANGER_TYPE_NESTEDSTRUCTURE_SCHEMA, new RangerPolicy.RangerPolicyResource(schemaName));
                elements.put(RANGER_TYPE_NESTEDSTRUCTURE_FIELD, new RangerPolicy.RangerPolicyResource(fieldName));
            }
        } else {
            this.throwExceptionWithMessage("unrecognized entity-type: " + entityType);
        }
        if (elements.isEmpty()) {
            this.throwExceptionWithMessage("invalid qualifiedName for entity-type '" + entityType + "': " + qualifiedName);
        }
        RangerServiceResource ret = new RangerServiceResource(entityGuid, serviceName, elements);
        return ret;
    }
}

