/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.spool.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class IndexRecord
implements Serializable {
    public static final int RECORD_SIZE = 500;
    public static final String STATUS_PENDING = "PENDING";
    public static final String STATUS_WRITE_IN_PROGRESS = "WRITE_IN_PROGRESS";
    public static final String STATUS_READ_IN_PROGRESS = "READ_IN_PROGRESS";
    public static final String STATUS_DONE = "DONE";
    private String id;
    private String path;
    private int line;
    private long created;
    private long writeCompleted;
    private long doneCompleted;
    private long lastSuccess;
    private long lastFailed;
    private boolean lastAttempt;
    private int failedAttempt;
    private String status;

    public IndexRecord() {
        this.status = STATUS_WRITE_IN_PROGRESS;
        this.lastAttempt = false;
    }

    public IndexRecord(String path) {
        this.id = UUID.randomUUID().toString();
        this.path = path;
        this.failedAttempt = 0;
        this.status = STATUS_WRITE_IN_PROGRESS;
        this.created = System.currentTimeMillis();
        this.setLastAttempt(false);
    }

    public String toString() {
        return "IndexRecord [id=" + this.id + ", filePath=" + this.path + ", linePosition=" + this.line + ", status=" + this.status + ", fileCreateTime=" + this.created + ", writeCompleteTime=" + this.writeCompleted + ", doneCompleteTime=" + this.doneCompleted + ", lastSuccessTime=" + this.lastSuccess + ", lastFailedTime=" + this.lastFailed + ", failedAttemptCount=" + this.failedAttempt + ", lastAttempt=" + this.lastAttempt + "]";
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setCreated(long fileCreateTime) {
        this.created = fileCreateTime;
    }

    public long getCreated() {
        return this.created;
    }

    public void setWriteCompleted(long writeCompleted) {
        this.writeCompleted = writeCompleted;
    }

    public long getWriteCompleted() {
        return this.writeCompleted;
    }

    public void setDoneCompleted(long doneCompleted) {
        this.doneCompleted = doneCompleted;
    }

    public long getDoneCompleted() {
        return this.doneCompleted;
    }

    public void setLastSuccess(long lastSuccess) {
        this.lastSuccess = lastSuccess;
    }

    public long getLastSuccess() {
        return this.lastSuccess;
    }

    public void setLastFailed(long lastFailed) {
        this.lastFailed = lastFailed;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setLastAttempt(boolean lastAttempt) {
        this.lastAttempt = lastAttempt;
    }

    public void setFailedAttempt(int failedAttempt) {
        this.failedAttempt = failedAttempt;
    }

    public int getFailedAttempt() {
        return this.failedAttempt;
    }

    @JsonIgnore
    public void setDone() {
        this.setStatus(STATUS_DONE);
        this.setDoneCompleted(System.currentTimeMillis());
        this.setLastAttempt(true);
    }

    @JsonIgnore
    public void setStatusPending() {
        this.setStatus(STATUS_PENDING);
        this.setWriteCompleted(System.currentTimeMillis());
        this.setLastAttempt(true);
    }

    @JsonIgnore
    public void updateFailedAttempt() {
        this.setLastFailed(System.currentTimeMillis());
        this.incrementFailedAttemptCount();
        this.setLastAttempt(false);
    }

    @JsonIgnore
    public boolean equals(IndexRecord record) {
        return this.id.equals(record.getId());
    }

    @JsonIgnore
    public void setCurrentLine(int line) {
        this.setLine(line);
        this.setStatus(STATUS_READ_IN_PROGRESS);
        this.setLastSuccess(System.currentTimeMillis());
        this.setLastAttempt(true);
    }

    @JsonIgnore
    public boolean isStatusDone() {
        return this.status.equals(STATUS_DONE);
    }

    @JsonIgnore
    public boolean isStatusWriteInProgress() {
        return this.status.equals(STATUS_WRITE_IN_PROGRESS);
    }

    @JsonIgnore
    public boolean isStatusReadInProgress() {
        return this.status.equals(STATUS_READ_IN_PROGRESS);
    }

    @JsonIgnore
    public void incrementFailedAttemptCount() {
        ++this.failedAttempt;
    }
}

