/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.spool.utils.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.TimeUnit;
import org.apache.atlas.notification.spool.SpoolUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileOperation {
    private static final Logger LOG = LoggerFactory.getLogger(FileOperation.class);
    private static final int MAX_RETRY_ATTEMPTS = 5;
    private static final String RANDOM_ACCESS_FILE_OPEN_MODE_RWS = "rws";
    private static final String RANDOM_ACCESS_FILE_OPEN_MODE_R = "r";
    private final String source;
    private File file;
    private String id;

    public static RandomAccessFile createRandomAccessFileForRead(File file) throws FileNotFoundException {
        return new RandomAccessFile(file, RANDOM_ACCESS_FILE_OPEN_MODE_R);
    }

    public static RandomAccessFile createRandomAccessFile(File file) throws FileNotFoundException {
        return new RandomAccessFile(file, RANDOM_ACCESS_FILE_OPEN_MODE_RWS);
    }

    public static long find(RandomAccessFile raf, String id) throws IOException {
        String line;
        while (!StringUtils.isEmpty((String)(line = raf.readLine()))) {
            if (!line.contains(id)) continue;
            return raf.getChannel().position() - (long)SpoolUtils.getLineSeparator().length() - 500L;
        }
        return -1L;
    }

    public FileOperation(String source) {
        this(source, false);
    }

    public FileOperation(String source, boolean notifyConcurrency) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void perform(File file) {
        this.perform(file, "");
    }

    public void perform(File file, String json) {
        this.setFile(file);
        this.performWithRetry(file, json);
    }

    public void perform(File file, String id, String json) {
        this.setId(id);
        this.perform(file, json);
    }

    public abstract FileLock run(RandomAccessFile var1, FileChannel var2, String var3) throws IOException;

    protected File getFile() {
        return this.file;
    }

    protected String getId() {
        return this.id;
    }

    protected void close(RandomAccessFile randomAccessFile, FileChannel channel, FileLock lock) {
        try {
            if (channel != null) {
                channel.force(true);
            }
            if (lock != null) {
                lock.release();
            }
            if (channel != null) {
                channel.close();
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (IOException exception) {
            LOG.error("FileOperation(source={}).close(): failed", (Object)this.getSource(), (Object)exception);
        }
    }

    private void setFile(File file) {
        this.file = file;
    }

    private void performWithRetry(File file, String json) {
        for (int i = 0; i < 5; ++i) {
            try {
                this.performOperation(json);
                return;
            }
            catch (OverlappingFileLockException e) {
                try {
                    int timeout = 1 + 50 * RandomUtils.nextInt((int)10);
                    LOG.info("FileOperation.performWithRetry(source={}): {}: {}: Waiting: {} ms...", new Object[]{this.getSource(), this.getClass().getSimpleName(), file.getName(), timeout});
                    TimeUnit.MILLISECONDS.sleep(timeout);
                }
                catch (InterruptedException ex) {
                    LOG.error("FileOperation.performWithRetry(source={}): {}: Interrupted!", new Object[]{this.getSource(), file.getAbsolutePath(), ex});
                }
                LOG.info("FileOperation.performWithRetry(source={}): {}: Re-trying: {}!", new Object[]{this.getSource(), file.getAbsolutePath(), i});
                continue;
            }
        }
        LOG.info("FileOperation.performWithRetry(source={}): {}: appendRecord: Could not write.", (Object)this.getSource(), (Object)file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean performOperation(String json) {
        RandomAccessFile randomAccessFile = null;
        FileChannel channel = null;
        FileLock lock = null;
        try {
            randomAccessFile = new RandomAccessFile(this.getFile(), RANDOM_ACCESS_FILE_OPEN_MODE_RWS);
            channel = randomAccessFile.getChannel();
            lock = this.run(randomAccessFile, channel, json);
            this.close(randomAccessFile, channel, lock);
        }
        catch (FileNotFoundException e) {
            LOG.error("FileOperation.performOperation(source={}): file={}: file not found", new Object[]{this.getSource(), this.getFile().getAbsolutePath(), e});
            this.close(randomAccessFile, channel, lock);
        }
        catch (IOException exception) {
            LOG.error("FileOperation.performOperation(source={}): file={}: failed", (Object)this.getSource(), (Object)this.getFile().getAbsolutePath());
            this.close(randomAccessFile, channel, lock);
            {
                catch (Throwable throwable) {
                    this.close(randomAccessFile, channel, lock);
                    throw throwable;
                }
            }
        }
        return true;
    }
}

